/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.resourceloading.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.IPapyrusRunnable;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.services.resourceloading.Activator;
import org.eclipse.papyrus.infra.services.resourceloading.Messages;
import org.eclipse.papyrus.infra.tools.notify.NotificationBuilder;
import org.eclipse.papyrus.infra.tools.notify.Type;
import org.eclipse.papyrus.infra.tools.util.CoreExecutors;
import org.eclipse.papyrus.infra.tools.util.IProgressRunnable;

public class LoadingUtils {
    public static void loadResourcesInModelSet(ModelSet modelSet, URI uriWithoutFileExtension) {
        NotificationBuilder error = NotificationBuilder.createAsyncPopup((String)Messages.LoadingUtils_ErrorTitle, (String)String.format(Messages.LoadingUtils_ErrorMessage, uriWithoutFileExtension.toString())).setType(Type.ERROR).setDelay(2000L);
        LoadingUtils.runInEditingDomain(modelSet, monitor -> {
            try {
                try {
                    IPageManager pageMngr = ServiceUtilsForResourceSet.getInstance().getIPageManager((Object)modelSet);
                    List allPages = pageMngr.allPages();
                    monitor.beginTask(Messages.LoadingUtils_RefreshPagesTask, allPages.size());
                    for (Object o : allPages) {
                        InternalEObject internal;
                        URI uriProxy;
                        URI trimFragment;
                        EObject eobject;
                        if (o instanceof EObject && (eobject = (EObject)o).eIsProxy() && uriWithoutFileExtension.equals((trimFragment = (uriProxy = (internal = (InternalEObject)eobject).eProxyURI()).trimFragment()).trimFileExtension())) {
                            try {
                                Resource r = modelSet.getResource(trimFragment, true);
                                if (r != null) {
                                    EObject newEObject = r.getEObject(uriProxy.fragment());
                                    if (pageMngr.isOpen((Object)newEObject)) {
                                        pageMngr.selectPage((Object)newEObject);
                                    }
                                } else {
                                    error.run();
                                }
                            }
                            catch (Exception e) {
                                error.run();
                                Activator.logError(e);
                            }
                        }
                        monitor.worked(1);
                    }
                    Set<String> extensions = LoadingUtils.getExtensions(modelSet);
                    monitor.beginTask(Messages.LoadingUtils_LoadModelsTask, extensions.size());
                    for (String s : extensions) {
                        try {
                            URI uriToLoad = uriWithoutFileExtension.appendFileExtension(s);
                            Resource r = modelSet.getResource(uriToLoad, true);
                            if (r == null) {
                                error.run();
                            }
                        }
                        catch (Exception re) {
                            error.run();
                            Activator.logError(re);
                        }
                        monitor.worked(1);
                    }
                }
                catch (ServiceException e) {
                    Activator.logError((Exception)((Object)e));
                }
            }
            finally {
                monitor.done();
            }
        });
    }

    public static void unloadResourcesFromModelSet(ModelSet modelSet, URI uriWithoutFileExtension) {
        LoadingUtils.runInEditingDomain(modelSet, monitor -> {
            try {
                monitor.beginTask(Messages.LoadingUtils_UnloadModelsTask, modelSet.getResources().size());
                String unloadPlatformString = uriWithoutFileExtension.isPlatform() ? uriWithoutFileExtension.toPlatformString(true) : URI.decode((String)uriWithoutFileExtension.toString());
                for (Resource res : new ArrayList(modelSet.getResources())) {
                    URI normalizedURI = res.getURI();
                    String platformString = normalizedURI.isPlatform() ? normalizedURI.trimFileExtension().toPlatformString(true) : URI.decode((String)normalizedURI.trimFileExtension().toString());
                    if (platformString != null && platformString.equals(unloadPlatformString)) {
                        res.unload();
                    }
                    monitor.worked(1);
                }
            }
            finally {
                monitor.done();
            }
        });
    }

    static void runInEditingDomain(ModelSet modelSet, IPapyrusRunnable runnable) {
        try {
            IProgressRunnable privileged = TransactionHelper.createPrivilegedRunnable((TransactionalEditingDomain)modelSet.getTransactionalEditingDomain(), (IProgressRunnable)runnable);
            privileged = ServiceUtilsForResourceSet.getInstance().runnable(privileged, (Object)modelSet);
            CoreExecutors.getUIExecutorService().syncExec(privileged);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    private static Set<String> getExtensions(ModelSet modelSet) {
        HashSet<String> result = new HashSet<String>();
        result.add("notation");
        result.add("di");
        Collection languageModels = ILanguageService.getLanguageModels((ModelSet)modelSet);
        if (languageModels.isEmpty()) {
            Activator.log.warn("Semantic service unavailable. Assuming a UML model.");
            result.add("uml");
        } else {
            for (IModel model : languageModels) {
                URI uri;
                if (!(model instanceof AbstractBaseModel) || (uri = ((AbstractBaseModel)model).getResourceURI()) == null || uri.fileExtension() == null) continue;
                result.add(uri.fileExtension());
            }
        }
        return result;
    }

    public static IFile getFile(URI uri) {
        IPath path = LoadingUtils.getPath(uri);
        if (path != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        return null;
    }

    public static IPath getPath(URI uri) {
        String scheme = uri.scheme();
        IPath path = null;
        if ("platform".equals(scheme)) {
            path = Path.fromPortableString((String)uri.toPlatformString(true));
        } else if ("file".equals(scheme)) {
            path = Path.fromPortableString((String)uri.toFileString());
        }
        return path;
    }
}

