/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.dnd.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.activity.dnd.Messages;
import org.eclipse.papyrus.uml.diagram.activity.dnd.commands.CreateTAndUpdateCommand;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateAcceptEventActionAndUpdateCommand<T extends EObject, E extends EObject, S extends EObject>
extends CreateTAndUpdateCommand<T, E, S> {
    private static final String EVENT_PACKAGE_NAME = Messages.CreateAcceptEventActionAndUpdateCommand_PackageName;

    public CreateAcceptEventActionAndUpdateCommand(EditPart targetEditPart, Class<T> typeParameterClass, E targetElementDiagram, S sourceElement, boolean headless, IHintedType typeToCreate, Point location, String dropEditPartVisualID) {
        super(targetEditPart, typeParameterClass, targetElementDiagram, sourceElement, headless, typeToCreate, null, location, dropEditPartVisualID);
    }

    @Override
    protected void updateNewlyCreatedEObjectWithEObjectDragged(T slot, S property) throws ExecutionException {
        AcceptEventAction action = (AcceptEventAction)slot;
        action.setIsUnmarshall(true);
        Signal signal = (Signal)this.sourceElement;
        EObject newCreatedElement = null;
        newCreatedElement = !action.getTriggers().isEmpty() ? (EObject)action.getTriggers().get(0) : this.createElement((EObject)action, (IElementType)UMLElementTypes.TRIGGER);
        if (newCreatedElement == null || !(newCreatedElement instanceof Trigger)) {
            return;
        }
        Trigger trigger = (Trigger)newCreatedElement;
        Package packageEvent = this.getEventPackage((Element)action);
        newCreatedElement = this.createElement((EObject)packageEvent, (IElementType)UMLElementTypes.SIGNAL_EVENT);
        if (newCreatedElement == null || !(newCreatedElement instanceof SignalEvent)) {
            return;
        }
        SignalEvent signalEvent = (SignalEvent)newCreatedElement;
        this.setElementFeature((EObject)signalEvent, (EStructuralFeature)UMLPackage.eINSTANCE.getSignalEvent_Signal(), signal);
        this.setElementFeature((EObject)trigger, (EStructuralFeature)UMLPackage.eINSTANCE.getTrigger_Event(), signalEvent);
    }

    private Package getEventPackage(Element context) throws ExecutionException {
        Package ret = null;
        Model root = context.getModel();
        ret = root.getNestedPackage(EVENT_PACKAGE_NAME);
        if (ret == null) {
            EObject newElement = this.createElement((EObject)root, (IElementType)UMLElementTypes.PACKAGE);
            if (newElement == null || !(newElement instanceof Package)) {
                return null;
            }
            ret = (Package)newElement;
            ret.setName(EVENT_PACKAGE_NAME);
        }
        return ret;
    }

    private EObject createElement(EObject owner, IElementType type) throws ExecutionException {
        CommandResult commandResult;
        TransactionalEditingDomain domain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((Object)this.targetEditPart);
        CreateElementRequest createElementRequest = new CreateElementRequest(domain, owner, type);
        CreateElementCommand creationElementCommand = new CreateElementCommand(createElementRequest);
        if (creationElementCommand.canExecute()) {
            creationElementCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        if ((commandResult = creationElementCommand.getCommandResult()) != null && !commandResult.getStatus().isOK()) {
            return null;
        }
        return commandResult.getReturnValue() instanceof EObject ? (EObject)commandResult.getReturnValue() : null;
    }
}

