/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.uml.diagram.common.commands.ShowHideLabelsRequest;
import org.eclipse.papyrus.uml.diagram.common.editparts.ILabelRoleProvider;
import org.eclipse.papyrus.uml.diagram.menu.Activator;
import org.eclipse.papyrus.uml.diagram.menu.actions.AbstractGraphicalParametricAction;
import org.eclipse.papyrus.uml.diagram.menu.dialogs.ShowHideLabelSelectionDialog;
import org.eclipse.papyrus.uml.diagram.menu.messages.Messages;

public class ShowHideLabelsAction
extends AbstractGraphicalParametricAction {
    public static final String MANAGE_PARAMETER = "manage";
    public static final String HIDE_PARAMETER = "hide";
    public static final String SHOW_PARAMETER = "show";
    public ILabelProvider labelProvider;
    public ITreeContentProvider contentProvider;
    private DiagramEditPart diagramEditPart;

    public ShowHideLabelsAction(String parameter, List<IGraphicalEditPart> selectedEditPart) {
        super(parameter, selectedEditPart);
        try {
            if (!selectedEditPart.isEmpty()) {
                this.diagramEditPart = DiagramEditPartsUtil.getDiagramEditPart((EditPart)((EditPart)selectedEditPart.get(0)));
                if (this.diagramEditPart != null) {
                    LabelProviderService labelProviderService = (LabelProviderService)ServiceUtilsForEditPart.getInstance().getServiceRegistry((EditPart)this.diagramEditPart).getService(LabelProviderService.class);
                    this.labelProvider = labelProviderService.getLabelProvider((Object)this.diagramEditPart);
                    this.contentProvider = new ContentProvider(this.diagramEditPart);
                }
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    protected Command getBuildedCommand() {
        List<IGraphicalEditPart> selections = this.getSelection();
        CompoundCommand cmd = new CompoundCommand("ShowHideConnectionLabelCommand");
        if (!selections.isEmpty()) {
            if (this.getParameter().equals(MANAGE_PARAMETER)) {
                ManageLabelsAction action = new ManageLabelsAction(Messages.ShowHideConnectionLabelsAction_LabelsManager, Messages.ShowHideConnectionLabelsAction_SelectTheLabelToDisplay, selections);
                cmd.add(action.getActionCommand());
            } else {
                for (IGraphicalEditPart current : selections) {
                    Object[] children;
                    Object[] objectArray = children = this.contentProvider.getChildren((Object)current);
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object currentObj = objectArray[n2];
                        if (currentObj instanceof View) {
                            Command tmp;
                            ShowHideLabelsRequest request = null;
                            if (this.getParameter().equals(HIDE_PARAMETER)) {
                                request = new ShowHideLabelsRequest(false, (View)currentObj);
                            } else if (this.getParameter().equals(SHOW_PARAMETER)) {
                                request = new ShowHideLabelsRequest(true, (View)currentObj);
                            }
                            if (request != null && (tmp = current.getCommand((Request)request)) != null) {
                                cmd.add(tmp);
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
        return cmd.canExecute() && !cmd.isEmpty() ? cmd : UnexecutableCommand.INSTANCE;
    }

    protected List<ConnectionEditPart> getConnections() {
        ArrayList<ConnectionEditPart> connections = new ArrayList<ConnectionEditPart>();
        for (IGraphicalEditPart current : this.getSelection()) {
            if (current instanceof DiagramEditPart && this.getSelection().size() == 1) {
                connections.addAll(((DiagramEditPart)current).getConnections());
                break;
            }
            if (!(current instanceof ConnectionEditPart)) continue;
            connections.add((ConnectionEditPart)current);
        }
        return connections;
    }

    protected boolean isLabelView(EditPart containerEditPart, View parentView, View view) {
        if ((containerEditPart instanceof ShapeNodeEditPart || containerEditPart instanceof ConnectionEditPart) && view instanceof Node) {
            LayoutConstraint lContraint;
            Node node = (Node)view;
            String nodeType = node.getType();
            if (!this.isCompartment(node) && nodeType != null && nodeType.length() > 0 && (lContraint = node.getLayoutConstraint()) instanceof Location) {
                IGraphicalEditPart ep1 = EditPartService.getInstance().createGraphicEditPart((View)node);
                return ep1 instanceof ILabelRoleProvider;
            }
        }
        return false;
    }

    protected boolean isCompartment(Node node) {
        return node.getStyle(NotationPackage.eINSTANCE.getDrawerStyle()) != null;
    }

    protected class ContentProvider
    extends TreeNodeContentProvider {
        private DiagramEditPart diagramEP;

        public ContentProvider(DiagramEditPart diagramEP) {
            this.diagramEP = diagramEP;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<View> children = new ArrayList<View>();
            if (parentElement instanceof EditPart) {
                View model = (View)((EditPart)parentElement).getModel();
                for (View childView : model.getChildren()) {
                    if (!ShowHideLabelsAction.this.isLabelView((EditPart)parentElement, model, childView)) continue;
                    children.add(childView);
                }
            }
            Collections.sort(children, new LabelRoleComparator());
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof View) {
                EditPart part = DiagramEditPartsUtil.getEditPartFromView((View)((View)element), (EditPart)this.diagramEP);
                return part.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length != 0;
        }
    }

    public class LabelRoleComparator
    implements Comparator<View> {
        @Override
        public int compare(View o1, View o2) {
            IGraphicalEditPart ep1 = EditPartService.getInstance().createGraphicEditPart(o1);
            IGraphicalEditPart ep2 = EditPartService.getInstance().createGraphicEditPart(o2);
            if (ep1 instanceof ILabelRoleProvider && ep2 instanceof ILabelRoleProvider) {
                String role1 = ((ILabelRoleProvider)ep1).getLabelRole();
                String role2 = ((ILabelRoleProvider)ep2).getLabelRole();
                return role1.compareToIgnoreCase(role2);
            }
            return 0;
        }
    }

    public class ManageLabelsAction {
        protected Map<View, Boolean> viewStatus = new HashMap<View, Boolean>();
        private String title;
        private String message;
        private List<IGraphicalEditPart> editparts;

        public ManageLabelsAction(String title, String message, List<IGraphicalEditPart> editparts) {
            this.title = title;
            this.message = message;
            this.editparts = editparts;
            this.initMap();
        }

        protected Command getActionCommand() {
            CompoundCommand cmd = new CompoundCommand("Manage Conection Labels ");
            ShowHideLabelSelectionDialog selectionDialog = new ShowHideLabelSelectionDialog(DisplayUtils.getDisplay().getActiveShell(), ShowHideLabelsAction.this.labelProvider, ShowHideLabelsAction.this.contentProvider);
            selectionDialog.setTitle(this.title);
            selectionDialog.setMessage(this.message);
            selectionDialog.setContainerMode(true);
            selectionDialog.setInput(this.editparts);
            selectionDialog.setExpandedElements(this.editparts.toArray());
            selectionDialog.setInitialElementSelections(this.getInitialSelection());
            selectionDialog.open();
            if (selectionDialog.getReturnCode() == 0) {
                Object[] userSelection;
                Object[] objectArray = userSelection = selectionDialog.getResult();
                int n = userSelection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object current = objectArray[n2];
                    if (!(current instanceof EditPart) && current instanceof View) {
                        this.viewStatus.put((View)current, new Boolean(true));
                    }
                    ++n2;
                }
                for (View view : this.viewStatus.keySet()) {
                    Command command;
                    boolean newStatus;
                    boolean oldStatus = view.isVisible();
                    if (oldStatus == (newStatus = this.viewStatus.get(view).booleanValue())) continue;
                    ShowHideLabelsRequest request = new ShowHideLabelsRequest(newStatus, view);
                    EObject parentView = view.eContainer();
                    EditPart parentEditPart = null;
                    if (parentView instanceof View && ((View)parentView).getElement() == view.getElement()) {
                        parentEditPart = DiagramEditPartsUtil.getEditPartFromView((View)((View)parentView), (EditPart)((EditPart)ShowHideLabelsAction.this.getSelection().get(0)));
                    }
                    if (parentEditPart == null || (command = parentEditPart.getCommand((Request)request)) == null) continue;
                    cmd.add(command);
                }
                return cmd;
            }
            return UnexecutableCommand.INSTANCE;
        }

        public List<View> getInitialSelection() {
            ArrayList<View> selection = new ArrayList<View>();
            for (IGraphicalEditPart current : ShowHideLabelsAction.this.getSelection()) {
                View model = (View)current.getModel();
                for (View childView : model.getChildren()) {
                    if (!ShowHideLabelsAction.this.isLabelView((EditPart)current, model, childView) || !childView.isVisible()) continue;
                    selection.add(childView);
                }
            }
            return selection;
        }

        public void initMap() {
            this.viewStatus.clear();
            for (EditPart editPart : ShowHideLabelsAction.this.getSelection()) {
                View model = (View)((IGraphicalEditPart)editPart).getModel();
                for (View childView : model.getChildren()) {
                    if (!ShowHideLabelsAction.this.isLabelView(editPart, model, childView)) continue;
                    this.viewStatus.put(childView, new Boolean(false));
                }
            }
        }
    }
}

