/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.common.transformation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.AdvancedConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.MappingParameters;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.MigrationParametersFactory;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.URIMapping;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IDependencyAnalysisHelper;

public abstract class AbstractDependencyAnalysisHelper
implements IDependencyAnalysisHelper {
    protected final ThreadConfig config;
    protected final Set<String> softwareExtensions;
    protected final String softwareProfileExtension;
    protected final ResourceSet localResourceSet = new ResourceSetImpl();
    protected final Map<URI, Set<String>> brokenUris = new HashMap<URI, Set<String>>();
    protected final Set<URI> brokenProfiles = new HashSet<URI>();

    public AbstractDependencyAnalysisHelper(ThreadConfig config, Set<String> softwareExtensions, String softwareProfileExtension) {
        this.config = config;
        this.softwareExtensions = softwareExtensions;
        this.softwareProfileExtension = softwareProfileExtension;
        this.configureResourceSet();
    }

    protected void configureResourceSet() {
        this.localResourceSet.getLoadOptions().put("DEFER_ATTACHMENT", true);
        this.localResourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
        this.localResourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        this.localResourceSet.getLoadOptions().put("USE_PACKAGE_NS_URI_AS_LOCATION", Boolean.FALSE);
    }

    protected void unloadResourceSet() {
        EMFHelper.unload((ResourceSet)this.localResourceSet);
    }

    @Override
    public void computeURIMappings(Collection<Resource> sourceModels) {
        for (Resource sourceModel : sourceModels) {
            this.doComputeURIMappings(sourceModel);
        }
    }

    @Override
    public synchronized void resolveAllMappings(Map<URI, URI> urisToReplace, Map<URI, URI> profileUrisToReplace) {
        if (this.config instanceof AdvancedConfig) {
            if (((AdvancedConfig)this.config).getMappingParameters() == null) {
                ((AdvancedConfig)this.config).setMappingParameters(MigrationParametersFactory.eINSTANCE.createMappingParameters());
            }
            try {
                for (Map.Entry<URI, Set<String>> resourceToRepair : this.brokenUris.entrySet()) {
                    if (urisToReplace.containsKey(resourceToRepair.getKey())) continue;
                    this.findMatch(resourceToRepair.getKey(), resourceToRepair.getValue());
                }
                for (URI profileDefinition : this.brokenProfiles) {
                    if (profileUrisToReplace.containsKey(profileDefinition.trimFragment().trimQuery())) continue;
                    this.findMatch(profileDefinition);
                }
            }
            finally {
                this.unloadResourceSet();
                this.brokenUris.clear();
                this.brokenProfiles.clear();
            }
        }
    }

    protected void findMatch(URI resourceURI, Set<String> fragments) {
        if (this.config instanceof AdvancedConfig) {
            URIMapping mapping = null;
            for (String fragment : fragments) {
                URI eObjectURI = resourceURI.appendFragment(fragment);
                mapping = this.findExistingMapping(eObjectURI, this.localResourceSet);
                if (mapping != null) break;
            }
            if (mapping == null) {
                mapping = MigrationParametersFactory.eINSTANCE.createURIMapping();
                mapping.setSourceURI(resourceURI.toString());
                mapping.setTargetURI(mapping.getSourceURI());
            }
            ((AdvancedConfig)this.config).getMappingParameters().getUriMappings().add((Object)mapping);
        }
    }

    protected void findMatch(URI profileDefinitionURI) {
        if (this.config instanceof AdvancedConfig) {
            URIMapping match = this.findExistingProfileMapping(profileDefinitionURI, this.localResourceSet);
            if (match == null) {
                match = MigrationParametersFactory.eINSTANCE.createURIMapping();
                match.setSourceURI(profileDefinitionURI.trimFragment().trimQuery().toString());
                match.setTargetURI(match.getSourceURI());
            }
            ((AdvancedConfig)this.config).getMappingParameters().getProfileUriMappings().add((Object)match);
        }
    }

    protected void doComputeURIMappings(Resource sourceModel) {
        this.doComputeProfileURIMappings(sourceModel);
        TreeIterator resourceContents = sourceModel.getAllContents();
        ResourceSet resourceSet = sourceModel.getResourceSet();
        while (resourceContents.hasNext()) {
            EObject next = (EObject)resourceContents.next();
            for (EReference reference : next.eClass().getEAllReferences()) {
                if (reference.isContainer() || reference.isContainment() || reference.isDerived() || reference.isTransient()) continue;
                Object value = next.eGet((EStructuralFeature)reference, false);
                if (value instanceof EObject) {
                    this.handleURIMapping((EObject)value, resourceSet);
                    continue;
                }
                if (!(value instanceof Collection)) continue;
                for (Object element : (Collection)value) {
                    if (!(element instanceof EObject)) continue;
                    this.handleURIMapping((EObject)element, resourceSet);
                }
            }
        }
    }

    protected void doComputeProfileURIMappings(Resource sourceModel) {
        ResourceSet resourceSet = sourceModel.getResourceSet();
        for (EObject rootObject : sourceModel.getContents()) {
            if (!this.isInvalidStereotypeApplication(rootObject)) continue;
            this.handleProfileURIMapping(rootObject, resourceSet);
        }
    }

    protected abstract boolean isInvalidStereotypeApplication(EObject var1);

    protected boolean isSoftwareModelElement(EObject eObject) {
        return this.isSoftwareModelElement(EcoreUtil.getURI((EObject)eObject));
    }

    protected boolean isSoftwareModelElement(URI objectURI) {
        String fileExtension = objectURI.fileExtension();
        return this.softwareExtensions.contains(fileExtension) || this.softwareProfileExtension.equals(fileExtension);
    }

    protected synchronized Set<String> getFragments(URI resourceURI) {
        if (!this.brokenUris.containsKey(resourceURI)) {
            this.brokenUris.put(resourceURI, new HashSet());
        }
        return this.brokenUris.get(resourceURI);
    }

    protected synchronized void handleBrokenReference(EObject proxy) {
        URI proxyURI = EcoreUtil.getURI((EObject)proxy);
        URI resourceURI = proxyURI.trimFragment().trimQuery();
        String fragment = proxyURI.fragment();
        Set<String> fragments = this.getFragments(resourceURI);
        fragments.add(fragment);
    }

    protected synchronized void addBrokenProfileDefinition(URI packageURI) {
        this.brokenProfiles.add(packageURI);
    }

    protected void handleProfileURIMapping(EObject stereotypeApplication, ResourceSet resourceSet) {
        EPackage profileDefinition = stereotypeApplication.eClass().getEPackage();
        URI packageURI = EcoreUtil.getURI((EObject)profileDefinition);
        if (packageURI.trimFragment().isEmpty()) {
            packageURI = URI.createURI((String)profileDefinition.getNsURI());
        }
        this.addBrokenProfileDefinition(packageURI);
    }

    protected void handleURIMapping(EObject eObject, ResourceSet resourceSet) {
        if (this.isSoftwareModelElement(eObject)) {
            this.handleBrokenReference(eObject);
            return;
        }
        if (eObject.eIsProxy() && (eObject = EcoreUtil.resolve((EObject)eObject, (ResourceSet)resourceSet)).eIsProxy()) {
            this.handleBrokenReference(eObject);
            return;
        }
    }

    protected URIMapping findExistingProfileMapping(URI profileDefinitionURI, ResourceSet resourceSet) {
        throw new UnsupportedOperationException();
    }

    protected boolean isPathFragment(URI proxyURI) {
        String uriFragment = proxyURI.fragment();
        return uriFragment != null && uriFragment.charAt(0) == '/';
    }

    protected URIMapping findExistingMapping(URI proxyURI, ResourceSet resourceSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void propagateURIMappings(List<URIMapping> allMappings, MappingParameters result) {
        for (URIMapping mapping : allMappings) {
            for (URIMapping uriMapping : result.getUriMappings()) {
                if (!uriMapping.getSourceURI().equals(mapping.getSourceURI())) continue;
                uriMapping.setTargetURI(mapping.getTargetURI());
            }
            for (URIMapping profileURIMapping : result.getProfileUriMappings()) {
                if (!profileURIMapping.getSourceURI().equals(mapping.getSourceURI())) continue;
                profileURIMapping.setTargetURI(mapping.getTargetURI());
            }
        }
    }

    @Override
    public List<URIMapping> flattenURIMappings(MappingParameters result) {
        LinkedList<URIMapping> allMappings = new LinkedList<URIMapping>();
        allMappings.addAll((Collection<URIMapping>)result.getUriMappings());
        allMappings.addAll((Collection<URIMapping>)result.getProfileUriMappings());
        this.removeDuplicates(allMappings);
        return allMappings;
    }

    protected void removeDuplicates(List<URIMapping> allMappings) {
        LinkedList<URIMapping> mappingsCopy = new LinkedList<URIMapping>(allMappings);
        block0: for (URIMapping mapping : mappingsCopy) {
            for (URIMapping m : allMappings) {
                if (m == mapping || !mapping.getSourceURI().equals(m.getSourceURI()) || !allMappings.contains(mapping) || !allMappings.contains(m)) continue;
                URIMapping mappingToRemove = this.findLessSpecificMapping(mapping, m);
                allMappings.remove(mappingToRemove);
                continue block0;
            }
        }
    }

    protected URIMapping findLessSpecificMapping(URIMapping mapping1, URIMapping mapping2) {
        if (!this.isUsefulMapping(mapping1)) {
            return mapping1;
        }
        return mapping2;
    }

    protected boolean isUsefulMapping(URIMapping mapping) {
        return mapping.getTargetURI() != null && !"".equals(mapping.getTargetURI()) && !mapping.getTargetURI().equals(mapping.getSourceURI());
    }
}

