/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class FileOrIFile {
    protected IFile ifile;
    protected File javaFile;

    public FileOrIFile(IFile file) {
        this.ifile = file;
        IPath location = file == null ? null : file.getLocation();
        this.javaFile = location == null ? null : location.toFile();
    }

    public FileOrIFile(File file) {
        this.javaFile = file;
        this.ifile = FileOrIFile.getIFileFor(file);
    }

    private static IFile getIFileFor(File file) {
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toURI());
        return files.length == 0 ? null : files[0];
    }

    public IFile getIFile() {
        return this.ifile;
    }

    public File getJavaFile() {
        return this.javaFile;
    }

    public String toString() {
        if (this.ifile != null) {
            return this.ifile.getFullPath().toOSString();
        }
        if (this.javaFile != null) {
            return this.javaFile.getAbsolutePath();
        }
        return "?";
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        FileOrIFile that = (FileOrIFile)o;
        return this.equals(this.ifile, that.ifile) && this.equals(this.javaFile, that.javaFile);
    }

    private boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        return a.equals(b);
    }

    public int hashCode() {
        return 13 * this.hashCode(this.ifile) + this.hashCode(this.javaFile);
    }

    private int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }
}

