/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.browser;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class EdgeArrow {
    public static final int arrowAngle = 30;
    public static final int arrowLength = 15;
    private Point source;
    private Point target;
    private Point midpoint;
    private Double angle;

    public EdgeArrow(Rectangle srcRect, Rectangle sinkRect) {
        this.setTargetAndSourcePoint(srcRect, sinkRect);
        this.setMidpoint();
        this.setAngleBetweenLineAndXAxis();
    }

    private void setTargetAndSourcePoint(Rectangle srcRect, Rectangle sinkRect) {
        if (srcRect.y < sinkRect.y) {
            this.target = new Point(sinkRect.x, sinkRect.y);
            this.source = new Point(srcRect.x, srcRect.y + srcRect.height);
        } else if (srcRect.y > sinkRect.y) {
            this.target = new Point(sinkRect.x, sinkRect.y + sinkRect.height);
            this.source = new Point(srcRect.x, srcRect.y);
        } else {
            this.target = new Point(sinkRect.x, sinkRect.height / 2 + sinkRect.y);
            this.source = new Point(srcRect.x, srcRect.height / 2 + srcRect.y);
        }
    }

    private void setMidpoint() {
        this.midpoint = new Point((this.source.x + this.target.x) / 2, (this.target.y + this.source.y) / 2);
    }

    private void setAngleBetweenLineAndXAxis() {
        this.angle = Math.atan2(this.target.y - this.source.y, this.target.x - this.source.x);
    }

    public void drawOn(GC gc) {
        this.drawLine(gc);
        this.drawArrow(gc);
    }

    private void drawLine(GC gc) {
        gc.drawLine(this.source.x, this.source.y, this.target.x, this.target.y);
    }

    private void drawArrow(GC gc) {
        int degreesBetweenArrowsAndLine = this.getDegrees(this.angle) + 30 + 180;
        double radiansBetweenArrowsAndLine = this.getRadians(degreesBetweenArrowsAndLine);
        Point arrowPoint1 = new Point(this.midpoint.x + (int)(15.0 * Math.cos(radiansBetweenArrowsAndLine)), this.midpoint.y + (int)(15.0 * Math.sin(radiansBetweenArrowsAndLine)));
        degreesBetweenArrowsAndLine = this.getDegrees(this.angle) - 30 + 180;
        radiansBetweenArrowsAndLine = this.getRadians(degreesBetweenArrowsAndLine);
        Point arrowPoint2 = new Point(this.midpoint.x + (int)(15.0 * Math.cos(radiansBetweenArrowsAndLine)), this.midpoint.y + (int)(15.0 * Math.sin(radiansBetweenArrowsAndLine)));
        gc.setLineWidth(gc.getLineWidth() + 2);
        gc.drawLine(this.midpoint.x, this.midpoint.y, arrowPoint1.x, arrowPoint1.y);
        gc.drawLine(this.midpoint.x, this.midpoint.y, arrowPoint2.x, arrowPoint2.y);
        gc.setLineWidth(gc.getLineWidth() - 2);
    }

    private double getRadians(double d) {
        return d * Math.PI / 180.0;
    }

    private int getDegrees(Double radians) {
        double degrees = 57.29577951308232 * radians;
        return (int)degrees;
    }
}

