/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.extensionpoint;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.extensionpoint.IBeforeTest;

public class BeforeTestInitialization {
    private static final Logger log = Logger.getLogger(BeforeTestInitialization.class);

    public static List<IBeforeTest> initialize() {
        LinkedList<IBeforeTest> beforeTestExts = new LinkedList<IBeforeTest>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.reddeer.junit.before.test");
        try {
            log.debug("Number of found extensions for extension point org.eclipse.reddeer.junit.before.test=" + configElements.length);
            IConfigurationElement[] iConfigurationElementArray = configElements;
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object object = e.createExecutableExtension("class");
                if (object instanceof IBeforeTest) {
                    beforeTestExts.add((IBeforeTest)object);
                } else {
                    log.warn("Invalid class used for extension point org.eclipse.reddeer.junit.before.test:" + object.getClass());
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            log.error("Error when processing extension for org.jbossreddeer.junit.before.test", new Object[]{ex.getMessage()});
        }
        return beforeTestExts;
    }
}

