/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePathViewerSorter;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tcf.te.ui.trees.Pending;

public class TreeViewerSorter
extends TreePathViewerSorter {
    protected boolean isCaseSensitve() {
        return true;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof Pending || e2 instanceof Pending) {
            return e1 instanceof Pending ? (e2 instanceof Pending ? 0 : 1) : -1;
        }
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            return this.doCompare(viewer, e1, e2, this.doGetSortColumnLabel(viewer), this.doGetSortColumnIndex(viewer), this.doDetermineInverter(viewer));
        }
        return super.compare(viewer, e1, e2);
    }

    protected String doGetText(Viewer viewer, Object node, int index) {
        if (node != null) {
            IBaseLabelProvider labelProvider = this.doGetLabelProvider(viewer);
            if (labelProvider instanceof ITableLabelProvider) {
                return ((ITableLabelProvider)labelProvider).getColumnText(node, index);
            }
            if (labelProvider instanceof ILabelProvider) {
                return ((ILabelProvider)labelProvider).getText(node);
            }
            if (labelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
                StyledString text = ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider).getStyledText(node);
                return text != null ? text.getString() : null;
            }
        }
        return null;
    }

    protected IBaseLabelProvider doGetLabelProvider(Viewer viewer) {
        if (viewer instanceof ContentViewer) {
            IBaseLabelProvider candidate = ((ContentViewer)viewer).getLabelProvider();
            if (candidate instanceof DecoratingLabelProvider) {
                candidate = ((DecoratingLabelProvider)candidate).getLabelProvider();
            }
            if (candidate instanceof DecoratingStyledCellLabelProvider) {
                candidate = ((DecoratingStyledCellLabelProvider)candidate).getStyledStringProvider();
            }
            return candidate;
        }
        return null;
    }

    protected int doDetermineInverter(Viewer viewer) {
        Tree tree;
        int inverter = 1;
        if (viewer instanceof TreeViewer && ((TreeViewer)viewer).getTree() != null && !(tree = ((TreeViewer)viewer).getTree()).isDisposed() && tree.getSortDirection() == 1024) {
            inverter = -1;
        }
        return inverter;
    }

    protected String doGetSortColumnLabel(Viewer viewer) {
        if (viewer instanceof TreeViewer && ((TreeViewer)viewer).getTree() != null && !((TreeViewer)viewer).getTree().isDisposed()) {
            Tree tree = ((TreeViewer)viewer).getTree();
            return tree.getSortColumn() != null ? tree.getSortColumn().getText() : "";
        }
        return "";
    }

    protected int doGetSortColumnIndex(Viewer viewer) {
        if (viewer instanceof TreeViewer && ((TreeViewer)viewer).getTree() != null && !((TreeViewer)viewer).getTree().isDisposed()) {
            Tree tree = ((TreeViewer)viewer).getTree();
            return tree.getSortColumn() != null ? Arrays.asList(tree.getColumns()).indexOf(tree.getSortColumn()) : -1;
        }
        return -1;
    }

    protected int doCompare(Viewer viewer, Object node1, Object node2, String sortColumn, int index, int inverter) {
        if (node1 == null && node2 == null) {
            return 0;
        }
        if (node1 != null && node2 == null) {
            return 1 * inverter;
        }
        if (node1 == null && node2 != null) {
            return -1 * inverter;
        }
        String text1 = this.doGetText(viewer, node1, index);
        String text2 = this.doGetText(viewer, node2, index);
        if (text1 == null && text2 == null) {
            return 0;
        }
        if (text1 != null && text2 == null) {
            return 1 * inverter;
        }
        if (text1 == null && text2 != null) {
            return -1 * inverter;
        }
        if (!this.isCaseSensitve()) {
            text1 = text1.toLowerCase();
            text2 = text2.toLowerCase();
        }
        if (text1.length() > 0 && text2.length() > 0) {
            char c1 = text1.charAt(0);
            char c2 = text2.charAt(0);
            if (Character.isDigit(c1) || Character.isDigit(c2)) {
                if (Character.isDigit(c1) && !Character.isDigit(c2)) {
                    return -1 * inverter;
                }
                if (!Character.isDigit(c1) && Character.isDigit(c2)) {
                    return 1 * inverter;
                }
            }
            if (Character.isUpperCase(c1) || Character.isUpperCase(c2)) {
                if (Character.isUpperCase(c1) && !Character.isUpperCase(c2)) {
                    return -1 * inverter;
                }
                if (!Character.isUpperCase(c1) && Character.isUpperCase(c2)) {
                    return 1 * inverter;
                }
            }
            Matcher m1 = Pattern.compile("(\\D+)(\\d+)").matcher(text1);
            Matcher m2 = Pattern.compile("(\\D+)(\\d+)").matcher(text2);
            if (m1.matches() && m2.matches()) {
                String p11 = m1.group(1);
                String p12 = m1.group(2);
                String p21 = m2.group(1);
                String p22 = m2.group(2);
                if (p11 != null && p11.equals(p21)) {
                    try {
                        int result = 0;
                        long l1 = Long.parseLong(p12);
                        long l2 = Long.parseLong(p22);
                        if (l1 > l2) {
                            result = 1 * inverter;
                        }
                        if (l1 < l2) {
                            result = -1 * inverter;
                        }
                        return result;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (text1.matches("\\d+") && text2.matches("\\d+")) {
                try {
                    int result = 0;
                    long l1 = Long.parseLong(text1);
                    long l2 = Long.parseLong(text2);
                    if (l1 > l2) {
                        result = 1 * inverter;
                    }
                    if (l1 < l2) {
                        result = -1 * inverter;
                    }
                    return result;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (text1.matches(".*[A-Z]+.*") || text2.matches(".*[A-Z]+.*")) {
                if (text1.matches(".*[A-Z]+.*") && !text2.matches(".*[A-Z]+.*")) {
                    return -1 * inverter;
                }
                if (!text1.matches(".*[A-Z]+.*") && text2.matches(".*[A-Z]+.*")) {
                    return 1 * inverter;
                }
                int minLength = Math.min(text1.length(), text2.length());
                int i = 0;
                while (i < minLength) {
                    char ch1 = text1.charAt(i);
                    char ch2 = text2.charAt(i);
                    if (Character.isUpperCase(ch1) && !Character.isUpperCase(ch2)) {
                        return -1 * inverter;
                    }
                    if (!Character.isUpperCase(ch1) && Character.isUpperCase(ch2)) {
                        return 1 * inverter;
                    }
                    if (Character.isUpperCase(ch1) && Character.isUpperCase(ch2)) break;
                    ++i;
                }
            }
        }
        return this.getComparator().compare(text1, text2) * inverter;
    }
}

