/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.tags.SingleFolderTagSource;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;

public class LocalProjectTagSource
extends TagSource {
    private ICVSRemoteFolder seedFolder;
    private ICVSRemoteFolder[] remoteFolders;

    public static TagSource create(IProject seedProject) {
        ICVSRemoteFolder[] remoteFolders;
        ICVSRemoteFolder seedFolder;
        block3: {
            try {
                seedFolder = (ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)seedProject);
                remoteFolders = LocalProjectTagSource.getProjectRemoteFolders();
                if (remoteFolders.length != 1) break block3;
                return null;
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
                return null;
            }
        }
        return new LocalProjectTagSource(seedFolder, remoteFolders);
    }

    private LocalProjectTagSource(ICVSRemoteFolder seedFolder, ICVSRemoteFolder[] remoteFolders) {
        this.seedFolder = seedFolder;
        this.remoteFolders = remoteFolders;
    }

    private static ICVSRemoteFolder[] getProjectRemoteFolders() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<ICVSRemoteFolder> result = new ArrayList<ICVSRemoteFolder>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                ICVSRemoteFolder remote;
                if (project.isAccessible() && RepositoryProvider.isShared((IProject)project) && (remote = (ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project)) != null) {
                    result.add(remote);
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
            ++n2;
        }
        return result.toArray(new ICVSRemoteFolder[result.size()]);
    }

    @Override
    public CVSTag[] refresh(boolean bestEffort, IProgressMonitor monitor) throws TeamException {
        return new CVSTag[0];
    }

    @Override
    public ICVSRepositoryLocation getLocation() {
        return this.seedFolder.getRepository();
    }

    @Override
    public String getShortDescription() {
        return NLS.bind((String)CVSUIMessages.LocalProjectTagSource_0, (Object[])new String[]{Integer.toString(this.remoteFolders.length)});
    }

    @Override
    public void commit(CVSTag[] tags, boolean replace, IProgressMonitor monitor) throws CVSException {
    }

    @Override
    public ICVSResource[] getCVSResources() {
        return this.remoteFolders;
    }

    @Override
    public CVSTag[] getTags(int type) {
        if (type == 0 || type == -1) {
            return super.getTags(type);
        }
        HashSet<CVSTag> allTags = new HashSet<CVSTag>();
        ICVSRemoteFolder[] iCVSRemoteFolderArray = this.remoteFolders;
        int n = this.remoteFolders.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSRemoteFolder folder = iCVSRemoteFolderArray[n2];
            CVSTag[] tags = SingleFolderTagSource.getTags((ICVSFolder)folder, type);
            allTags.addAll(Arrays.asList(tags));
            ++n2;
        }
        CVSTag[] tags = SingleFolderTagSource.getTags((ICVSFolder)this.seedFolder, type);
        allTags.removeAll(Arrays.asList(tags));
        return allTags.toArray(new CVSTag[allTags.size()]);
    }
}

