/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import org.eclipse.tm.internal.terminal.model.TerminalTextDataStore;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.tm.terminal.model.LineSegment;
import org.eclipse.tm.terminal.model.TerminalStyle;

public class TerminalTextDataWindow
implements ITerminalTextData {
    final ITerminalTextData fData;
    int fWindowStartLine;
    int fWindowSize;
    int fHeight;
    int fMaxHeight;

    public TerminalTextDataWindow(ITerminalTextData data) {
        this.fData = data;
    }

    public TerminalTextDataWindow() {
        this(new TerminalTextDataStore());
    }

    private boolean throwRuntimeException() {
        throw new RuntimeException();
    }

    boolean isInWindow(int line) {
        return line >= this.fWindowStartLine && line < this.fWindowStartLine + this.fWindowSize;
    }

    @Override
    public char getChar(int line, int column) {
        if (!this.isInWindow(line)) {
            return '\u0000';
        }
        return this.fData.getChar(line - this.fWindowStartLine, column);
    }

    @Override
    public char[] getChars(int line) {
        if (!this.isInWindow(line)) {
            return null;
        }
        return this.fData.getChars(line - this.fWindowStartLine);
    }

    @Override
    public int getHeight() {
        return this.fHeight;
    }

    @Override
    public LineSegment[] getLineSegments(int line, int startCol, int numberOfCols) {
        if (!this.isInWindow(line)) {
            return new LineSegment[]{new LineSegment(startCol, new String(new char[numberOfCols]), null)};
        }
        return this.fData.getLineSegments(line - this.fWindowStartLine, startCol, numberOfCols);
    }

    @Override
    public int getMaxHeight() {
        return this.fMaxHeight;
    }

    @Override
    public TerminalStyle getStyle(int line, int column) {
        if (!this.isInWindow(line)) {
            return null;
        }
        return this.fData.getStyle(line - this.fWindowStartLine, column);
    }

    @Override
    public TerminalStyle[] getStyles(int line) {
        if (!this.isInWindow(line)) {
            return null;
        }
        return this.fData.getStyles(line - this.fWindowStartLine);
    }

    @Override
    public int getWidth() {
        return this.fData.getWidth();
    }

    @Override
    public ITerminalTextDataSnapshot makeSnapshot() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLine() {
        if (this.fMaxHeight > 0 && this.getHeight() < this.fMaxHeight) {
            this.setDimensions(this.getHeight() + 1, this.getWidth());
        } else {
            this.scroll(0, this.getHeight(), -1);
        }
    }

    @Override
    public void copy(ITerminalTextData source) {
        this.setDimensions(source.getHeight(), source.getWidth());
        int n = Math.min(this.fWindowSize, source.getHeight() - this.fWindowStartLine);
        if (n > 0) {
            this.fData.copyRange(source, this.fWindowStartLine, 0, n);
        }
    }

    @Override
    public void copyRange(ITerminalTextData source, int sourceStartLine, int destStartLine, int length) {
        int n = length;
        int dStart = destStartLine - this.fWindowStartLine;
        int sStart = sourceStartLine;
        if (dStart < 0) {
            n += dStart;
            sStart -= dStart;
            dStart = 0;
        }
        if ((n = Math.min(n, this.fWindowSize)) > 0) {
            this.fData.copyRange(source, sStart, dStart, n);
        }
    }

    @Override
    public void copyLine(ITerminalTextData source, int sourceLine, int destLine) {
        if (this.isInWindow(destLine)) {
            this.fData.copyLine(source, sourceLine, destLine - this.fWindowStartLine);
        }
    }

    @Override
    public void scroll(int startLine, int size, int shift) {
        assert (startLine >= 0 && startLine + size <= this.fHeight || this.throwRuntimeException());
        int n = size;
        int start = startLine - this.fWindowStartLine;
        if (start < 0) {
            n += start;
            start = 0;
        }
        if ((n = Math.min(n, this.fWindowSize - start)) > 0) {
            this.fData.scroll(start, n, shift);
        }
    }

    @Override
    public void setChar(int line, int column, char c, TerminalStyle style) {
        if (!this.isInWindow(line)) {
            return;
        }
        this.fData.setChar(line - this.fWindowStartLine, column, c, style);
    }

    @Override
    public void setChars(int line, int column, char[] chars, int start, int len, TerminalStyle style) {
        if (!this.isInWindow(line)) {
            return;
        }
        this.fData.setChars(line - this.fWindowStartLine, column, chars, start, len, style);
    }

    @Override
    public void setChars(int line, int column, char[] chars, TerminalStyle style) {
        if (!this.isInWindow(line)) {
            return;
        }
        this.fData.setChars(line - this.fWindowStartLine, column, chars, style);
    }

    @Override
    public void setDimensions(int height, int width) {
        assert (height >= 0 || this.throwRuntimeException());
        this.fData.setDimensions(this.fWindowSize, width);
        this.fHeight = height;
    }

    @Override
    public void setMaxHeight(int height) {
        this.fMaxHeight = height;
    }

    public void setWindow(int startLine, int size) {
        this.fWindowStartLine = startLine;
        this.fWindowSize = size;
        this.fData.setDimensions(this.fWindowSize, this.getWidth());
    }

    public int getWindowStartLine() {
        return this.fWindowStartLine;
    }

    public int getWindowSize() {
        return this.fWindowSize;
    }

    public void setHeight(int height) {
        this.fHeight = height;
    }

    @Override
    public void cleanLine(int line) {
        if (this.isInWindow(line)) {
            this.fData.cleanLine(line - this.fWindowStartLine);
        }
    }

    @Override
    public int getCursorColumn() {
        return this.fData.getCursorColumn();
    }

    @Override
    public int getCursorLine() {
        return this.fData.getCursorLine();
    }

    @Override
    public void setCursorColumn(int column) {
        this.fData.setCursorColumn(column);
    }

    @Override
    public void setCursorLine(int line) {
        this.fData.setCursorLine(line);
    }

    @Override
    public boolean isWrappedLine(int line) {
        if (this.isInWindow(line)) {
            return this.fData.isWrappedLine(line - this.fWindowStartLine);
        }
        return false;
    }

    @Override
    public void setWrappedLine(int line) {
        if (this.isInWindow(line)) {
            this.fData.setWrappedLine(line - this.fWindowStartLine);
        }
    }
}

