/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.dependence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.photran.internal.core.analysis.dependence.Matrix;

public class FourierMotzkinEliminator {
    public boolean eliminateForRealSolutions(Matrix matrixIn) {
        if (matrixIn.getNumRows() == 0) {
            throw new IndexOutOfBoundsException("eliminateForRealSolutions - matrixIn is empty");
        }
        Matrix unconstrainedMatrix = new Matrix();
        while (unconstrainedMatrix.getNumRows() != matrixIn.getNumRows()) {
            unconstrainedMatrix = matrixIn.cloneMatrix();
            if ((matrixIn = this.deleteAllUnconstrainedVariables(matrixIn)).getNumRows() != 0) continue;
            return true;
        }
        unconstrainedMatrix = null;
        matrixIn = this.deleteAllUnconstrainedVariables(matrixIn);
        if ((matrixIn = this.deleteRowsOfAllZeroes(matrixIn)).getNumRows() == 0) {
            return true;
        }
        if (this.containsInconsistentInequalities(matrixIn)) {
            return false;
        }
        int eliminatedVar = matrixIn.getNumColumns() - 2;
        while (eliminatedVar >= 0 && matrixIn.getNumRows() > 0) {
            matrixIn = this.realProjection(matrixIn, eliminatedVar);
            if (this.containsInconsistentInequalities(matrixIn = this.deleteRowsOfAllZeroes(matrixIn))) {
                return false;
            }
            --eliminatedVar;
        }
        if (matrixIn.getNumRows() == 0) {
            return true;
        }
        int numColumns = matrixIn.getNumColumns() - 1;
        int i = 0;
        while (i < matrixIn.getNumRows()) {
            if (matrixIn.getValueAtMatrixIndex(i, numColumns) < 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean eliminateForIntegerSolutions(Matrix matrixIn) {
        if (matrixIn.getNumRows() == 0) {
            throw new IndexOutOfBoundsException("eliminateForIntegerSolutions - matrixIn is empty");
        }
        unconstrainedMatrix = new Matrix();
        inexact = false;
        darkEmpty = false;
        eliminatedVar = 0;
        if (matrixIn.getNumColumns() >= 8 || this.eliminateForRealSolutions(matrixIn.cloneMatrix())) ** GOTO lbl30
        return false;
        {
            unconstrainedMatrix = matrixIn.cloneMatrix();
            if ((matrixIn = this.deleteAllUnconstrainedVariables(matrixIn)).getNumRows() == 0) {
                return true;
            }
            do {
                if (unconstrainedMatrix.getNumRows() != matrixIn.getNumRows()) continue block0;
                matrixIn = this.deleteRedundantInequalities(matrixIn);
                if ((matrixIn = this.deleteRowsOfAllZeroes(matrixIn)).getNumRows() == 0) {
                    return true;
                }
                if (this.containsInconsistentInequalities(matrixIn)) {
                    return false;
                }
                if (this.isInexactProjection(matrixIn, eliminatedVar)) {
                    inexact = true;
                }
                unconstrainedMatrix = matrixIn.cloneMatrix();
                matrixIn = this.inexactIntegerProjection(matrixIn, eliminatedVar);
                if (inexact && !darkEmpty && eliminatedVar + 1 < (matrixIn = this.darkShadowIntegerProjection(unconstrainedMatrix.cloneMatrix(), eliminatedVar)).getNumColumns() - 1) {
                    if (this.isSolutionSetEmpty(this.getRowsWithCertainVariable(matrixIn, eliminatedVar + 1), eliminatedVar + 1)) {
                        darkEmpty = true;
                    } else if (eliminatedVar + 1 == matrixIn.getNumColumns() - 2) {
                        return true;
                    }
                }
                ++eliminatedVar;
lbl30:
                // 2 sources

            } while (eliminatedVar < matrixIn.getNumColumns() - 1 && matrixIn.getNumRows() > 0);
        }
        if (matrixIn.getNumRows() == 0) {
            return true;
        }
        numColumns = matrixIn.getNumColumns() - 1;
        i = 0;
        while (i < matrixIn.getNumRows()) {
            if (matrixIn.getValueAtMatrixIndex(i, numColumns) < 0.0 && matrixIn.getValueAtMatrixIndex(i, eliminatedVar - 1) == 0.0) {
                return false;
            }
            ++i;
        }
        if (this.isSolutionSetEmpty(matrixIn, eliminatedVar - 1)) {
            return false;
        }
        return darkEmpty == false;
    }

    public Matrix realProjection(Matrix matrixIn, int eliminatingVar) {
        List<Integer> lowerBoundSet = this.calculateLowerBoundSet(matrixIn, eliminatingVar);
        List<Integer> upperBoundSet = this.calculateUpperBoundSet(matrixIn, eliminatingVar);
        if (lowerBoundSet.isEmpty() || upperBoundSet.isEmpty()) {
            matrixIn = this.deleteRowsInBoundingSet(matrixIn, this.combineBoundingSets(lowerBoundSet, upperBoundSet));
            return matrixIn;
        }
        int i = 0;
        while (i < lowerBoundSet.size()) {
            matrixIn.divideRowByColIndex(lowerBoundSet.get(i), eliminatingVar);
            ++i;
        }
        i = 0;
        while (i < upperBoundSet.size()) {
            matrixIn.divideRowByColIndex(upperBoundSet.get(i), eliminatingVar);
            ++i;
        }
        i = 0;
        while (i < lowerBoundSet.size()) {
            int k = 0;
            while (k < upperBoundSet.size()) {
                double[] newRow = matrixIn.addTwoRowsToCreateNewRow(matrixIn.getSingleRow(lowerBoundSet.get(i)), matrixIn.getSingleRow(upperBoundSet.get(k)));
                matrixIn.addRowAtIndex(matrixIn.getNumRows(), newRow);
                ++k;
            }
            ++i;
        }
        matrixIn = this.deleteRowsInBoundingSet(matrixIn, this.combineBoundingSets(lowerBoundSet, upperBoundSet));
        matrixIn.trimRowsToSize();
        return matrixIn;
    }

    public Matrix inexactIntegerProjection(Matrix matrixIn, int eliminatingVar) {
        double gcd;
        List<Integer> lowerBoundSet = this.calculateLowerBoundSet(matrixIn, eliminatingVar);
        List<Integer> upperBoundSet = this.calculateUpperBoundSet(matrixIn, eliminatingVar);
        if (lowerBoundSet.isEmpty() || upperBoundSet.isEmpty()) {
            matrixIn = this.deleteRowsInBoundingSet(matrixIn, this.combineBoundingSets(lowerBoundSet, upperBoundSet));
            return matrixIn;
        }
        int i = 0;
        while (i < lowerBoundSet.size()) {
            gcd = this.gcd(matrixIn.getSingleRow(lowerBoundSet.get(i)));
            matrixIn = this.divideRowForIntegerProjection(matrixIn, lowerBoundSet.get(i), gcd);
            ++i;
        }
        i = 0;
        while (i < upperBoundSet.size()) {
            gcd = this.gcd(matrixIn.getSingleRow(upperBoundSet.get(i)));
            matrixIn = this.divideRowForIntegerProjection(matrixIn, upperBoundSet.get(i), gcd);
            ++i;
        }
        double akj = 0.0;
        double aij = 0.0;
        double[] akjAi = new double[matrixIn.getNumColumns()];
        double[] aijAk = new double[matrixIn.getNumColumns()];
        double[] newRow = new double[matrixIn.getNumColumns()];
        int i2 = 0;
        while (i2 < lowerBoundSet.size()) {
            int k = 0;
            while (k < upperBoundSet.size()) {
                akj = matrixIn.getSingleRow(upperBoundSet.get(k))[eliminatingVar];
                aij = matrixIn.getSingleRow(lowerBoundSet.get(i2))[eliminatingVar];
                akjAi = this.multiplyArrayByNumber(matrixIn.getSingleRow(lowerBoundSet.get(i2)), akj);
                aijAk = this.multiplyArrayByNumber(matrixIn.getSingleRow(upperBoundSet.get(k)), aij);
                newRow = this.arraySubtraction(akjAi, aijAk);
                matrixIn.addRowAtIndex(matrixIn.getNumRows(), newRow);
                ++k;
            }
            ++i2;
        }
        matrixIn = this.deleteRowsInBoundingSet(matrixIn, this.combineBoundingSets(lowerBoundSet, upperBoundSet));
        matrixIn.trimRowsToSize();
        return matrixIn;
    }

    public Matrix darkShadowIntegerProjection(Matrix matrixIn, int eliminatingVar) {
        double gcd;
        List<Integer> lowerBoundSet = this.calculateLowerBoundSet(matrixIn, eliminatingVar);
        List<Integer> upperBoundSet = this.calculateUpperBoundSet(matrixIn, eliminatingVar);
        if (lowerBoundSet.isEmpty() || upperBoundSet.isEmpty()) {
            matrixIn = this.deleteRowsInBoundingSet(matrixIn, this.combineBoundingSets(lowerBoundSet, upperBoundSet));
            return matrixIn;
        }
        int i = 0;
        while (i < lowerBoundSet.size()) {
            gcd = this.gcd(matrixIn.getSingleRow(lowerBoundSet.get(i)));
            matrixIn = this.divideRowForIntegerProjection(matrixIn, lowerBoundSet.get(i), gcd);
            ++i;
        }
        i = 0;
        while (i < upperBoundSet.size()) {
            gcd = this.gcd(matrixIn.getSingleRow(upperBoundSet.get(i)));
            matrixIn = this.divideRowForIntegerProjection(matrixIn, upperBoundSet.get(i), gcd);
            ++i;
        }
        i = 0;
        while (i < lowerBoundSet.size()) {
            int k = 0;
            while (k < upperBoundSet.size()) {
                double[] newRow = this.calculateDarkShadow(matrixIn, lowerBoundSet.get(i), upperBoundSet.get(k), eliminatingVar);
                matrixIn.addRowAtIndex(matrixIn.getNumRows(), newRow);
                ++k;
            }
            ++i;
        }
        matrixIn = this.deleteRowsInBoundingSet(matrixIn, this.combineBoundingSets(lowerBoundSet, upperBoundSet));
        matrixIn.trimRowsToSize();
        return matrixIn;
    }

    public Matrix deleteRedundantInequalities(Matrix matrixIn) {
        ArrayList<Integer> redundants = new ArrayList<Integer>();
        int i = 0;
        while (i < matrixIn.getNumRows()) {
            int k = i + 1;
            while (k < matrixIn.getNumRows()) {
                if (Arrays.equals(matrixIn.getSingleRow(i), matrixIn.getSingleRow(k)) && !redundants.contains(k)) {
                    redundants.add(k);
                }
                ++k;
            }
            ++i;
        }
        matrixIn = this.deleteRowsInBoundingSet(matrixIn, redundants);
        return matrixIn;
    }

    public Matrix deleteInconsistentInequalities(Matrix matrixIn) {
        ArrayList<Integer> inconsistent = new ArrayList<Integer>();
        int i = 0;
        while (i < matrixIn.getNumRows()) {
            int k = i + 1;
            while (k < matrixIn.getNumRows()) {
                if (this.isInconsistentInequality(matrixIn.getSingleRow(i), matrixIn.getSingleRow(k)) && !inconsistent.contains(i) && !inconsistent.contains(k)) {
                    inconsistent.add(i);
                    inconsistent.add(k);
                }
                ++k;
            }
            ++i;
        }
        matrixIn = this.deleteRowsInBoundingSet(matrixIn, inconsistent);
        return matrixIn;
    }

    public boolean containsInconsistentInequalities(Matrix matrixIn) {
        boolean inconsistent = false;
        int i = 0;
        while (i < matrixIn.getNumRows()) {
            int k = i + 1;
            while (k < matrixIn.getNumRows()) {
                if (this.isInconsistentInequality(matrixIn.getSingleRow(i), matrixIn.getSingleRow(k))) {
                    return true;
                }
                ++k;
            }
            ++i;
        }
        return inconsistent;
    }

    public boolean isInconsistentInequality(double[] row1, double[] row2) {
        int i = 0;
        while (i < row1.length - 1) {
            if (row1[i] != -row2[i]) {
                return false;
            }
            ++i;
        }
        return -row2[row1.length - 1] > row1[row1.length - 1];
    }

    public Matrix deleteAllUnconstrainedVariables(Matrix matrixIn) {
        if (matrixIn.getNumRows() == 0) {
            throw new IndexOutOfBoundsException("deleteAllUnconstrainedVariables - matrixIn is empty");
        }
        boolean[] constrainedVars = this.determineUnconstrainedVariables(matrixIn);
        int i = 0;
        while (i < constrainedVars.length) {
            if (constrainedVars[i]) {
                matrixIn = this.deleteUnconstrainedVariable(matrixIn, i);
            }
            ++i;
        }
        matrixIn.trimRowsToSize();
        return matrixIn;
    }

    public Matrix sortMatrixByBoundingSetContents(Matrix matrixIn, List<Integer> lowerBoundSet, List<Integer> upperBoundSet) {
        if (matrixIn.getNumRows() == 0) {
            throw new IndexOutOfBoundsException("sortMatrixByBoundingSetContents - matrixIn is empty");
        }
        Matrix sortedMatrix = new Matrix();
        Integer i = 0;
        while (i < matrixIn.getNumRows()) {
            if (lowerBoundSet.contains(i) || upperBoundSet.contains(i)) {
                sortedMatrix.addRowAtIndex(0, matrixIn.getSingleRow(i));
            } else {
                sortedMatrix.addRowAtIndex(sortedMatrix.getNumRows(), matrixIn.getSingleRow(i));
            }
            i = i + 1;
        }
        return sortedMatrix;
    }

    public Matrix deleteRowsFromSortedMatrix(Matrix matrixIn, int size) throws IndexOutOfBoundsException {
        if (matrixIn.getNumRows() == 0) {
            throw new IndexOutOfBoundsException("deleteRowsFromSortedMatrix - matrixIn is empty");
        }
        if (size > matrixIn.getNumRows() || size < 0) {
            throw new IndexOutOfBoundsException("deleteRowsFromSortedMatrix - size invalid");
        }
        int i = 0;
        while (i < size) {
            matrixIn.deleteRow(0);
            ++i;
        }
        return matrixIn;
    }

    public List<Integer> calculateLowerBoundSet(Matrix matrixIn, int colIndex) {
        if (matrixIn.getNumRows() == 0) {
            throw new IndexOutOfBoundsException("calculateLowerBoundSet - matrixIn is empty");
        }
        if (colIndex < 0 || colIndex >= matrixIn.getNumColumns()) {
            throw new IndexOutOfBoundsException("calculateLowerBoundSet - colIndex out of bounds");
        }
        ArrayList<Integer> lowerBound = new ArrayList<Integer>();
        int i = 0;
        while (i < matrixIn.getNumRows()) {
            if (matrixIn.getValueAtMatrixIndex(i, colIndex) < 0.0) {
                lowerBound.add(i);
            }
            ++i;
        }
        return lowerBound;
    }

    public List<Integer> calculateUpperBoundSet(Matrix matrixIn, int colIndex) {
        if (matrixIn.getNumRows() == 0) {
            throw new IndexOutOfBoundsException("calculateUpperBoundSet - matrixIn is empty");
        }
        if (colIndex < 0 || colIndex >= matrixIn.getNumColumns()) {
            throw new IndexOutOfBoundsException("calculateUpperBoundSet - colIndex out of bounds");
        }
        ArrayList<Integer> upperBound = new ArrayList<Integer>();
        int i = 0;
        while (i < matrixIn.getNumRows()) {
            if (matrixIn.getValueAtMatrixIndex(i, colIndex) > 0.0) {
                upperBound.add(i);
            }
            ++i;
        }
        return upperBound;
    }

    public boolean[] determineUnconstrainedVariables(Matrix matrixIn) {
        if (matrixIn.getNumRows() == 0) {
            return null;
        }
        int numOfVariables = matrixIn.getNumColumns() - 1;
        boolean[] unconstrained = new boolean[numOfVariables];
        int i = 0;
        while (i < numOfVariables) {
            if (this.calculateLowerBoundSet(matrixIn, i).isEmpty() || this.calculateUpperBoundSet(matrixIn, i).isEmpty()) {
                unconstrained[i] = true;
            }
            ++i;
        }
        return unconstrained;
    }

    public Matrix deleteUnconstrainedVariable(Matrix matrixIn, int unconstrainedIndex) {
        if (matrixIn.getNumRows() == 0) {
            return matrixIn;
        }
        if (unconstrainedIndex < 0 || unconstrainedIndex >= matrixIn.getNumColumns()) {
            throw new IndexOutOfBoundsException("deleteUnconstrainedVariable - unconstrainedIndex out of bounds");
        }
        List<Integer> lowerBoundSet = null;
        List<Integer> upperBoundSet = null;
        lowerBoundSet = this.calculateLowerBoundSet(matrixIn, unconstrainedIndex);
        upperBoundSet = this.calculateUpperBoundSet(matrixIn, unconstrainedIndex);
        matrixIn = this.deleteRowsInBoundingSet(matrixIn, this.combineBoundingSets(lowerBoundSet, upperBoundSet));
        return matrixIn;
    }

    public double gcd(double a, double b) {
        while (b > 0.0) {
            double temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    public double gcd(double[] input) {
        double result = Math.abs(input[0]);
        int i = 1;
        while (i < input.length - 1) {
            result = this.gcd(result, Math.abs(input[i]));
            ++i;
        }
        return Math.abs(result);
    }

    public double[] multiplyArrayByNumber(double[] arrayIn, double multiplier) {
        double[] multArray = (double[])arrayIn.clone();
        int i = 0;
        while (i < multArray.length) {
            multArray[i] = multArray[i] * multiplier;
            if (multArray[i] == Double.POSITIVE_INFINITY || multArray[i] == Double.NEGATIVE_INFINITY || multArray[i] == Double.NaN) {
                throw new ArithmeticException("multiplyArrayByNumber - overflow or NaN result");
            }
            ++i;
        }
        return multArray;
    }

    public double[] arraySubtraction(double[] biggerArray, double[] smallerArray) {
        int i = 0;
        while (i < biggerArray.length) {
            biggerArray[i] = biggerArray[i] - smallerArray[i];
            ++i;
        }
        return biggerArray;
    }

    public boolean isSolutionSetEmpty(Matrix solutionSpace, int elimVar) {
        if (solutionSpace.getNumRows() == 0) {
            return true;
        }
        int numberOfEquations = solutionSpace.getNumRows();
        ArrayList<Double> upperBoundValues = new ArrayList<Double>();
        ArrayList<Double> lowerBoundValues = new ArrayList<Double>();
        double lastNum = 0.0;
        int i = 0;
        while (i < numberOfEquations) {
            double[] equation = solutionSpace.getSingleRow(i);
            lastNum = equation[equation.length - 1];
            if (this.multipleNonZeroValuesExistInArrayExcludingLastPlace(equation)) {
                return false;
            }
            if (equation[elimVar] != 0.0) {
                lastNum /= equation[elimVar];
            }
            if (lastNum <= 0.0 && equation[elimVar] < 0.0) {
                lowerBoundValues.add(lastNum);
            } else if (lastNum > 0.0 && equation[elimVar] < 0.0) {
                lowerBoundValues.add(lastNum);
            } else {
                upperBoundValues.add(lastNum);
            }
            ++i;
        }
        Collections.sort(upperBoundValues);
        Collections.sort(lowerBoundValues);
        if (upperBoundValues.size() > 0 && lowerBoundValues.size() > 0) {
            double lowerBound;
            double upperBound = (Double)upperBoundValues.get(0);
            return !(upperBound - (lowerBound = ((Double)lowerBoundValues.get(lowerBoundValues.size() - 1)).doubleValue()) >= 1.0);
        }
        return false;
    }

    private boolean multipleNonZeroValuesExistInArrayExcludingLastPlace(double[] arrayIn) {
        int numNonZeroValues = 0;
        int i = 0;
        while (i < arrayIn.length - 1) {
            if (arrayIn[i] != 0.0) {
                ++numNonZeroValues;
            }
            ++i;
        }
        return numNonZeroValues > 1;
    }

    private Matrix getRowsWithCertainVariable(Matrix matrixIn, int colNum) {
        Matrix rowsWithVar = new Matrix();
        int i = 0;
        while (i < matrixIn.getNumRows() - 1) {
            if (matrixIn.getSingleRow(i)[colNum] != 0.0) {
                rowsWithVar.addRowAtIndex(rowsWithVar.getNumRows(), matrixIn.getSingleRow(i));
            }
            ++i;
        }
        return rowsWithVar;
    }

    private boolean isInexactProjection(Matrix matrixIn, int elimVar) {
        double inexactCond = 0.0;
        int i = 0;
        while (i < matrixIn.getNumRows() - 1) {
            int k = i + 1;
            while (k < matrixIn.getNumRows() - 1) {
                inexactCond = matrixIn.getSingleRow(i)[elimVar] * matrixIn.getSingleRow(k)[elimVar];
                if (Math.abs(inexactCond) > 1.0) {
                    return true;
                }
                ++k;
            }
            ++i;
        }
        return false;
    }

    public Matrix divideRowForIntegerProjection(Matrix matrixIn, int rowIndex, double divisor) {
        int lastColIndex = matrixIn.getSingleRow(rowIndex).length - 1;
        int i = 0;
        while (i < lastColIndex) {
            if (matrixIn.getSingleRow(rowIndex)[i] != 0.0 && matrixIn.getSingleRow(rowIndex)[i] / divisor == 0.0) {
                throw new ArithmeticException("divideRowForIntegerProjection - underflow");
            }
            matrixIn.getSingleRow((int)rowIndex)[i] = matrixIn.getSingleRow(rowIndex)[i] / divisor;
            if (matrixIn.getSingleRow(rowIndex)[i] == Double.POSITIVE_INFINITY || matrixIn.getSingleRow(rowIndex)[i] == Double.NEGATIVE_INFINITY || matrixIn.getSingleRow(rowIndex)[i] == Double.NaN) {
                throw new ArithmeticException("divideRowForIntegerProjection - overflow or NaN result");
            }
            ++i;
        }
        matrixIn.getSingleRow((int)rowIndex)[lastColIndex] = Math.floor(matrixIn.getSingleRow(rowIndex)[lastColIndex] / divisor);
        return matrixIn;
    }

    public double[] calculateDarkShadow(Matrix matrixIn, int lowerBoundSetVal, int upperBoundSetVal, int elimVar) {
        double akj = matrixIn.getSingleRow(upperBoundSetVal)[elimVar];
        double aij = matrixIn.getSingleRow(lowerBoundSetVal)[elimVar];
        double[] akjAi = this.multiplyArrayByNumber((double[])matrixIn.getSingleRow(lowerBoundSetVal).clone(), akj);
        double[] aijAk = this.multiplyArrayByNumber((double[])matrixIn.getSingleRow(upperBoundSetVal).clone(), aij);
        double akjbi = akj * matrixIn.getSingleRow(lowerBoundSetVal)[matrixIn.getNumColumns() - 1];
        if (akjbi == Double.POSITIVE_INFINITY || akjbi == Double.NEGATIVE_INFINITY || akjbi == Double.NaN) {
            throw new ArithmeticException("calculateDarkShadow - overflow or NaN result for akjbi");
        }
        double aijbk = aij * matrixIn.getSingleRow(upperBoundSetVal)[matrixIn.getNumColumns() - 1];
        if (aijbk == Double.POSITIVE_INFINITY || aijbk == Double.NEGATIVE_INFINITY || aijbk == Double.NaN) {
            throw new ArithmeticException("calculateDarkShadow - overflow or NaN result for aijbk");
        }
        double akjaij = akj * aij;
        if (akjaij == Double.POSITIVE_INFINITY || akjaij == Double.NEGATIVE_INFINITY || akjaij == Double.NaN) {
            throw new ArithmeticException("calculateDarkShadow - overflow or NaN result for akjaij");
        }
        double newB = akjbi - aijbk + akjaij + akj - aij - 1.0;
        double[] newRow = this.arraySubtraction(akjAi, aijAk);
        newRow[matrixIn.getNumColumns() - 1] = newB;
        return newRow;
    }

    public Matrix deleteRowsInBoundingSet(Matrix matrixIn, List<Integer> combinedSet) {
        if (matrixIn.getNumRows() == 0) {
            throw new IndexOutOfBoundsException("deleteRowsInBoundingSet - matrixIn is empty");
        }
        int numDeleted = 0;
        int i = 0;
        while (i < combinedSet.size()) {
            matrixIn.deleteRow(combinedSet.get(i) - numDeleted);
            ++numDeleted;
            ++i;
        }
        return matrixIn;
    }

    public Matrix deleteRowsOfAllZeroes(Matrix matrixIn) {
        int numDeleted = 0;
        int i = 0;
        while (i < matrixIn.getNumRows()) {
            if (matrixIn.isRowFullOfZeroes(matrixIn.getSingleRow(i))) {
                matrixIn.deleteRow(i - numDeleted);
                ++numDeleted;
            }
            ++i;
        }
        return matrixIn;
    }

    public List<Integer> combineBoundingSets(List<Integer> lowerBoundSet, List<Integer> upperBoundSet) {
        ArrayList<Integer> combinedList = new ArrayList<Integer>();
        int i = 0;
        while (i < lowerBoundSet.size()) {
            combinedList.add(lowerBoundSet.get(i));
            ++i;
        }
        i = 0;
        while (i < upperBoundSet.size()) {
            combinedList.add(upperBoundSet.get(i));
            ++i;
        }
        Collections.sort(combinedList);
        return combinedList;
    }
}

