/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.wst.jsdt.ui.IWorkingCopyManager;
import org.eclipse.wst.jsdt.ui.IWorkingCopyManagerExtension;

public class WorkingCopyManager
implements IWorkingCopyManager,
IWorkingCopyManagerExtension {
    private ICompilationUnitDocumentProvider fDocumentProvider;
    private Map fMap;
    private boolean fIsShuttingDown;

    public WorkingCopyManager(ICompilationUnitDocumentProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fDocumentProvider = provider;
    }

    @Override
    public void connect(IEditorInput input) throws CoreException {
        this.fDocumentProvider.connect(input);
    }

    @Override
    public void disconnect(IEditorInput input) {
        this.fDocumentProvider.disconnect(input);
    }

    @Override
    public void shutdown() {
        if (!this.fIsShuttingDown) {
            this.fIsShuttingDown = true;
            try {
                if (this.fMap != null) {
                    this.fMap.clear();
                    this.fMap = null;
                }
                this.fDocumentProvider.shutdown();
            }
            finally {
                this.fIsShuttingDown = false;
            }
        }
    }

    @Override
    public IJavaScriptUnit getWorkingCopy(IEditorInput input) {
        return this.getWorkingCopy(input, true);
    }

    public IJavaScriptUnit getWorkingCopy(IEditorInput input, boolean primaryOnly) {
        IJavaScriptUnit unit;
        IJavaScriptUnit iJavaScriptUnit = unit = this.fMap == null ? null : (IJavaScriptUnit)this.fMap.get(input);
        if (unit == null) {
            unit = this.fDocumentProvider.getWorkingCopy(input);
        }
        if (unit != null && (!primaryOnly || JavaModelUtil.isPrimary(unit))) {
            return unit;
        }
        return null;
    }

    @Override
    public void setWorkingCopy(IEditorInput input, IJavaScriptUnit workingCopy) {
        if (this.fDocumentProvider.getDocument(input) != null) {
            if (this.fMap == null) {
                this.fMap = new HashMap();
            }
            this.fMap.put(input, workingCopy);
        }
    }

    @Override
    public void removeWorkingCopy(IEditorInput input) {
        this.fMap.remove(input);
        if (this.fMap.isEmpty()) {
            this.fMap = null;
        }
    }
}

