/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder.plexusbuildapi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.sonatype.plexus.build.incremental.BuildContext;

public class ChangedFileOutputStream
extends OutputStream {
    private final File file;
    private final BuildContext buildContext;
    private final OutputStream os;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public ChangedFileOutputStream(File file) throws FileNotFoundException {
        this(file, null);
    }

    public ChangedFileOutputStream(File file, BuildContext buildContext) throws FileNotFoundException {
        this.file = file;
        this.buildContext = buildContext;
        this.os = new BufferedOutputStream(new FileOutputStream(file));
    }

    @Override
    public void write(int b) {
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            try {
                this.writeIfNewOrChanged();
            }
            finally {
                if (this.os != null) {
                    this.os.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void writeIfNewOrChanged() throws IOException {
        boolean needToWrite;
        byte[] bytes;
        block14: {
            bytes = this.buffer.toByteArray();
            needToWrite = false;
            if (this.file.exists()) {
                Throwable throwable = null;
                Object var4_5 = null;
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.file));){
                    byte[] byArray = bytes;
                    int n = bytes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte element = byArray[n2];
                        if (element != is.read()) {
                            needToWrite = true;
                            break block14;
                        }
                        ++n2;
                    }
                    break block14;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            needToWrite = true;
        }
        if (needToWrite) {
            if (this.buildContext != null) {
                this.buildContext.refresh(this.file);
            }
            this.os.write(bytes);
        }
    }
}

