/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectorregistry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectorregistry.CategoryDescriptor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectorregistry.CollectorDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public final class CollectorRegistry {
    public static final String EXT_POINT_ID = "codeCompletionCollectors";
    public static final String ELEMENT_CATEGORY = "category";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_LABEL = "label";
    public static final String ATTRIBUTE_PRIORITY = "priority";
    public static final String ELEMENT_COLLECTOR = "collector";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String ATTRIBUTE_CATEGORY = "category";
    private static CategoryDescriptor[] ourCategories;
    private static Map<String, List<CollectorDescriptor>> ourCollectors;
    private static IRegistryChangeListener ourRegistryChangeListener;
    private static IActivityManagerListener ourActivityChangeListener;

    static {
        ourRegistryChangeListener = new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                IExtensionDelta[] extensionDeltas = event.getExtensionDeltas("org.eclipse.m2m.qvt.oml.editor.ui", CollectorRegistry.EXT_POINT_ID);
                if (extensionDeltas.length != 0) {
                    CollectorRegistry.refresh();
                }
            }
        };
        ourActivityChangeListener = new IActivityManagerListener(){

            public void activityManagerChanged(ActivityManagerEvent event) {
                if (event.haveEnabledActivityIdsChanged()) {
                    CollectorRegistry.refresh();
                }
            }
        };
        CollectorRegistry.refresh();
        Platform.getExtensionRegistry().addRegistryChangeListener(ourRegistryChangeListener, "org.eclipse.m2m.qvt.oml.editor.ui");
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener(ourActivityChangeListener);
    }

    public static CategoryDescriptor[] getCategories() {
        return ourCategories;
    }

    public static final List<CollectorDescriptor> getCollectors(String categoryId) {
        return ourCollectors.get(categoryId);
    }

    private static CategoryDescriptor[] initCategories() {
        IConfigurationElement[] configurationElements;
        ArrayList<CategoryDescriptor> categories = new ArrayList<CategoryDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.m2m.qvt.oml.editor.ui", EXT_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if ("category".equals(configurationElement.getName())) {
                CategoryDescriptor categoryDescriptor = CollectorRegistry.initCategory(configurationElement);
                categories.add(categoryDescriptor);
            }
            ++n2;
        }
        Collections.sort(categories, new Comparator<CategoryDescriptor>(){

            @Override
            public int compare(CategoryDescriptor o1, CategoryDescriptor o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        return categories.toArray(new CategoryDescriptor[categories.size()]);
    }

    private static CategoryDescriptor initCategory(IConfigurationElement configurationElement) {
        String id = configurationElement.getAttribute(ATTRIBUTE_ID);
        String label = configurationElement.getAttribute(ATTRIBUTE_LABEL);
        String strPriority = configurationElement.getAttribute(ATTRIBUTE_PRIORITY);
        int priority = Integer.parseInt(strPriority);
        return new CategoryDescriptor(id, label, priority);
    }

    private static Map<String, List<CollectorDescriptor>> initCollectors() {
        IConfigurationElement[] configurationElements;
        HashMap<String, List<CollectorDescriptor>> result = new HashMap<String, List<CollectorDescriptor>>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.m2m.qvt.oml.editor.ui", EXT_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (!CollectorRegistry.isFiltered(configurationElement) && ELEMENT_COLLECTOR.equals(configurationElement.getName())) {
                CollectorDescriptor collector = CollectorRegistry.initCollector(configurationElement);
                ArrayList<CollectorDescriptor> collectorsForCategory = (ArrayList<CollectorDescriptor>)result.get(collector.getCategoryDescriptor().getId());
                if (collectorsForCategory == null) {
                    collectorsForCategory = new ArrayList<CollectorDescriptor>();
                    result.put(collector.getCategoryDescriptor().getId(), collectorsForCategory);
                }
                collectorsForCategory.add(collector);
            }
            ++n2;
        }
        return result;
    }

    private static CollectorDescriptor initCollector(IConfigurationElement configurationElement) {
        String category = configurationElement.getAttribute("category");
        return new CollectorDescriptor(category, ATTRIBUTE_CLASS, configurationElement);
    }

    public static final void refresh() {
        ourCategories = CollectorRegistry.initCategories();
        ourCollectors = CollectorRegistry.initCollectors();
    }

    private static boolean isFiltered(IConfigurationElement configurationElement) {
        final IExtension extension = configurationElement.getDeclaringExtension();
        IPluginContribution contribution = new IPluginContribution(){

            public String getLocalId() {
                return extension.getSimpleIdentifier();
            }

            public String getPluginId() {
                return extension.getContributor().getName();
            }
        };
        return WorkbenchActivityHelper.filterItem((Object)contribution);
    }
}

