/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.views;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.DelayedRefreshJob;
import org.eclipse.mylyn.gerrit.dashboard.GerritPlugin;
import org.eclipse.mylyn.gerrit.dashboard.core.GerritQueryException;
import org.eclipse.mylyn.gerrit.dashboard.core.GerritTask;
import org.eclipse.mylyn.gerrit.dashboard.core.GerritTaskDataCollector;
import org.eclipse.mylyn.gerrit.dashboard.ui.GerritUi;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.model.ReviewTableData;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.model.UIReviewTable;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils.GerritServerUtility;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils.SelectionDialog;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils.UIUtils;
import org.eclipse.mylyn.gerrit.dashboard.ui.views.Messages;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.Version;

public class GerritTableView
extends ViewPart
implements ITaskListChangeListener {
    public static final String MY_CHANGES_STRING = "owner:self OR reviewer:self";
    public static final String MY_WATCHED_CHANGES_STRING = "is:watched status:open";
    public static final String ALL_OPEN_CHANGES_STRING = "status:open";
    public static final String VIEW_ID = "org.eclipse.mylyn.gerrit.dashboard.ui.views.GerritTableView";
    private static final int REPO_WIDTH = 170;
    private static final int VERSION_WIDTH = 35;
    private static final int SEARCH_SIZE_MENU_LIST = 4;
    private static final String ADJUST_MY_STARRED_COMMAND_ID = "org.eclipse.mylyn.gerrit.dashboard.ui.adjustMyStarred";
    private GerritConnector fConnector = GerritCorePlugin.getDefault().getConnector();
    private TaskRepository fTaskRepository = null;
    private RepositoryQuery fCurrentQuery = null;
    private Label fRepositoryVersionResulLabel;
    private Label fReviewsTotalLabel;
    private Label fReviewsTotalResultLabel;
    private Combo fSearchRequestText;
    private Button fSearchRequestBtn;
    private Set<String> fRequestList = new LinkedHashSet<String>();
    private TableViewer fViewer;
    private ReviewTableData fReviewTable = new ReviewTableData();
    private GerritServerUtility fServerUtil = GerritServerUtility.getInstance();
    private Map<TaskRepository, String> fMapRepoServer = null;
    private Action doubleClickAction;
    private final LinkedHashSet<Job> fJobs = new LinkedHashSet();
    private TableRefreshJob fTableRefreshJob;

    public boolean setConnector(GerritConnector aConnector) {
        boolean b = true;
        this.fConnector = aConnector == null ? GerritCorePlugin.getDefault().getConnector() : aConnector;
        if (this.fConnector == null) {
            b = false;
        }
        return b;
    }

    public void setReviewTableData(ReviewTableData ReviewTable) {
        this.fReviewTable = ReviewTable;
    }

    public void setGerritServerUtility(GerritServerUtility ServerUtil) {
        this.fServerUtil = ServerUtil;
    }

    public void dispose() {
        TasksUiPlugin.getTaskList().removeChangeListener((ITaskListChangeListener)this);
        this.fTableRefreshJob.cancel();
        this.cleanJobs();
    }

    private void cleanJobs() {
        for (Job job : this.fJobs) {
            job.sleep();
            job.cancel();
        }
        this.fJobs.clear();
    }

    private void refresh() {
        this.fTableRefreshJob.doRefresh(null);
    }

    public void createPartControl(Composite aParent) {
        ScrolledComposite sc = new ScrolledComposite(aParent, 2816);
        sc.setExpandHorizontal(true);
        Composite c = new Composite((Composite)sc, 0);
        sc.setContent((Control)c);
        sc.setExpandVertical(true);
        this.createSearchSection(c);
        UIReviewTable reviewTable = new UIReviewTable();
        this.fViewer = reviewTable.createTableViewerSection(c);
        this.createLayout(c);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.fTableRefreshJob = new TableRefreshJob(this.fViewer, Messages.GerritTableView_refreshTable);
        TasksUiPlugin.getTaskList().addChangeListener((ITaskListChangeListener)this);
        sc.setMinSize(c.computeSize(-1, -1));
    }

    private void createLayout(Composite aParent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 1;
        layout.makeColumnsEqualWidth = false;
        aParent.setLayout((Layout)layout);
    }

    private void createSearchSection(Composite aParent) {
        Group formGroup = new Group(aParent, 272);
        GridData gridDataGroup = new GridData(768);
        formGroup.setLayoutData((Object)gridDataGroup);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginTop = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.makeColumnsEqualWidth = false;
        formGroup.setLayout((Layout)layout);
        Composite leftSearchForm = UIUtils.createsGeneralComposite((Composite)formGroup, 0);
        GridLayout leftLayoutForm = new GridLayout();
        leftLayoutForm.numColumns = 3;
        leftLayoutForm.marginHeight = 0;
        leftLayoutForm.makeColumnsEqualWidth = false;
        leftLayoutForm.horizontalSpacing = 0;
        leftSearchForm.setLayout((Layout)leftLayoutForm);
        this.fRepositoryVersionResulLabel = new Label(leftSearchForm, 0);
        this.fRepositoryVersionResulLabel.setLayoutData((Object)new GridData(170, -1));
        this.fReviewsTotalLabel = new Label(leftSearchForm, 0);
        this.fReviewsTotalLabel.setText(Messages.GerritTableView_totalReview);
        this.fReviewsTotalResultLabel = new Label(leftSearchForm, 0);
        this.fReviewsTotalResultLabel.setLayoutData((Object)new GridData(35, -1));
        Composite rightSearchForm = UIUtils.createsGeneralComposite((Composite)formGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)rightSearchForm);
        GridLayout rightLayoutForm = new GridLayout();
        rightLayoutForm.numColumns = 2;
        rightLayoutForm.marginHeight = 0;
        rightLayoutForm.makeColumnsEqualWidth = false;
        rightSearchForm.setLayout((Layout)rightLayoutForm);
        this.fSearchRequestText = new Combo(rightSearchForm, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fSearchRequestText);
        this.fSearchRequestText.setToolTipText(Messages.GerritTableView_tooltipSearch);
        this.fRequestList = this.fServerUtil.getListLastCommands();
        this.setSearchText("");
        this.fSearchRequestText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                if (GerritTableView.this.fSearchRequestText.getText().trim().length() > 6) {
                    GerritTableView.this.processCommands("custom");
                }
            }
        });
        this.fSearchRequestBtn = new Button(rightSearchForm, 0);
        this.fSearchRequestBtn.setText(Messages.GerritTableView_search);
        this.fSearchRequestBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GerritTableView.this.processCommands("custom");
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager(Messages.GerritTableView_popupMenu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GerritTableView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        CommandContributionItem[] contribItems;
        CommandContributionItem[] commandContributionItemArray = contribItems = this.buildContributions();
        int n = contribItems.length;
        int n2 = 0;
        while (n2 < n) {
            CommandContributionItem contribItem = commandContributionItemArray[n2];
            manager.add((IContributionItem)contribItem);
            ++n2;
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = GerritTableView.this.fViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (structuredSelection.size() != 1) {
                    return;
                }
                Object element = structuredSelection.getFirstElement();
                if (element instanceof ITask) {
                    TasksUiUtil.openTask((TaskRepository)GerritTableView.this.fTaskRepository, (String)((ITask)element).getTaskId());
                }
                if (element instanceof GerritTask) {
                    GerritTableView.this.fReviewTable.updateReviewItem((GerritTask)element);
                    GerritTableView.this.refresh();
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GerritTableView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    private CommandContributionItem[] buildContributions() {
        IServiceLocator serviceLocator = this.getViewSite().getActionBars().getServiceLocator();
        CommandContributionItem[] contributionItems = new CommandContributionItem[1];
        CommandContributionItemParameter contributionParameter = new CommandContributionItemParameter(serviceLocator, Messages.GerritTableView_starredName, ADJUST_MY_STARRED_COMMAND_ID, 8);
        contributionParameter.label = Messages.GerritTableView_starredName;
        contributionParameter.visibleEnabled = true;
        contributionItems[0] = new CommandContributionItem(contributionParameter);
        return contributionItems;
    }

    public TableViewer getTableViewer() {
        return this.fViewer;
    }

    public TaskRepository getTaskRepository() {
        this.processCommands("");
        return this.fTaskRepository;
    }

    public static GerritTableView getActiveView(boolean create) {
        IWorkbenchPage page;
        IWorkbench workbench = GerritUi.getDefault().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null && (page = workbench.getActiveWorkbenchWindow().getActivePage()) != null) {
            IViewPart viewPart = page.findView(VIEW_ID);
            if (viewPart == null && create) {
                viewPart = GerritTableView.createView(page);
            }
            return (GerritTableView)viewPart;
        }
        return null;
    }

    private static IViewPart createView(IWorkbenchPage page) {
        try {
            return page.showView(VIEW_ID, null, 3);
        }
        catch (PartInitException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.gerrit.core", e.getMessage(), (Throwable)e));
            return null;
        }
    }

    public void openView() {
        IWorkbench workbench = GerritUi.getDefault().getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView(VIEW_ID);
        if (viewPart == null) {
            try {
                viewPart = page.showView(VIEW_ID);
            }
            catch (PartInitException e) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.gerrit.core", e.getMessage(), (Throwable)e));
            }
        } else if (!page.isPartVisible((IWorkbenchPart)viewPart)) {
            page.bringToTop((IWorkbenchPart)viewPart);
        }
    }

    public void processCommands(String aQuery) {
        GerritUi.Ftracer.traceInfo("Process command :   " + aQuery);
        String lastSaved = this.fServerUtil.getLastSavedGerritServer();
        if (lastSaved != null) {
            this.fTaskRepository = this.fServerUtil.getTaskRepo(lastSaved);
        }
        if (this.fTaskRepository == null) {
            this.fMapRepoServer = GerritServerUtility.getInstance().getGerritMapping();
            Set<TaskRepository> mapSet = this.fMapRepoServer.keySet();
            if (this.fMapRepoServer.size() == 1) {
                Iterator<TaskRepository> iterator = mapSet.iterator();
                if (iterator.hasNext()) {
                    TaskRepository key;
                    this.fTaskRepository = key = iterator.next();
                    this.fServerUtil.saveLastGerritServer(key.getRepositoryUrl());
                }
            } else if (this.fMapRepoServer.size() > 1) {
                ArrayList<TaskRepository> listTaskRepository = new ArrayList<TaskRepository>();
                for (TaskRepository key : mapSet) {
                    listTaskRepository.add(key);
                }
                this.fTaskRepository = this.getSelectedRepositoryURL(listTaskRepository);
                if (this.fTaskRepository != null) {
                    this.fServerUtil.saveLastGerritServer(this.fTaskRepository.getRepositoryUrl());
                }
            }
        }
        if (this.fTaskRepository == null) {
            UIUtils.showErrorDialog(Messages.GerritTableView_defineRepository, Messages.GerritTableView_noGerritRepository);
        } else if (aQuery != null && !aQuery.equals("")) {
            this.updateTable(this.fTaskRepository, aQuery);
        }
    }

    public void setStarred(String taskID, boolean starred, IProgressMonitor progressMonitor) throws CoreException {
        if (this.fTaskRepository == null) {
            UIUtils.showErrorDialog(Messages.GerritTableView_defineRepository, Messages.GerritTableView_noGerritRepository);
        } else {
            this.fConnector.setStarred(this.fTaskRepository, taskID, starred, progressMonitor);
        }
    }

    public Version getlastGerritServerVersion() {
        Version version = null;
        String lastSaved = this.fServerUtil.getLastSavedGerritServer();
        if (lastSaved != null) {
            this.fTaskRepository = this.fServerUtil.getTaskRepo(lastSaved);
        }
        if (this.fTaskRepository == null) {
            Set<TaskRepository> mapSet;
            Iterator<TaskRepository> iterator;
            this.fMapRepoServer = GerritServerUtility.getInstance().getGerritMapping();
            if (this.fMapRepoServer.size() == 1 && (iterator = (mapSet = this.fMapRepoServer.keySet()).iterator()).hasNext()) {
                TaskRepository key;
                this.fTaskRepository = key = iterator.next();
                this.fServerUtil.saveLastGerritServer(key.getRepositoryUrl());
            }
        }
        if (this.fTaskRepository != null && this.setConnector(this.fConnector)) {
            GerritClient gerritClient = this.fConnector.getClient(this.fTaskRepository);
            version = gerritClient.getVersion();
            GerritUi.Ftracer.traceInfo("Selected version: " + version.toString());
        }
        return version;
    }

    public boolean isGerritVersionBefore_2_5() {
        boolean ret = false;
        Version version = this.getlastGerritServerVersion();
        if (version != null && version.getMajor() >= 2 && version.getMinor() < 5) {
            ret = true;
        }
        return ret;
    }

    private Object updateTable(final TaskRepository aTaskRepo, final String aQueryType) {
        String cmdMessage = NLS.bind((String)Messages.GerritTableView_commandMessage, (Object)aTaskRepo.getUrl(), (Object)aQueryType);
        Job job = new Job(cmdMessage){

            public boolean belongsTo(Object aFamily) {
                return Messages.GerritTableView_dashboardUiJob.equals(aFamily);
            }

            public IStatus run(IProgressMonitor aMonitor) {
                GerritPlugin.Ftracer.traceInfo("repository:   " + aTaskRepo.getUrl() + "\t query: " + aQueryType);
                IStatus status = null;
                try {
                    GerritTableView.this.fReviewTable.createReviewItem(aQueryType, aTaskRepo);
                    status = GerritTableView.this.getReviews(aTaskRepo, aQueryType);
                    if (status.isOK()) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (aQueryType != "custom") {
                                    if (GerritTableView.this.fCurrentQuery != null) {
                                        String query = GerritTableView.this.fCurrentQuery.getAttribute("gerrit query string");
                                        GerritTableView.this.setSearchText(query);
                                    }
                                } else {
                                    GerritTableView.this.setSearchText(GerritTableView.this.getSearchText());
                                }
                                boolean ok = GerritTableView.this.setConnector(GerritTableView.this.fConnector);
                                GerritClient gerritClient = null;
                                if (ok) {
                                    gerritClient = GerritTableView.this.fConnector.getClient(aTaskRepo);
                                }
                                if (gerritClient != null) {
                                    GerritTableView.this.setRepositoryVersionLabel(aTaskRepo.getRepositoryLabel(), gerritClient.getVersion().toString());
                                }
                            }
                        });
                    }
                }
                catch (GerritQueryException e) {
                    status = e.getStatus();
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", e.getStatus().getMessage(), (Throwable)e));
                }
                aMonitor.done();
                GerritTableView.this.fJobs.remove((Object)this);
                return status;
            }
        };
        this.cleanJobs();
        this.fJobs.add(job);
        job.setUser(true);
        job.schedule();
        return null;
    }

    private void setSearchText(String aSt) {
        if (!this.fSearchRequestText.isDisposed()) {
            if (aSt != null && aSt != "") {
                int index = -1;
                String[] ar = this.fSearchRequestText.getItems();
                int i = 0;
                while (i < ar.length) {
                    if (ar[i].equals(aSt.trim())) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index != -1) {
                    this.fRequestList.remove(this.fRequestList.remove(ar[index]));
                } else if (this.fRequestList.size() > 4) {
                    String obj = this.fRequestList.iterator().next();
                    this.fRequestList.remove(this.fRequestList.remove(obj));
                }
                this.fRequestList.add(aSt.trim());
                this.fServerUtil.saveLastCommandList(this.fRequestList);
            }
            this.fSearchRequestText.setItems(this.reverseOrder(this.fRequestList.toArray(new String[0])));
            if (aSt != null && aSt != "") {
                this.fSearchRequestText.select(0);
            } else {
                this.fSearchRequestText.setText("");
            }
        }
    }

    private String[] reverseOrder(String[] aList) {
        int size = aList.length;
        int index = size - 1;
        String[] rev = new String[size];
        int i = 0;
        while (i < size) {
            rev[i] = aList[index--];
            ++i;
        }
        return rev;
    }

    private String getSearchText() {
        if (!this.fSearchRequestText.isDisposed()) {
            final String[] str = new String[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    str[0] = GerritTableView.this.fSearchRequestText.getText().trim();
                    GerritUi.Ftracer.traceInfo("Custom string: " + str[0]);
                }
            });
            return str[0];
        }
        return null;
    }

    private void displayWarning(final String st) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(null, Messages.GerritTableView_warning, null, st, 4, new String[]{IDialogConstants.CANCEL_LABEL}, 0);
                dialog.open();
            }
        });
    }

    private IStatus getReviews(TaskRepository repository, String queryType) throws GerritQueryException {
        if (repository.getUserName() == null || repository.getUserName().isEmpty()) {
            if (queryType.equals("my changes") || queryType.equals("has:draft")) {
                this.displayWarning(NLS.bind((String)Messages.GerritTableView_warningAnonymous, (Object)queryType));
                return Status.CANCEL_STATUS;
            }
            if (queryType == "custom") {
                int foundSelf = this.getSearchText().toLowerCase().indexOf("self");
                int foundhasDraft = this.getSearchText().toLowerCase().indexOf("has:draft");
                if (foundSelf != -1 || foundhasDraft != -1) {
                    this.displayWarning(NLS.bind((String)Messages.GerritTableView_warningSearchAnonymous, (Object)this.getSearchText()));
                    return Status.CANCEL_STATUS;
                }
            }
        }
        String queryId = String.valueOf(this.getTitle()) + " - " + queryType;
        RepositoryQuery query = null;
        IRepositoryModel repositoryModel = TasksUi.getRepositoryModel();
        query = (RepositoryQuery)repositoryModel.createRepositoryQuery(repository);
        query.setSummary(queryId);
        query.setAttribute("gerrit query type", queryType);
        query.setAttribute("gerrit query project", null);
        if (queryType == "custom") {
            query.setAttribute("gerrit query string", this.getSearchText());
        } else {
            String st = this.matchQueryTypeRequest(queryType);
            query.setAttribute("gerrit query string", st);
        }
        if (query.getAttribute("gerrit query string").isEmpty()) {
            this.displayWarning(Messages.GerritTableView_warningEmptyValue);
            return Status.CANCEL_STATUS;
        }
        this.fCurrentQuery = query;
        GerritTask[] reviews = this.getReviewList(repository, query);
        this.fReviewTable.init(reviews);
        this.refresh();
        return Status.OK_STATUS;
    }

    private String matchQueryTypeRequest(String queryType) {
        if (queryType.equals("all open changes")) {
            return ALL_OPEN_CHANGES_STRING;
        }
        if (queryType.equals("my changes")) {
            return MY_CHANGES_STRING;
        }
        if (queryType.equals("my watched changes")) {
            return MY_WATCHED_CHANGES_STRING;
        }
        return queryType;
    }

    private GerritTask[] getReviewList(TaskRepository repository, RepositoryQuery aQuery) throws GerritQueryException {
        GerritTaskDataCollector resultCollector = new GerritTaskDataCollector();
        Object status = null;
        boolean ok = this.setConnector(this.fConnector);
        status = ok ? this.fConnector.performQuery(repository, (IRepositoryQuery)aQuery, (TaskDataCollector)resultCollector, null, (IProgressMonitor)new NullProgressMonitor()) : new Status(4, "org.eclipse.mylyn.gerrit.core", NLS.bind((String)Messages.GerritTableView_missingGitConnector, (Object)aQuery.getAttribute("gerrit query project")));
        if (!status.isOK()) {
            throw new GerritQueryException(status, Messages.GerritTableView_serverNotRead);
        }
        ArrayList<GerritTask> reviews = new ArrayList<GerritTask>();
        List tasksData = resultCollector.getResults();
        for (TaskData taskData : tasksData) {
            GerritTask review = new GerritTask(taskData);
            reviews.add(review);
        }
        return reviews.toArray(new GerritTask[0]);
    }

    public void containersChanged(Set<TaskContainerDelta> deltas) {
        for (TaskContainerDelta taskContainerDelta : deltas) {
            IRepositoryElement element = taskContainerDelta.getElement();
            switch (taskContainerDelta.getKind()) {
                case ROOT: {
                    this.refresh();
                    break;
                }
                case ADDED: 
                case CONTENT: {
                    if (element != null && element instanceof TaskTask) {
                        this.updateReview((TaskTask)element);
                    }
                    this.refresh();
                    break;
                }
                case REMOVED: 
                case DELETED: {
                    if (element != null && element instanceof TaskTask) {
                        this.deleteReview((TaskTask)element);
                    }
                    this.refresh();
                    break;
                }
            }
        }
    }

    private synchronized void deleteReview(TaskTask task) {
        this.fReviewTable.deleteReviewItem(task.getTaskId());
    }

    private synchronized void updateReview(TaskTask task) {
        boolean ourQuery = task.getParentContainers().contains(this.fCurrentQuery);
        if (ourQuery && !Strings.isNullOrEmpty((String)task.getSummary())) {
            try {
                TaskData taskData = this.fConnector.getTaskData(this.getTaskRepository(), task.getTaskId(), (IProgressMonitor)new NullProgressMonitor());
                GerritTask gtask = new GerritTask(taskData);
                if (gtask.getAttribute("task.common.date.completed") == null) {
                    this.fReviewTable.updateReviewItem(gtask);
                }
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", e.getMessage(), (Throwable)e));
            }
        }
    }

    private void setRepositoryVersionLabel(String aRepo, String aVersion) {
        if (!this.fRepositoryVersionResulLabel.isDisposed()) {
            this.fRepositoryVersionResulLabel.setText(NLS.bind((String)Messages.GerritTableView_gerritLabel, (Object)aRepo, (Object)aVersion));
        }
    }

    private void setReviewsTotalResultLabel(String aSt) {
        if (!this.fReviewsTotalResultLabel.isDisposed()) {
            this.fReviewsTotalResultLabel.setText(aSt);
        }
    }

    private TaskRepository getSelectedRepositoryURL(List<TaskRepository> listTaskRepository) {
        String selection = null;
        SelectionDialog taskSelection = new SelectionDialog(this.fViewer.getTable().getShell(), listTaskRepository);
        if (taskSelection.open() == 0) {
            selection = taskSelection.getSelection();
        }
        return this.fServerUtil.getTaskRepo(selection);
    }

    private final class TableRefreshJob
    extends DelayedRefreshJob {
        private TableRefreshJob(TableViewer viewer, String name) {
            super((StructuredViewer)viewer, name);
        }

        protected void doRefresh(Object[] items) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    GerritTableView.this.fViewer.setInput((Object)GerritTableView.this.fReviewTable.getReviews());
                    GerritTableView.this.setReviewsTotalResultLabel(Integer.toString(GerritTableView.this.fReviewTable.getReviews().length));
                    GerritTableView.this.fViewer.refresh(false, false);
                }
            });
        }
    }
}

