/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.inputoutput;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.IoOperationType;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class Disk {
    private static final HashFunction HF = (HashFunction)NonNullUtils.checkNotNull((Object)Hashing.goodFastHash((int)32));
    private static final Integer MINORBITS = 20;
    private static final Integer MINORMASK = (1 << MINORBITS) - 1;
    private final Integer fDev;
    private final int fDiskQuark;
    private final ITmfStateSystem fSs;
    private @Nullable String fDiskName = null;

    public Disk(Integer dev, ITmfStateSystem ss, int diskQuark) {
        this.fDev = dev;
        this.fSs = ss;
        this.fDiskQuark = diskQuark;
        ITmfStateInterval diskNameInterval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)diskQuark, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        if (diskNameInterval != null) {
            this.fDiskName = diskNameInterval.getStateValue().unboxStr();
        }
    }

    public Integer getDevideId() {
        return this.fDev;
    }

    public String getDiskName() {
        String diskName = this.fDiskName;
        if (diskName == null) {
            return this.getDeviceIdString();
        }
        return diskName;
    }

    public int getQuark() {
        return this.fDiskQuark;
    }

    public void setDiskName(String diskname) {
        this.fDiskName = diskname;
    }

    public String getDeviceIdString() {
        Integer major = this.fDev >> MINORBITS;
        Integer minor = this.fDev & MINORMASK;
        return String.valueOf(major.toString()) + ',' + minor.toString();
    }

    public long getSectorsAt(long ts, IoOperationType type) {
        ITmfStateSystem ss = this.fSs;
        long currentCount = 0L;
        int rwSectorQuark = -2;
        if (type == IoOperationType.READ) {
            rwSectorQuark = ss.optQuarkRelative(this.fDiskQuark, new String[]{"sectors_read"});
        } else if (type == IoOperationType.WRITE) {
            rwSectorQuark = ss.optQuarkRelative(this.fDiskQuark, new String[]{"sectors_written"});
        }
        if (rwSectorQuark == -2) {
            return currentCount;
        }
        int rw = type == IoOperationType.READ ? 2 : 1;
        long time = Math.max(ts, ss.getStartTime());
        time = Math.min(time, ss.getCurrentEndTime());
        try {
            List states = ss.queryFullState(time);
            long count = ((ITmfStateInterval)states.get(rwSectorQuark)).getStateValue().unboxLong();
            if (count == -1L) {
                count = 0L;
            }
            Integer driverQ = ss.getQuarkRelative(this.fDiskQuark, new String[]{"Driver_queue"});
            for (Integer driverSlotQuark : ss.getSubAttributes(driverQ.intValue(), false)) {
                int sizeQuark = ss.getQuarkRelative(driverSlotQuark.intValue(), new String[]{"Request_size"});
                ITmfStateInterval interval = (ITmfStateInterval)states.get(sizeQuark);
                if (interval.getStateValue().isNull() || ((ITmfStateInterval)states.get(driverSlotQuark)).getStateValue().unboxInt() != rw) continue;
                long runningTime = interval.getEndTime() - interval.getStartTime() + 1L;
                long runningEnd = interval.getEndTime() + 1L;
                long startsize = interval.getStateValue().unboxLong();
                count = Disk.interpolateCount(count, time, runningEnd, runningTime, startsize);
            }
            currentCount = count;
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            Activator.getDefault().logError("Error getting disk IO Activity", e);
        }
        return currentCount;
    }

    private static long interpolateCount(long count, long ts, long runningEnd, long runningTime, long size) {
        long newCount = count;
        if (runningTime > 0L) {
            long runningStart = runningEnd - runningTime;
            if (ts < runningStart) {
                return newCount;
            }
            double interpolation = (double)(ts - runningStart) * (double)size / (double)runningTime;
            newCount += (long)interpolation;
        }
        return newCount;
    }

    public boolean hasActivity() {
        block4: {
            int wqQuark = this.fSs.getQuarkRelative(this.fDiskQuark, new String[]{"Waiting_queue"});
            if (this.fSs.getSubAttributes(wqQuark, false).size() <= 0) break block4;
            return true;
        }
        try {
            int dqQuark = this.fSs.getQuarkRelative(this.fDiskQuark, new String[]{"Driver_queue"});
            if (this.fSs.getSubAttributes(dqQuark, false).size() > 0) {
                return true;
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return "Disk: [" + this.getDeviceIdString() + ',' + this.fDiskName + ']';
    }

    public int hashCode() {
        return HF.newHasher().putInt(this.fDev.intValue()).hash().asInt();
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof Disk) {
            Disk disk = (Disk)o;
            if (this.fDev.equals(disk.fDev)) {
                return true;
            }
        }
        return false;
    }
}

