/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ip.provider.env;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.equinox.internal.ip.ProvisioningInfoProvider;
import org.eclipse.equinox.internal.ip.impl.Log;
import org.eclipse.equinox.internal.ip.impl.ProvisioningAgent;
import org.eclipse.equinox.internal.ip.provider.BaseProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.provisioning.ProvisioningService;

public class EnvironmentInfoProvider
extends BaseProvider
implements ProvisioningInfoProvider {
    public static final String MANUAL_SUPPORT = "equinox.provisioning.env.provider.allowed";
    public static final String PUSH_STARTING_WITH = "equinox.provisioning.env.provider.push.starting.with";
    private static final String[] props = new String[]{"provisioning.reference"};
    private BundleContext bc;

    public void start(BundleContext bc) throws Exception {
        boolean manualsupport = true;
        if (bc.getProperty(MANUAL_SUPPORT) != null && bc.getProperty(MANUAL_SUPPORT).equals("false")) {
            manualsupport = false;
        }
        if (!manualsupport) {
            Log.debug(this + " is not an allowed provider.");
            return;
        }
        this.bc = bc;
        super.start(bc);
    }

    public Dictionary init(ProvisioningService prvSrv) {
        String prefix;
        Hashtable<String, String> info = new Hashtable<String, String>();
        int i = props.length;
        while (i-- > 0) {
            String value = ProvisioningAgent.bc.getProperty(props[i]);
            if (value == null) continue;
            ((Dictionary)info).put(props[i], value);
        }
        if (ProvisioningAgent.bc.getProperty(PUSH_STARTING_WITH) != null && (prefix = ProvisioningAgent.bc.getProperty(PUSH_STARTING_WITH).trim()).length() != 0) {
            boolean all = "*".equals(prefix);
            Properties sprops = System.getProperties();
            Enumeration e = ((Dictionary)sprops).keys();
            while (e.hasMoreElements()) {
                try {
                    String key = (String)e.nextElement();
                    if (!all && !key.startsWith(prefix)) continue;
                    ((Dictionary)info).put(key, (String)((Dictionary)sprops).get(key));
                }
                catch (Exception exception) {}
            }
        }
        return info;
    }

    public Object get(Object key) {
        String value = null;
        if (key instanceof String && (value = ProvisioningAgent.bc.getProperty((String)key)) == null) {
            value = this.bc.getProperty((String)key);
        }
        return value;
    }

    public String toString() {
        return "Environment";
    }
}

