/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.businessprocess.CompNameTypeManager;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;

public class CalcTypes {
    private String m_guidToSwap;
    private INodePO m_localNode;
    private Map<Long, Map<String, String>> m_localType = new HashMap<Long, Map<String, String>>();
    private Map<String, String> m_usageType = new HashMap<String, String>();
    private Map<String, String> m_globalType = new HashMap<String, String>();
    private Map<String, ProblemType> m_allProblems = new HashMap<String, ProblemType>();
    private Map<String, List<String>> m_problemInfo = new HashMap<String, List<String>>();
    private Map<String, String> m_lastTypeChange = new HashMap<String, String>();
    private String m_mostAbstract = CompNameTypeManager.getMostAbstractType();
    private IComponentNameCache m_cache;
    private boolean m_writeTypes = false;

    public CalcTypes(IComponentNameCache cache, INodePO node) {
        this.m_cache = cache;
        this.m_guidToSwap = node == null ? null : node.getGuid();
        this.m_localNode = node;
    }

    public void setWriteTypes(boolean write) {
        this.m_writeTypes = write;
    }

    public void calculateTypes() {
        ArrayList<IProjectPO> reusedAndSelf = new ArrayList<IProjectPO>(GeneralStorage.getInstance().getReusedProjects().values());
        reusedAndSelf.add(GeneralStorage.getInstance().getProject());
        for (IProjectPO proj : reusedAndSelf) {
            for (ISpecPersistable node : proj.getSpecObjCont().getSpecObjList()) {
                if (this.m_localType.containsKey(node.getId())) continue;
                this.traverse(node);
            }
            for (ITestSuitePO ts : TestSuiteBP.getListOfTestSuites(proj)) {
                this.traverse(ts);
            }
        }
        this.collectUsageProblems();
        this.handleAssociations();
        if (this.m_writeTypes) {
            this.writeCompNameTypesAndProblems();
        }
    }

    public String calculateLocalType(INodePO node, String guid) {
        if (!(node instanceof ISpecTestCasePO) && !(node instanceof ITestSuitePO)) {
            throw new IllegalArgumentException("Node can only be a Spec Test Case or a Test Suite");
        }
        this.traverse(node);
        return this.m_localType.get(node.getId()).get(guid);
    }

    private void collectUsageProblems() {
        for (String guid : this.m_usageType.keySet()) {
            if (!this.m_usageType.get(guid).equals("guidancer.abstract.Unknown")) continue;
            this.m_allProblems.put(guid, ProblemType.REASON_INCOMPATIBLE_USAGE_TYPE);
        }
    }

    private void handleAssociations() {
        HashMap<String, String> maps = new HashMap<String, String>();
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        for (IAUTMainPO aut : GeneralStorage.getInstance().getProject().getAutMainList()) {
            for (IObjectMappingAssoziationPO assoc : aut.getObjMap().getMappings()) {
                ICompIdentifierPO technicalName = assoc.getTechnicalName();
                if (technicalName == null) continue;
                List availableComponents = compSystem.getComponents(aut.getToolkit(), true);
                String type = CompSystem.getComponentType((String)technicalName.getSupportedClassName(), (Collection)availableComponents);
                for (String guid : assoc.getLogicalNames()) {
                    String globType;
                    String resGuid = CompNameManager.getInstance().resolveGuid(guid);
                    if (!maps.containsKey(resGuid) || CompNameTypeManager.doesFirstTypeRealizeSecond(type, (String)maps.get(resGuid))) {
                        maps.put(resGuid, type);
                    }
                    if ((globType = this.m_usageType.get(resGuid)) == null) {
                        this.m_usageType.put(resGuid, this.m_mostAbstract);
                        globType = this.m_mostAbstract;
                    }
                    if (globType == null || globType.equals("guidancer.abstract.Unknown") || CompNameTypeManager.doesFirstTypeRealizeSecond(type, globType)) continue;
                    this.m_allProblems.put(resGuid, ProblemType.REASON_INCOMPATIBLE_MAP_TYPE);
                    ArrayList<String> info = new ArrayList<String>(2);
                    info.add(CompSystemI18n.getString((String)type));
                    info.add(CompSystemI18n.getString((String)globType));
                    info.add(this.m_lastTypeChange.get(guid));
                    info.add(aut.getGuid());
                    this.m_problemInfo.put(resGuid, info);
                }
            }
        }
        for (String guid : this.m_usageType.keySet()) {
            if (!maps.containsKey(guid) || ProblemType.REASON_INCOMPATIBLE_USAGE_TYPE.equals((Object)this.m_allProblems.get(guid)) || ProblemType.REASON_INCOMPATIBLE_MAP_TYPE.equals((Object)this.m_allProblems.get(guid))) {
                this.m_globalType.put(guid, this.m_usageType.get(guid));
                continue;
            }
            this.m_globalType.put(guid, CompNameTypeManager.getMostConcreteVisibleAncestorType((String)maps.get(guid)));
        }
    }

    public void traverse(INodePO nodeOld) {
        HashMap<String, String> localType = new HashMap<String, String>();
        INodePO node = nodeOld;
        if (this.m_guidToSwap != null && this.m_guidToSwap.equals(node.getGuid())) {
            node = this.m_localNode;
        }
        Iterator<INodePO> it = node.getAllNodeIter();
        while (it.hasNext()) {
            ISpecTestCasePO spec;
            String guid;
            INodePO child = it.next();
            if (child instanceof ICategoryPO || child instanceof ISpecTestCasePO) {
                this.traverse(child);
                continue;
            }
            if (child instanceof ICapPO) {
                guid = ((ICapPO)child).getComponentName();
                if (guid == null) continue;
                guid = CompNameManager.getInstance().resolveGuid(guid);
                String type = ((ICapPO)child).getComponentType();
                this.updateType(guid, type, localType, child);
                continue;
            }
            if (!(child instanceof IExecTestCasePO) || (spec = ((IExecTestCasePO)child).getSpecTestCase()) == null) continue;
            if (!this.m_localType.containsKey(spec.getId())) {
                this.traverse(spec);
            }
            Map<String, String> mapLocal = this.m_localType.get(spec.getId());
            for (String gui : mapLocal.keySet()) {
                ICompNamesPairPO pair = ((IExecTestCasePO)child).getCompNamesPair(gui);
                if (pair == null) {
                    guid = gui;
                } else {
                    guid = pair.getSecondName();
                    guid = CompNameManager.getInstance().resolveGuid(guid);
                }
                this.updateType(guid, mapLocal.get(gui), localType, child);
            }
            this.setCompNamePairTypes((IExecTestCasePO)child, mapLocal);
        }
        this.m_localType.put(node.getId(), localType);
    }

    private void updateType(String guid, String type, Map<String, String> localType, INodePO node) {
        if (localType.containsKey(guid)) {
            localType.put(guid, CompNameTypeManager.calcUsageType(localType.get(guid), type));
        } else {
            localType.put(guid, type);
        }
        String currentType = this.m_usageType.get(guid);
        String currentTypeDisp = CompSystemI18n.getString((String)currentType);
        String typeDisp = CompSystemI18n.getString((String)type);
        if (currentType == null) {
            this.m_usageType.put(guid, this.m_mostAbstract);
            currentType = this.m_mostAbstract;
        }
        if (currentType.equals("guidancer.abstract.Unknown")) {
            return;
        }
        String newType = CompNameTypeManager.calcUsageType(currentType, type);
        if (newType.equals("guidancer.abstract.Unknown")) {
            ArrayList<String> info = new ArrayList<String>(2);
            info.add(typeDisp);
            info.add(currentTypeDisp);
            info.add(this.m_lastTypeChange.get(guid));
            info.add(node.getGuid());
            this.m_problemInfo.put(guid, info);
        } else if (!StringUtils.equals((String)currentTypeDisp, (String)CompSystemI18n.getString((String)newType))) {
            this.m_lastTypeChange.put(guid, node.getGuid());
        }
        this.m_usageType.put(guid, newType);
    }

    private void setCompNamePairTypes(IExecTestCasePO exec, Map<String, String> specMap) {
        for (ICompNamesPairPO pair : exec.getCompNamesPairs()) {
            if (!this.m_writeTypes) continue;
            String resGuid = CompNameManager.getInstance().resolveGuid(pair.getFirstName());
            pair.setType(specMap.get(resGuid));
        }
    }

    public void writeCompNameTypesAndProblems() {
        for (IComponentNamePO cN : CompNameManager.getInstance().getAllCompNamePOs()) {
            String guid = CompNameManager.getInstance().resolveGuid(cN.getGuid());
            if (this.m_usageType.containsKey(guid)) {
                cN.setUsageType(this.m_usageType.get(guid));
                cN.setComponentType(this.m_globalType.get(guid));
            } else {
                cN.setUsageType(this.m_mostAbstract);
                cN.setComponentType(this.m_mostAbstract);
            }
            if (!this.m_allProblems.containsKey(guid)) continue;
            cN.setTypeProblem(ProblemFactory.createIncompatibleTypeProblem(cN, this.m_allProblems.get(guid)));
        }
    }

    public void writeLocalTypes() {
        for (IComponentNamePO cN : this.m_cache.getLocalChanges().values()) {
            if (!this.m_globalType.containsKey(cN.getGuid())) continue;
            cN.setComponentType(this.m_globalType.get(cN.getGuid()));
        }
    }

    public Map<String, ProblemType> getNewProblems() {
        HashMap<String, ProblemType> newProblems = new HashMap<String, ProblemType>();
        for (String guid : this.m_allProblems.keySet()) {
            IComponentNamePO cN = this.m_cache.getResCompNamePOByGuid(guid);
            if (cN == null || cN.getTypeProblem() != null && !cN.getTypeProblem().getProblemType().equals((Object)this.m_allProblems.get(guid))) continue;
            newProblems.put(guid, this.m_allProblems.get(guid));
        }
        return newProblems;
    }

    public Map<String, ProblemType> getAllProblems() {
        return this.m_allProblems;
    }

    public List<String> getProblemInfo(String guid) {
        return this.m_problemInfo.get(guid);
    }

    public static void recalculateCompNamePairs(IComponentNameCache cache, INodePO spec) {
        CalcTypes calc = new CalcTypes(cache, spec);
        calc.setWriteTypes(true);
        calc.calculateLocalType(spec, null);
    }

    public Map<String, String> getLocalTypes(INodePO node) {
        return this.m_localType.get(node.getId());
    }
}

