/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.AnonymousClassDeclaration;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.ast.rewrite.ImportRewrite;
import org.eclipse.php.internal.core.ast.rewrite.ListRewrite;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.corext.codemanipulation.StubUtility;
import org.eclipse.php.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.php.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.TextEditGroup;

public class UnimplementedMethodsCorrectionProposal
extends ASTRewriteCorrectionProposal {
    private ASTNode fTypeNode;

    public UnimplementedMethodsCorrectionProposal(ISourceModule cu, ASTNode typeNode, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.setDisplayName(CorrectionMessages.UnimplementedMethodsCorrectionProposal_description);
        this.setImage(DLTKPluginImages.get((String)"org.eclipse.dltk.ui.correction_change.png"));
        this.fTypeNode = typeNode;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        ClassDeclaration decl;
        AST ast = this.fTypeNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        IMethod[] methods = null;
        boolean isInterface = false;
        ListRewrite listRewrite = null;
        if (this.fTypeNode instanceof ClassDeclaration) {
            decl = (ClassDeclaration)this.fTypeNode;
            ITypeBinding binding = decl.resolveTypeBinding();
            listRewrite = rewrite.getListRewrite((ASTNode)decl.getBody(), Block.STATEMENTS_PROPERTY);
            methods = PHPModelUtils.getUnimplementedMethods((IType)((IType)binding.getPHPElement()), null);
            isInterface = binding.isInterface();
        } else if (this.fTypeNode instanceof AnonymousClassDeclaration) {
            decl = (AnonymousClassDeclaration)this.fTypeNode;
            listRewrite = rewrite.getListRewrite((ASTNode)decl.getBody(), Block.STATEMENTS_PROPERTY);
            IModelElement element = this.getCompilationUnit().getElementAt(this.fTypeNode.getStart());
            methods = PHPModelUtils.getUnimplementedMethods((IType)((IType)element), null);
        } else {
            return null;
        }
        Program program = (Program)this.fTypeNode.getRoot();
        ImportRewrite imports = this.createImportRewrite(program);
        NamespaceDeclaration namespace = program.getNamespaceDeclaration(this.fTypeNode.getStart());
        int i = 0;
        while (i < methods.length) {
            MethodDeclaration newMethodDecl = StubUtility.createImplementationStub(this.getCompilationUnit(), namespace, rewrite, imports, methods[i], isInterface);
            listRewrite.insertLast((ASTNode)newMethodDecl, this.createTextEditGroup(CorrectionMessages.AddUnimplementedMethodsOperation_AddMissingMethod_group));
            ++i;
        }
        return rewrite;
    }

    protected TextEditGroup createTextEditGroup(String label) {
        if (label.length() > 0) {
            return new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label)));
        }
        return new TextEditGroup(label);
    }
}

