/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.tests.initialize;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.pmf.emf.EMFType;
import org.eclipse.pmf.pim.Application;
import org.eclipse.pmf.pim.DataFormFolder;
import org.eclipse.pmf.pim.Library;
import org.eclipse.pmf.pim.data.DataType;
import org.eclipse.pmf.pim.tests.AbstractProjectTest;
import org.eclipse.pmf.pim.util.PMFUtil;
import org.junit.Test;

public class ResourceFileCreationTest
extends AbstractProjectTest {
    @Test
    public void applicationCreation() {
        String name = "TestApplication";
        IFile file = this.project.getFile("model/Application.pmf");
        try {
            Resource resource = PMFUtil.createApplicationResource((IFile)file, (String)name, (String)"UTF-8", null);
            ResourceFileCreationTest.assertTrue((resource.getContents().size() == 1 ? 1 : 0) != 0);
            EObject object = (EObject)resource.getContents().get(0);
            ResourceFileCreationTest.assertTrue((boolean)(object instanceof Application));
            Application application = (Application)object;
            ResourceFileCreationTest.assertEquals((String)name, (String)application.getName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void libraryCreation() {
        String name = "TestLibrary";
        IFile file = this.project.getFile("model/Library.pmf");
        try {
            Resource resource = PMFUtil.createLibraryResource((IFile)file, (String)name, (String)"UTF-8", null);
            ResourceFileCreationTest.assertTrue((resource.getContents().size() == 1 ? 1 : 0) != 0);
            EObject object = (EObject)resource.getContents().get(0);
            ResourceFileCreationTest.assertTrue((boolean)(object instanceof Library));
            Library library = (Library)object;
            ResourceFileCreationTest.assertEquals((String)name, (String)library.getName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void modelImportEcore() {
        this.modelImport("PrimitiveType.ecore");
    }

    @Test
    public void modelImportGenModel() {
        this.modelImport("PrimitiveType.genmodel");
    }

    public void modelImport(String fileName) {
        try {
            InputStream ecore = ResourceFileCreationTest.class.getResourceAsStream(fileName);
            if (ecore == null) {
                throw new RuntimeException("Need to remove the ecore from Windows->Preferences->Java->Compiler->Building->Filtered Resources");
            }
            int size = ecore.available();
            this.copyFile(this.project, ecore, new Path("model").append(fileName));
            IFile modelFile = this.project.getFile("model/" + fileName);
            ResourceFileCreationTest.assertTrue((boolean)modelFile.exists());
            ResourceFileCreationTest.assertFalse((boolean)modelFile.isLinked());
            ResourceFileCreationTest.assertTrue((boolean)modelFile.isAccessible());
            ResourceFileCreationTest.assertEquals((int)size, (int)modelFile.getContents().available());
            String name = "TestApplicationImport";
            IFile file = this.project.getFile("model/ApplicationImport.pmf");
            Resource resource = PMFUtil.createApplicationResource((IFile)file, (String)name, (String)"UTF-8", null);
            Application application = PMFUtil.getApplication((Resource)resource);
            ResourceSet resourceSet = resource.getResourceSet();
            Resource modelResource = resourceSet.getResource(URI.createFileURI((String)modelFile.getFullPath().toOSString()), true);
            application.importModel(modelResource);
            resource.save(Collections.EMPTY_MAP);
            resourceSet = new ResourceSetImpl();
            Resource appResource = resourceSet.getResource(URI.createFileURI((String)file.getFullPath().toOSString()), true);
            application = PMFUtil.getApplication((Resource)appResource);
            EList datatypes = application.getTypes();
            EMap dataMap = application.getDataFormFolders();
            ResourceFileCreationTest.assertEquals((int)modelResource.getContents().size(), (int)datatypes.size());
            ResourceFileCreationTest.assertEquals((int)modelResource.getContents().size(), (int)dataMap.size());
            HashMap<String, DataFormFolder> map = new HashMap<String, DataFormFolder>();
            for (DataType dataType : datatypes) {
                ResourceFileCreationTest.assertTrue((boolean)(dataType instanceof EMFType));
                EMFType emfType = (EMFType)dataType;
                EClassifier classifier = emfType.getContent();
                map.put(classifier.getInstanceClassName(), (DataFormFolder)dataMap.get((Object)dataType));
            }
            TreeIterator iterator = modelResource.getAllContents();
            while (iterator.hasNext()) {
                EObject element = (EObject)iterator.next();
                if (!(element instanceof EClassifier)) continue;
                EClassifier classifier = (EClassifier)element;
                ResourceFileCreationTest.assertTrue((boolean)map.containsKey(classifier.getInstanceClassName()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void checkDataType() {
    }
}

