/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.XMLAttributes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.IdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.ComplexTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedPLSQLStoredFunctionQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedPLSQLStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredFunctionQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.OracleArrayTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.OracleComplexTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.OracleObjectTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLComplexTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLRecordMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.QueryHintMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.StoredProcedureParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.structures.ArrayAccessor;
import org.eclipse.persistence.internal.jpa.metadata.structures.StructMetadata;
import org.eclipse.persistence.internal.jpa.metadata.structures.StructureAccessor;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.structures.ArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.mappings.structures.StructureMapping;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredFunctionCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.StoredFunctionCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectTableType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCollectionType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLRecordType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.VArrayType;

public class XmlEntityMappingsGenerator {
    static final String IN_STR = "IN";
    static final String INOUT_STR = "IN_OUT";
    static final String OUT_STR = "OUT";
    static final String CURSOR_STR = "OUT_CURSOR";
    static final String ARRAYLIST_STR = "java.util.ArrayList";
    static final String STRING_STR = "java.lang.String";

    public static XMLEntityMappings generateXmlEntityMappings(Project orProject, List<CompositeDatabaseType> complexTypes, Map<String, Map<String, String>> crudOperations) {
        List descriptors = orProject.getOrderedDescriptors();
        List queries = orProject.getQueries();
        XMLEntityMappings xmlEntityMappings = new XMLEntityMappings();
        xmlEntityMappings.setEmbeddables(new ArrayList());
        xmlEntityMappings.setEntities(new ArrayList());
        xmlEntityMappings.setPLSQLRecords(new ArrayList());
        xmlEntityMappings.setPLSQLTables(new ArrayList());
        xmlEntityMappings.setOracleObjectTypes(new ArrayList());
        xmlEntityMappings.setOracleArrayTypes(new ArrayList());
        ArrayList<PLSQLRecordMetadata> plsqlRecords = null;
        ArrayList<PLSQLTableMetadata> plsqlTables = null;
        ArrayList<OracleObjectTypeMetadata> objectTypes = null;
        ArrayList<OracleArrayTypeMetadata> arrayTypes = null;
        List<ComplexTypeMetadata> complexTypeMetadata = XmlEntityMappingsGenerator.processCompositeTypes(complexTypes, orProject);
        for (ComplexTypeMetadata cTypeMetadata : complexTypeMetadata) {
            if (cTypeMetadata.isOracleComplexTypeMetadata()) {
                OracleComplexTypeMetadata octMetadata = (OracleComplexTypeMetadata)cTypeMetadata;
                if (octMetadata.isOracleArrayTypeMetadata()) {
                    if (arrayTypes == null) {
                        arrayTypes = new ArrayList<OracleArrayTypeMetadata>();
                    }
                    arrayTypes.add((OracleArrayTypeMetadata)octMetadata);
                    continue;
                }
                if (objectTypes == null) {
                    objectTypes = new ArrayList<OracleObjectTypeMetadata>();
                }
                objectTypes.add((OracleObjectTypeMetadata)octMetadata);
                continue;
            }
            PLSQLComplexTypeMetadata plsqlctMetadata = (PLSQLComplexTypeMetadata)cTypeMetadata;
            if (plsqlctMetadata.isPLSQLRecordMetadata()) {
                if (plsqlRecords == null) {
                    plsqlRecords = new ArrayList<PLSQLRecordMetadata>();
                }
                plsqlRecords.add((PLSQLRecordMetadata)plsqlctMetadata);
                continue;
            }
            if (plsqlTables == null) {
                plsqlTables = new ArrayList<PLSQLTableMetadata>();
            }
            plsqlTables.add((PLSQLTableMetadata)plsqlctMetadata);
        }
        xmlEntityMappings.setPLSQLRecords(plsqlRecords);
        xmlEntityMappings.setPLSQLTables(plsqlTables);
        xmlEntityMappings.setOracleObjectTypes(objectTypes);
        xmlEntityMappings.setOracleArrayTypes(arrayTypes);
        ArrayList<NamedPLSQLStoredFunctionQueryMetadata> plsqlStoredProcs = null;
        ArrayList<NamedPLSQLStoredFunctionQueryMetadata> plsqlStoredFuncs = null;
        ArrayList<NamedPLSQLStoredFunctionQueryMetadata> storedProcs = null;
        ArrayList<NamedPLSQLStoredFunctionQueryMetadata> storedFuncs = null;
        ArrayList<NamedNativeQueryMetadata> namedNativeQueries = null;
        for (DatabaseQuery query : queries) {
            int i;
            Object paramFields;
            PLSQLParameterMetadata param;
            PLSQLargument arg;
            ArrayList<PLSQLParameterMetadata> params;
            NamedPLSQLStoredFunctionQueryMetadata metadata;
            PLSQLStoredFunctionCall call;
            if (query.getCall().isStoredFunctionCall()) {
                if (query.getCall() instanceof PLSQLStoredFunctionCall) {
                    call = (PLSQLStoredFunctionCall)query.getCall();
                    metadata = new NamedPLSQLStoredFunctionQueryMetadata();
                    metadata.setName(query.getName());
                    metadata.setProcedureName(call.getProcedureName());
                    params = new ArrayList<PLSQLParameterMetadata>();
                    if (plsqlStoredFuncs == null) {
                        plsqlStoredFuncs = new ArrayList<NamedPLSQLStoredFunctionQueryMetadata>();
                    }
                    List types = call.getArguments();
                    for (int i2 = 0; i2 < types.size(); ++i2) {
                        arg = (PLSQLargument)types.get(i2);
                        param = new PLSQLParameterMetadata();
                        param.setName(arg.name);
                        String dbType = arg.databaseType.getTypeName();
                        if (arg.databaseType == OraclePLSQLTypes.XMLType) {
                            dbType = OraclePLSQLTypes.XMLType.name();
                        } else if (arg.databaseType == OraclePLSQLTypes.PLSQLBoolean) {
                            dbType = OraclePLSQLTypes.PLSQLBoolean.name();
                        } else if (Util.getJDBCTypeFromTypeName(dbType) != 1111) {
                            dbType = dbType.concat("_TYPE");
                        }
                        param.setDatabaseType(dbType);
                        if (i2 == 0) {
                            metadata.setReturnParameter(param);
                            if (!arg.cursorOutput) continue;
                            param.setDirection(CURSOR_STR);
                            continue;
                        }
                        param.setDirection(XmlEntityMappingsGenerator.getDirectionAsString(arg.direction));
                        params.add(param);
                    }
                    if (params.size() > 0) {
                        metadata.setParameters(params);
                    }
                    plsqlStoredFuncs.add(metadata);
                    continue;
                }
                call = (StoredFunctionCall)query.getCall();
                metadata = new NamedStoredFunctionQueryMetadata();
                metadata.setName(query.getName());
                metadata.setProcedureName(call.getProcedureName());
                params = new ArrayList();
                if (storedFuncs == null) {
                    storedFuncs = new ArrayList<NamedPLSQLStoredFunctionQueryMetadata>();
                }
                paramFields = call.getParameters();
                List types = call.getParameterTypes();
                for (i = 0; i < paramFields.size(); ++i) {
                    arg = (DatabaseField)paramFields.get(i);
                    param = new StoredProcedureParameterMetadata();
                    param.setTypeName(arg.getTypeName());
                    if (arg.getSqlType() != Integer.MIN_VALUE) {
                        param.setJdbcType(Integer.valueOf(arg.getSqlType()));
                    }
                    if (arg.isObjectRelationalDatabaseField()) {
                        param.setJdbcTypeName(((ObjectRelationalDatabaseField)arg).getSqlTypeName());
                    }
                    if (i == 0) {
                        metadata.setReturnParameter((StoredProcedureParameterMetadata)param);
                        if (types.get(i) != DatasourceCall.ParameterType.OUT_CURSOR) continue;
                        XmlEntityMappingsGenerator.addQueryHint((NamedNativeQueryMetadata)metadata);
                        continue;
                    }
                    param.setName(arg.getName());
                    param.setMode(XmlEntityMappingsGenerator.getParameterModeAsString((DatasourceCall.ParameterType)types.get(i)));
                    params.add(param);
                }
                if (params.size() > 0) {
                    metadata.setParameters(params);
                }
                storedFuncs.add(metadata);
                continue;
            }
            if (query.getCall().isStoredProcedureCall()) {
                if (query.getCall() instanceof PLSQLStoredProcedureCall) {
                    call = (PLSQLStoredProcedureCall)query.getCall();
                    if (plsqlStoredProcs == null) {
                        plsqlStoredProcs = new ArrayList<NamedPLSQLStoredFunctionQueryMetadata>();
                    }
                    metadata = new NamedPLSQLStoredProcedureQueryMetadata();
                    metadata.setName(query.getName());
                    metadata.setProcedureName(call.getProcedureName());
                    ArrayList<PLSQLParameterMetadata> params2 = new ArrayList<PLSQLParameterMetadata>();
                    List types = call.getArguments();
                    for (PLSQLargument arg2 : types) {
                        PLSQLParameterMetadata param2 = new PLSQLParameterMetadata();
                        param2.setName(arg2.name);
                        String dbType = XmlEntityMappingsGenerator.processTypeName(arg2.databaseType.getTypeName());
                        if (arg2.cursorOutput) {
                            param2.setDirection(CURSOR_STR);
                        } else {
                            param2.setDirection(XmlEntityMappingsGenerator.getDirectionAsString(arg2.direction));
                        }
                        if (arg2.databaseType == OraclePLSQLTypes.XMLType) {
                            param2.setDatabaseType(OraclePLSQLTypes.XMLType.name());
                        } else if (arg2.databaseType == OraclePLSQLTypes.PLSQLBoolean) {
                            param2.setDatabaseType(OraclePLSQLTypes.PLSQLBoolean.name());
                        } else {
                            param2.setDatabaseType(dbType);
                        }
                        params2.add(param2);
                    }
                    if (params2.size() > 0) {
                        metadata.setParameters(params2);
                    }
                    plsqlStoredProcs.add(metadata);
                    continue;
                }
                call = (StoredProcedureCall)query.getCall();
                metadata = new NamedStoredProcedureQueryMetadata();
                metadata.setName(query.getName());
                metadata.setProcedureName(call.getProcedureName());
                metadata.setReturnsResultSet(Boolean.valueOf(false));
                params = new ArrayList();
                paramFields = call.getParameters();
                List types = call.getParameterTypes();
                for (i = 0; i < paramFields.size(); ++i) {
                    arg = types.get(i) == DatasourceCall.ParameterType.INOUT ? (DatabaseField)((Object[])paramFields.get(i))[1] : (DatabaseField)paramFields.get(i);
                    param = new StoredProcedureParameterMetadata();
                    param.setName(arg.getName());
                    param.setTypeName(arg.getTypeName());
                    if (arg.getSqlType() != Integer.MIN_VALUE) {
                        param.setJdbcType(Integer.valueOf(arg.getSqlType()));
                    }
                    if (arg.isObjectRelationalDatabaseField()) {
                        param.setJdbcTypeName(((ObjectRelationalDatabaseField)arg).getSqlTypeName());
                    }
                    param.setMode(XmlEntityMappingsGenerator.getParameterModeAsString((DatasourceCall.ParameterType)types.get(i)));
                    if (types.get(i) == DatasourceCall.ParameterType.OUT_CURSOR) {
                        XmlEntityMappingsGenerator.addQueryHint((NamedNativeQueryMetadata)metadata);
                    }
                    params.add(param);
                }
                if (params.size() > 0) {
                    metadata.setParameters(params);
                }
                if (storedProcs == null) {
                    storedProcs = new ArrayList<NamedPLSQLStoredFunctionQueryMetadata>();
                }
                storedProcs.add(metadata);
                continue;
            }
            NamedNativeQueryMetadata namedQuery = new NamedNativeQueryMetadata();
            namedQuery.setName(query.getName());
            namedQuery.setQuery(query.getSQLString());
            namedQuery.setResultClassName(query.getReferenceClassName());
            if (namedNativeQueries == null) {
                namedNativeQueries = new ArrayList<NamedNativeQueryMetadata>();
            }
            namedNativeQueries.add(namedQuery);
        }
        if (plsqlStoredProcs != null) {
            xmlEntityMappings.setNamedPLSQLStoredProcedureQueries(plsqlStoredProcs);
        }
        if (plsqlStoredFuncs != null) {
            xmlEntityMappings.setNamedPLSQLStoredFunctionQueries(plsqlStoredFuncs);
        }
        if (storedProcs != null) {
            xmlEntityMappings.setNamedStoredProcedureQueries(storedProcs);
        }
        if (storedFuncs != null) {
            xmlEntityMappings.setNamedStoredFunctionQueries(storedFuncs);
        }
        if (namedNativeQueries != null) {
            xmlEntityMappings.setNamedNativeQueries(namedNativeQueries);
        }
        ArrayList<String> embeddables = new ArrayList<String>();
        HashMap<String, EntityAccessor> accessors = new HashMap<String, EntityAccessor>();
        for (ClassDescriptor cdesc : descriptors) {
            ObjectRelationalDataTypeDescriptor odesc;
            EntityAccessor classAccessor;
            boolean embeddable = false;
            if (cdesc.isAggregateDescriptor()) {
                embeddable = true;
                classAccessor = new EmbeddableAccessor();
                embeddables.add(cdesc.getJavaClassName());
            } else {
                classAccessor = new EntityAccessor();
            }
            classAccessor.setClassName(cdesc.getJavaClassName());
            classAccessor.setAccess("VIRTUAL");
            if (cdesc.isObjectRelationalDataTypeDescriptor() && (odesc = (ObjectRelationalDataTypeDescriptor)cdesc).getOrderedFields().size() > 0) {
                StructMetadata struct = new StructMetadata();
                struct.setName(odesc.getStructureName());
                struct.setFields((List)odesc.getOrderedFields());
                classAccessor.setStruct(struct);
            }
            if (!embeddable && cdesc.getTableName() != null) {
                TableMetadata table = new TableMetadata();
                table.setName(cdesc.getTableName());
                classAccessor.setTable(table);
            }
            if (!embeddable) {
                ArrayList<NamedNativeQueryMetadata> namedNatQueries = new ArrayList<NamedNativeQueryMetadata>();
                for (DatabaseQuery dbQuery : cdesc.getQueryManager().getAllQueries()) {
                    NamedNativeQueryMetadata namedQuery = new NamedNativeQueryMetadata();
                    namedQuery.setName(dbQuery.getName());
                    namedQuery.setQuery(dbQuery.getSQLString());
                    namedQuery.setResultClassName(dbQuery.getReferenceClassName());
                    namedNatQueries.add(namedQuery);
                }
                Map<String, String> crudOps = crudOperations.get(cdesc.getTableName());
                if (!crudOps.isEmpty()) {
                    for (String opName : crudOps.keySet()) {
                        String crudSql = crudOps.get(opName);
                        NamedNativeQueryMetadata crudQuery = new NamedNativeQueryMetadata();
                        crudQuery.setName(opName);
                        crudQuery.setQuery(crudSql);
                        namedNatQueries.add(crudQuery);
                    }
                }
                if (namedNatQueries.size() > 0) {
                    classAccessor.setNamedNativeQueries(namedNatQueries);
                }
            }
            classAccessor.setAttributes(new XMLAttributes());
            classAccessor.getAttributes().setIds(new ArrayList());
            classAccessor.getAttributes().setBasics(new ArrayList());
            classAccessor.getAttributes().setArrays(new ArrayList());
            classAccessor.getAttributes().setStructures(new ArrayList());
            classAccessor.getAttributes().setEmbeddeds(new ArrayList());
            if (embeddable) {
                xmlEntityMappings.getEmbeddables().add((EmbeddableAccessor)classAccessor);
            } else {
                xmlEntityMappings.getEntities().add(classAccessor);
            }
            accessors.put(cdesc.getJavaClassName(), classAccessor);
        }
        for (ClassDescriptor cdesc : descriptors) {
            ClassAccessor classAccessor = (ClassAccessor)accessors.get(cdesc.getJavaClassName());
            for (DatabaseMapping dbMapping : cdesc.getMappings()) {
                MappingAccessor mapAccessor = XmlEntityMappingsGenerator.generateMappingAccessor(dbMapping, embeddables);
                if (mapAccessor == null) continue;
                if (mapAccessor.isId()) {
                    classAccessor.getAttributes().getIds().add((IdAccessor)mapAccessor);
                    continue;
                }
                if (mapAccessor.isBasic()) {
                    classAccessor.getAttributes().getBasics().add((BasicAccessor)mapAccessor);
                    continue;
                }
                if (mapAccessor instanceof ArrayAccessor) {
                    classAccessor.getAttributes().getArrays().add((ArrayAccessor)mapAccessor);
                    continue;
                }
                if (mapAccessor instanceof StructureAccessor) {
                    classAccessor.getAttributes().getStructures().add((StructureAccessor)mapAccessor);
                    continue;
                }
                classAccessor.getAttributes().getEmbeddeds().add((EmbeddedAccessor)mapAccessor);
            }
        }
        return xmlEntityMappings;
    }

    protected static MappingAccessor generateMappingAccessor(DatabaseMapping mapping, List<String> embeddables) {
        BasicAccessor mapAccessor = null;
        if (mapping.isDirectToFieldMapping()) {
            mapAccessor = XmlEntityMappingsGenerator.processDirectMapping((DirectToFieldMapping)mapping);
        } else if (mapping instanceof ObjectArrayMapping) {
            mapAccessor = XmlEntityMappingsGenerator.processObjectArrayMapping((ObjectArrayMapping)mapping);
        } else if (mapping instanceof ArrayMapping) {
            mapAccessor = XmlEntityMappingsGenerator.processArrayMapping((ArrayMapping)mapping);
        } else if (mapping.isStructureMapping()) {
            mapAccessor = XmlEntityMappingsGenerator.processStructureMapping((StructureMapping)mapping);
        } else if (embeddables.contains(((AggregateMapping)mapping).getReferenceClassName())) {
            mapAccessor = XmlEntityMappingsGenerator.processEmbeddedMapping((AggregateMapping)mapping);
        }
        return mapAccessor;
    }

    protected static BasicAccessor processDirectMapping(DirectToFieldMapping mapping) {
        Object directMapping = mapping.getDescriptor().getPrimaryKeyFields().contains(mapping.getField()) ? new IdAccessor() : new BasicAccessor();
        directMapping.setName(mapping.getAttributeName());
        directMapping.setAttributeType(mapping.getAttributeClassificationName());
        ColumnMetadata column = new ColumnMetadata();
        column.setName(mapping.getField().getName());
        directMapping.setColumn(column);
        return directMapping;
    }

    protected static ArrayAccessor processArrayMapping(ArrayMapping mapping) {
        ArrayAccessor arrayAccessor = new ArrayAccessor();
        arrayAccessor.setName(mapping.getAttributeName());
        arrayAccessor.setDatabaseType(mapping.getStructureName());
        arrayAccessor.setAttributeType(ARRAYLIST_STR);
        arrayAccessor.setTargetClassName(mapping.getStructureName());
        ColumnMetadata column = new ColumnMetadata();
        column.setName(mapping.getField().getName());
        arrayAccessor.setColumn(column);
        return arrayAccessor;
    }

    protected static ArrayAccessor processObjectArrayMapping(ObjectArrayMapping mapping) {
        ArrayAccessor arrayAccessor = new ArrayAccessor();
        arrayAccessor.setName(mapping.getAttributeName());
        arrayAccessor.setDatabaseType(mapping.getStructureName());
        arrayAccessor.setTargetClassName(mapping.getReferenceClassName());
        arrayAccessor.setAttributeType(ARRAYLIST_STR);
        ColumnMetadata column = new ColumnMetadata();
        column.setName(mapping.getField().getName());
        arrayAccessor.setColumn(column);
        return arrayAccessor;
    }

    protected static StructureAccessor processStructureMapping(StructureMapping mapping) {
        StructureAccessor structAccessor = new StructureAccessor();
        structAccessor.setName(mapping.getAttributeName());
        structAccessor.setTargetClassName(mapping.getReferenceClassName());
        structAccessor.setAttributeType(mapping.getReferenceClassName());
        ColumnMetadata column = new ColumnMetadata();
        column.setName(mapping.getField().getName());
        structAccessor.setColumn(column);
        return structAccessor;
    }

    protected static EmbeddedAccessor processEmbeddedMapping(AggregateMapping mapping) {
        EmbeddedAccessor embeddedAccessor = new EmbeddedAccessor();
        embeddedAccessor.setName(mapping.getAttributeName());
        embeddedAccessor.setAttributeType(mapping.getReferenceClassName());
        return embeddedAccessor;
    }

    public static String getDirectionAsString(DatasourceCall.ParameterType direction) {
        if (direction == DatasourceCall.ParameterType.IN) {
            return IN_STR;
        }
        if (direction == DatasourceCall.ParameterType.OUT) {
            return OUT_STR;
        }
        if (direction == DatasourceCall.ParameterType.INOUT) {
            return INOUT_STR;
        }
        return CURSOR_STR;
    }

    public static String getParameterModeAsString(DatasourceCall.ParameterType direction) {
        if (direction == DatasourceCall.ParameterType.IN) {
            return IN_STR;
        }
        if (direction == DatasourceCall.ParameterType.OUT) {
            return OUT_STR;
        }
        if (direction == DatasourceCall.ParameterType.INOUT) {
            return "INOUT";
        }
        return "REF_CURSOR";
    }

    protected static String processTypeName(String typeName) {
        if (Util.getJDBCTypeFromTypeName(typeName) != 1111) {
            if (typeName.equals("VARCHAR2")) {
                typeName = "VARCHAR";
            }
            if (!typeName.equals("BOOLEAN") && !typeName.equals("XMLTYPE")) {
                typeName = typeName.concat("_TYPE");
            }
        } else {
            String oPLSQLTypeName = Util.getOraclePLSQLTypeForName(typeName);
            if (oPLSQLTypeName != null) {
                typeName = oPLSQLTypeName;
            }
        }
        return typeName;
    }

    protected static List<ComplexTypeMetadata> processCompositeTypes(List<CompositeDatabaseType> complexTypes, Project orProject) {
        ArrayList<String> processedTypeNames = new ArrayList<String>();
        ArrayList<ComplexTypeMetadata> processedTypes = new ArrayList<ComplexTypeMetadata>();
        for (CompositeDatabaseType cdbType : complexTypes) {
            ComplexTypeMetadata complexTypeMetadata = XmlEntityMappingsGenerator.processDatabaseType(cdbType, orProject);
            if (complexTypeMetadata == null) continue;
            processedTypeNames.add(complexTypeMetadata.getName());
            processedTypes.add(complexTypeMetadata);
        }
        for (CompositeDatabaseType cdbType : complexTypes) {
            VArrayType vType;
            CompositeDatabaseType enclosedType;
            ComplexTypeMetadata complexTypeMetadata;
            if (cdbType.getEnclosedType() == null || !cdbType.getEnclosedType().isComposite() || (complexTypeMetadata = XmlEntityMappingsGenerator.processDatabaseType(enclosedType = (CompositeDatabaseType)cdbType.getEnclosedType(), orProject, processedTypeNames)) == null) continue;
            processedTypeNames.add(complexTypeMetadata.getName());
            processedTypes.add(complexTypeMetadata);
            if (enclosedType.isObjectType()) {
                for (FieldType ft : ((ObjectType)enclosedType).getFields()) {
                    if (!ft.isComposite() || (complexTypeMetadata = XmlEntityMappingsGenerator.processDatabaseType((CompositeDatabaseType)ft, orProject, processedTypeNames)) == null) continue;
                    processedTypeNames.add(complexTypeMetadata.getName());
                    processedTypes.add(complexTypeMetadata);
                }
                continue;
            }
            if (!enclosedType.isVArrayType() || !(vType = (VArrayType)enclosedType).getEnclosedType().isComposite() || (complexTypeMetadata = XmlEntityMappingsGenerator.processDatabaseType((CompositeDatabaseType)vType.getEnclosedType(), orProject, processedTypeNames)) == null) continue;
            processedTypeNames.add(complexTypeMetadata.getName());
            processedTypes.add(complexTypeMetadata);
        }
        return processedTypes;
    }

    protected static ComplexTypeMetadata processDatabaseType(CompositeDatabaseType cdbType, Project orProject) {
        return XmlEntityMappingsGenerator.processDatabaseType(cdbType, orProject, new ArrayList<String>());
    }

    protected static ComplexTypeMetadata processDatabaseType(CompositeDatabaseType cdbType, Project orProject, List<String> processedTypeNames) {
        if (!processedTypeNames.contains(cdbType.getTypeName())) {
            if (cdbType.isPLSQLCollectionType()) {
                return XmlEntityMappingsGenerator.processPLSQLCollectionType((PLSQLCollectionType)cdbType);
            }
            if (cdbType.isPLSQLRecordType()) {
                return XmlEntityMappingsGenerator.processPLSQLRecordType((PLSQLRecordType)cdbType);
            }
            if (cdbType.isObjectTableType()) {
                return XmlEntityMappingsGenerator.processObjectTableType((ObjectTableType)cdbType, orProject);
            }
            if (cdbType.isObjectType()) {
                return XmlEntityMappingsGenerator.processObjectType((ObjectType)cdbType, orProject);
            }
            if (cdbType.isVArrayType()) {
                return XmlEntityMappingsGenerator.processVArrayType((VArrayType)cdbType, orProject);
            }
        }
        return null;
    }

    protected static ComplexTypeMetadata processPLSQLCollectionType(PLSQLCollectionType plsqlCollectionType) {
        String typeName = plsqlCollectionType.getParentType().getPackageName() + "." + plsqlCollectionType.getTypeName();
        String compatiableName = plsqlCollectionType.getParentType().getPackageName() + "_" + plsqlCollectionType.getTypeName();
        PLSQLTableMetadata plsqlTable = new PLSQLTableMetadata();
        plsqlTable.setName(typeName);
        plsqlTable.setCompatibleType(compatiableName);
        plsqlTable.setNestedTable(Boolean.valueOf(!plsqlCollectionType.isIndexed()));
        String dbType = plsqlCollectionType.getEnclosedType().getTypeName();
        if (Util.getJDBCTypeFromTypeName(dbType) != 1111) {
            if (Util.isArgPLSQLScalar(dbType)) {
                plsqlTable.setNestedType(Util.getOraclePLSQLTypeForName(dbType));
            } else {
                if (dbType.equals("VARCHAR2")) {
                    dbType = "VARCHAR";
                }
                plsqlTable.setNestedType(dbType + "_TYPE");
            }
        } else {
            String pkg = null;
            if (plsqlCollectionType.getEnclosedType() != null && plsqlCollectionType.getEnclosedType().isPLSQLType()) {
                PLSQLType pType = (PLSQLType)plsqlCollectionType.getEnclosedType();
                pkg = pType.getParentType().getPackageName();
            }
            plsqlTable.setNestedType((String)(pkg == null ? dbType : pkg + "." + dbType));
        }
        plsqlTable.setJavaType(typeName.toLowerCase() + "_CollectionWrapper");
        return plsqlTable;
    }

    protected static ComplexTypeMetadata processPLSQLRecordType(PLSQLRecordType plsqlRecordType) {
        String compatiableName;
        String packageName = plsqlRecordType.getParentType().getPackageName();
        String typeName = packageName != null ? plsqlRecordType.getParentType().getPackageName() + "." + plsqlRecordType.getTypeName() : plsqlRecordType.getTypeName();
        String string = compatiableName = packageName != null ? plsqlRecordType.getParentType().getPackageName() + "_" + plsqlRecordType.getTypeName() : plsqlRecordType.getTypeName();
        if (compatiableName.contains("%")) {
            compatiableName = compatiableName.replace("%", "_");
        }
        PLSQLRecordMetadata plsqlRecordMetadata = new PLSQLRecordMetadata();
        plsqlRecordMetadata.setName(typeName);
        plsqlRecordMetadata.setCompatibleType(compatiableName);
        if (typeName.endsWith("%ROWTYPE")) {
            plsqlRecordMetadata.setJavaType(compatiableName.toLowerCase());
        } else {
            plsqlRecordMetadata.setJavaType(typeName.toLowerCase());
        }
        ArrayList<PLSQLParameterMetadata> fields = new ArrayList<PLSQLParameterMetadata>();
        for (FieldType fld : plsqlRecordType.getFields()) {
            String dbType;
            PLSQLParameterMetadata field = new PLSQLParameterMetadata();
            field.setName(fld.getFieldName());
            String pkg = null;
            if (fld.getEnclosedType() != null && fld.getEnclosedType().isPLSQLType()) {
                PLSQLType pType = (PLSQLType)fld.getEnclosedType();
                pkg = pType.getParentType().getPackageName();
            }
            if (Util.getJDBCTypeFromTypeName(dbType = fld.getTypeName()) != 1111) {
                if (dbType.equals("VARCHAR2")) {
                    dbType = "VARCHAR";
                }
                if (!dbType.equals("BOOLEAN")) {
                    dbType = dbType.concat("_TYPE");
                }
            }
            dbType = pkg == null ? dbType : pkg + "." + dbType;
            field.setDatabaseType(dbType);
            fields.add(field);
        }
        plsqlRecordMetadata.setFields(fields);
        return plsqlRecordMetadata;
    }

    protected static ComplexTypeMetadata processObjectTableType(ObjectTableType oTableType, Project orProject) {
        ClassDescriptor cDesc = orProject.getDescriptorForAlias(Util.getGeneratedAlias(oTableType.getTypeName()));
        OracleArrayTypeMetadata oatMetadata = new OracleArrayTypeMetadata();
        oatMetadata.setName(oTableType.getTypeName());
        oatMetadata.setJavaType(cDesc.getJavaClassName());
        oatMetadata.setNestedType(oTableType.getEnclosedType().getTypeName());
        return oatMetadata;
    }

    protected static ComplexTypeMetadata processObjectType(ObjectType oType, Project orProject) {
        ClassDescriptor cDesc = orProject.getDescriptorForAlias(Util.getGeneratedAlias(oType.getTypeName()));
        OracleObjectTypeMetadata ootMetadata = new OracleObjectTypeMetadata();
        ootMetadata.setName(oType.getTypeName());
        ootMetadata.setJavaType(cDesc.getJavaClassName());
        ArrayList<PLSQLParameterMetadata> fields = new ArrayList<PLSQLParameterMetadata>();
        for (FieldType ft : oType.getFields()) {
            PLSQLParameterMetadata fieldMetadata = new PLSQLParameterMetadata();
            fieldMetadata.setName(ft.getFieldName());
            fieldMetadata.setDatabaseType(XmlEntityMappingsGenerator.processTypeName(ft.getTypeName()));
            fields.add(fieldMetadata);
        }
        ootMetadata.setFields(fields);
        return ootMetadata;
    }

    protected static ComplexTypeMetadata processVArrayType(VArrayType vType, Project orProject) {
        ClassDescriptor cDesc = orProject.getDescriptorForAlias(Util.getGeneratedAlias(vType.getTypeName()));
        OracleArrayTypeMetadata oatMetadata = new OracleArrayTypeMetadata();
        oatMetadata.setName(vType.getTypeName());
        oatMetadata.setJavaType(cDesc.getJavaClassName());
        oatMetadata.setNestedType(XmlEntityMappingsGenerator.processTypeName(vType.getEnclosedType().getTypeName()));
        return oatMetadata;
    }

    protected static void addQueryHint(NamedNativeQueryMetadata metadata) {
        ArrayList<QueryHintMetadata> hints = metadata.getHints();
        if (hints == null) {
            hints = new ArrayList<QueryHintMetadata>();
        }
        QueryHintMetadata hint = new QueryHintMetadata();
        hint.setName("eclipselink.query-return-name-value-pairs");
        hint.setValue("True");
        hints.add(hint);
        metadata.setHints(hints);
    }
}

