/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.form;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.core.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.form.FormNewOperation;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.s2e.ui.internal.form.FormNewWizardPage;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.s2e.ui.wizard.WizardFinishTask;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class FormNewWizard
extends AbstractWizard
implements INewWizard {
    private static volatile Class<? extends FormNewWizardPage> pageClass = FormNewWizardPage.class;
    private FormNewWizardPage m_page1;
    private WizardFinishTask<FormNewOperation> m_finishTask;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.m_page1 = this.initNewClassWizardWithPage(FormNewWizard.getPage1Class(), S2eUiUtils.getClientPackageOfSelection((ISelection)selection));
        this.m_finishTask = new WizardFinishTask(workbench.getDisplay());
        this.m_finishTask.withOperation(FormNewOperation::new).withMapper(this::mapPageToOperation).withUiAction((op, d) -> d.asyncExec(() -> S2eUiUtils.openInEditor(op.getCreatedForm(), false)));
    }

    public WizardFinishTask<FormNewOperation> getFinishTask() {
        return this.m_finishTask;
    }

    protected void mapPageToOperation(WizardFinishTask.PageToOperationMappingInput input, FormNewOperation op) {
        IJavaProject serverProject;
        FormNewWizardPage page = this.m_page1;
        op.setClientPackage(page.getTargetPackage());
        IClasspathEntry clientSourceFolder = input.environment().toScoutSourceFolder(page.getSourceFolder());
        IScoutApi scoutApi = (IScoutApi)clientSourceFolder.javaEnvironment().requireApi(IScoutApi.class);
        op.setClientSourceFolder(clientSourceFolder);
        IPackageFragmentRoot formTestSourceFolder = S2eUiUtils.getTestSourceFolder((IJavaElement)page.getSourceFolder(), scoutApi.ClientTestRunner().fqn(), "form test");
        if (JdtUtils.exists((IJavaElement)formTestSourceFolder)) {
            op.setClientTestSourceFolder(input.environment().toScoutSourceFolder(formTestSourceFolder));
        }
        op.setCreateFormData(page.isCreateFormData());
        op.setCreatePermissions(page.isCreatePermissions());
        op.setCreateService(page.isCreateService());
        op.setFormName(page.getIcuName());
        if (page.isCreateService()) {
            op.setServerSourceFolder(input.environment().toScoutSourceFolder(page.getServerSourceFolder()));
            serverProject = page.getServerSourceFolder().getJavaProject();
            IPackageFragmentRoot serviceTestSourceFolder = S2eUiUtils.getTestSourceFolder((IJavaElement)page.getServerSourceFolder(), scoutApi.ServerTestRunner().fqn(), "service test");
            if (JdtUtils.exists((IJavaElement)serviceTestSourceFolder)) {
                op.setServerTestSourceFolder(input.environment().toScoutSourceFolder(serviceTestSourceFolder));
            }
        } else {
            serverProject = null;
        }
        if (page.isCreateFormData()) {
            IPackageFragmentRoot sharedSourceFolder = S2eUtils.getDtoSourceFolder((IPackageFragmentRoot)page.getSharedSourceFolder());
            op.setFormDataSourceFolder(input.environment().toScoutSourceFolder(sharedSourceFolder));
        }
        if (page.isCreatePermissions() || page.isCreateService()) {
            op.setSharedSourceFolder(input.environment().toScoutSourceFolder(page.getSharedSourceFolder()));
        }
        op.setSuperType(page.getSuperType().getFullyQualifiedName());
        op.setServerSession((String)S2eUtils.getSession((IJavaProject)serverProject, (ScoutTier)ScoutTier.Server, (IProgressMonitor)input.progress().monitor()).map(IType::getFullyQualifiedName).orElse(null));
    }

    public static Class<? extends FormNewWizardPage> getPage1Class() {
        return pageClass;
    }

    public static void setPage1Class(Class<? extends FormNewWizardPage> page1Class) {
        pageClass = page1Class;
    }
}

