/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.util.sec.misc;

import com.sun.ts.lib.util.sec.misc.MetaIndex;
import com.sun.ts.lib.util.sec.misc.PathPermissions;
import com.sun.ts.lib.util.sec.misc.URLClassPath;
import com.sun.ts.lib.util.sec.net.www.ParseUtil;
import com.sun.ts.lib.util.sec.security.action.GetPropertyAction;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashSet;

public class Launcher {
    private static URLStreamHandlerFactory factory = new Factory();
    private static Launcher launcher = new Launcher();
    private ClassLoader loader;
    private static URLStreamHandler fileHandler;

    public static Launcher getLauncher() {
        return launcher;
    }

    public Launcher() {
        try {
            this.loader = AppClassLoader.getAppClassLoader(new ExtClassLoader(null));
        }
        catch (IOException e) {
            throw new InternalError("Could not create application class loader");
        }
        Thread.currentThread().setContextClassLoader(this.loader);
        String s = System.getProperty("java.security.manager");
        if (s != null) {
            SecurityManager sm = null;
            if ("".equals(s) || "default".equals(s)) {
                sm = new SecurityManager();
            } else {
                try {
                    sm = (SecurityManager)this.loader.loadClass(s).newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (sm != null) {
                System.setSecurityManager(sm);
            } else {
                throw new InternalError("Could not create SecurityManager: " + s);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public static URLClassPath getBootstrapClassPath() {
        URL[] urls;
        String prop = AccessController.doPrivileged(new GetPropertyAction("sun.boot.class.path"));
        if (prop != null) {
            final String path = prop;
            urls = (URL[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    File[] classPath = Launcher.getClassPath(path);
                    int len = classPath.length;
                    HashSet<File> seenDirs = new HashSet<File>();
                    for (int i = 0; i < len; ++i) {
                        File curEntry = classPath[i];
                        if (!curEntry.isDirectory()) {
                            curEntry = curEntry.getParentFile();
                        }
                        if (curEntry == null || !seenDirs.add(curEntry)) continue;
                        MetaIndex.registerDirectory(curEntry);
                    }
                    return Launcher.pathToURLs(classPath);
                }
            });
        } else {
            urls = new URL[]{};
        }
        return new URLClassPath(urls, factory);
    }

    private static URL[] pathToURLs(File[] path) {
        URL[] urls = new URL[path.length];
        for (int i = 0; i < path.length; ++i) {
            urls[i] = Launcher.getFileURL(path[i]);
        }
        return urls;
    }

    private static File[] getClassPath(String cp) {
        File[] path;
        if (cp != null) {
            int count = 0;
            int maxCount = 1;
            int pos = 0;
            int lastPos = 0;
            while ((pos = cp.indexOf(File.pathSeparator, lastPos)) != -1) {
                ++maxCount;
                lastPos = pos + 1;
            }
            path = new File[maxCount];
            pos = 0;
            lastPos = 0;
            while ((pos = cp.indexOf(File.pathSeparator, lastPos)) != -1) {
                path[count++] = pos - lastPos > 0 ? new File(cp.substring(lastPos, pos)) : new File(".");
                lastPos = pos + 1;
            }
            path[count++] = lastPos < cp.length() ? new File(cp.substring(lastPos)) : new File(".");
            if (count != maxCount) {
                File[] tmp = new File[count];
                System.arraycopy(path, 0, tmp, 0, count);
                path = tmp;
            }
        } else {
            path = new File[]{};
        }
        return path;
    }

    static URL getFileURL(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return ParseUtil.fileToEncodedURL(file);
        }
        catch (MalformedURLException e) {
            throw new InternalError();
        }
    }

    static class ExtClassLoader
    extends URLClassLoader {
        void addExtURL(URL url) {
            super.addURL(url);
        }

        public ExtClassLoader(File[] ignore) throws IOException {
            super(new URL[0], null, factory);
        }

        @Override
        public String findLibrary(String name) {
            return null;
        }

        private static AccessControlContext getContext(File[] dirs) throws IOException {
            PathPermissions perms = new PathPermissions(dirs);
            ProtectionDomain domain = new ProtectionDomain(new CodeSource(perms.getCodeBase(), (Certificate[])null), perms);
            AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{domain});
            return acc;
        }
    }

    static class AppClassLoader
    extends URLClassLoader {
        public static ClassLoader getAppClassLoader(final ClassLoader extcl) throws IOException {
            final String s = System.getProperty("java.class.path");
            final File[] path = s == null ? new File[]{} : Launcher.getClassPath(s);
            return (AppClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL[] urls = s == null ? new URL[]{} : Launcher.pathToURLs(path);
                    return new AppClassLoader(urls, extcl);
                }
            });
        }

        AppClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent, factory);
        }

        public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            SecurityManager sm;
            int i = name.lastIndexOf(46);
            if (i != -1 && (sm = System.getSecurityManager()) != null) {
                sm.checkPackageAccess(name.substring(0, i));
            }
            return super.loadClass(name, resolve);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codesource) {
            PermissionCollection perms = super.getPermissions(codesource);
            perms.add(new RuntimePermission("exitVM"));
            return perms;
        }

        private void appendToClassPathForInstrumentation(String path) {
            assert (Thread.holdsLock(this));
            super.addURL(Launcher.getFileURL(new File(path)));
        }

        private static AccessControlContext getContext(File[] cp) throws MalformedURLException {
            PathPermissions perms = new PathPermissions(cp);
            ProtectionDomain domain = new ProtectionDomain(new CodeSource(perms.getCodeBase(), (Certificate[])null), perms);
            AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{domain});
            return acc;
        }
    }

    private static class Factory
    implements URLStreamHandlerFactory {
        private static String PREFIX = "sun.net.www.protocol";

        private Factory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            String name = PREFIX + "." + protocol + ".Handler";
            try {
                Class<?> c = Class.forName(name);
                return (URLStreamHandler)c.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            throw new InternalError("could not load " + protocol + "system protocol handler");
        }
    }
}

