/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.siteplan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SwitchType implements Enumerator
{
    SIMPLE(0, "Simple", "Simple"),
    CROSS_SWITCH(1, "CrossSwitch", "CrossSwitch"),
    DOPPLE_CROSS_SWITCH(2, "DoppleCrossSwitch", "DoppleCrossSwitch"),
    SIMPLE_CROSS(3, "SimpleCross", "SimpleCross"),
    FLAT_CROSS(4, "FlatCross", "FlatCross"),
    OTHER(5, "Other", "Other");

    public static final int SIMPLE_VALUE = 0;
    public static final int CROSS_SWITCH_VALUE = 1;
    public static final int DOPPLE_CROSS_SWITCH_VALUE = 2;
    public static final int SIMPLE_CROSS_VALUE = 3;
    public static final int FLAT_CROSS_VALUE = 4;
    public static final int OTHER_VALUE = 5;
    private static final SwitchType[] VALUES_ARRAY;
    public static final List<SwitchType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SwitchType[]{SIMPLE, CROSS_SWITCH, DOPPLE_CROSS_SWITCH, SIMPLE_CROSS, FLAT_CROSS, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SwitchType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SwitchType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SwitchType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SwitchType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SwitchType get(int value) {
        switch (value) {
            case 0: {
                return SIMPLE;
            }
            case 1: {
                return CROSS_SWITCH;
            }
            case 2: {
                return DOPPLE_CROSS_SWITCH;
            }
            case 3: {
                return SIMPLE_CROSS;
            }
            case 4: {
                return FLAT_CROSS;
            }
            case 5: {
                return OTHER;
            }
        }
        return null;
    }

    private SwitchType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

