/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.fileservice;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.set.core.fileservice.ZippedPlanProToolboxFile;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Dateityp_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.ENUMDateityp;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.zipmanifest.Content;
import org.eclipse.set.model.zipmanifest.ContentList;
import org.eclipse.set.model.zipmanifest.Manifest;
import org.eclipse.set.model.zipmanifest.Media;
import org.eclipse.set.model.zipmanifest.MediaList;
import org.eclipse.set.model.zipmanifest.ZipmanifestFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ManifestTransformation {
    private final HashMap<ArrayList<?>, Manifest> _createCache_toManifest = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, ContentList> _createCache_toContentList = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, MediaList> _createCache_toMediaList = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Content> _createCache_toContent = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Media> _createCache_toMedia = CollectionLiterals.newHashMap();

    public Manifest transform(ZippedPlanProToolboxFile toolboxFile) {
        Manifest manifest = this.toManifest(toolboxFile);
        this.toResource(toolboxFile).getContents().add((Object)manifest);
        return manifest;
    }

    private Resource toResource(ZippedPlanProToolboxFile toolboxFile) {
        Resource _createResource = toolboxFile.getEditingDomain().getResourceSet().createResource(toolboxFile.getManifestUri());
        XMLResource resource = (XMLResource)_createResource;
        resource.setEncoding(StandardCharsets.UTF_8.name());
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest toManifest(ZippedPlanProToolboxFile toolboxFile) {
        Manifest _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ZippedPlanProToolboxFile[]{toolboxFile});
        HashMap<ArrayList<?>, Manifest> hashMap = this._createCache_toManifest;
        synchronized (hashMap) {
            Manifest _createManifest;
            if (this._createCache_toManifest.containsKey(_cacheKey)) {
                return this._createCache_toManifest.get(_cacheKey);
            }
            _result = _createManifest = ZipmanifestFactory.eINSTANCE.createManifest();
            this._createCache_toManifest.put(_cacheKey, _result);
        }
        this._init_toManifest(_result, toolboxFile);
        return _result;
    }

    private void _init_toManifest(Manifest it, ZippedPlanProToolboxFile toolboxFile) {
        it.setContentList(this.toContentList(toolboxFile));
        it.setMediaList(this.toMediaList(toolboxFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentList toContentList(ZippedPlanProToolboxFile toolboxFile) {
        ContentList _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ZippedPlanProToolboxFile[]{toolboxFile});
        HashMap<ArrayList<?>, ContentList> hashMap = this._createCache_toContentList;
        synchronized (hashMap) {
            ContentList _createContentList;
            if (this._createCache_toContentList.containsKey(_cacheKey)) {
                return this._createCache_toContentList.get(_cacheKey);
            }
            _result = _createContentList = ZipmanifestFactory.eINSTANCE.createContentList();
            this._createCache_toContentList.put(_cacheKey, _result);
        }
        this._init_toContentList(_result, toolboxFile);
        return _result;
    }

    private void _init_toContentList(ContentList it, ZippedPlanProToolboxFile toolboxFile) {
        it.getContent().add((Object)this.toContent(toolboxFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaList toMediaList(ZippedPlanProToolboxFile toolboxFile) {
        MediaList _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ZippedPlanProToolboxFile[]{toolboxFile});
        HashMap<ArrayList<?>, MediaList> hashMap = this._createCache_toMediaList;
        synchronized (hashMap) {
            MediaList _createMediaList;
            if (this._createCache_toMediaList.containsKey(_cacheKey)) {
                return this._createCache_toMediaList.get(_cacheKey);
            }
            _result = _createMediaList = ZipmanifestFactory.eINSTANCE.createMediaList();
            this._createCache_toMediaList.put(_cacheKey, _result);
        }
        this._init_toMediaList(_result, toolboxFile);
        return _result;
    }

    private void _init_toMediaList(MediaList it, ZippedPlanProToolboxFile toolboxFile) {
        MediaList mediaList = it;
        List attachments = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)toolboxFile.getPlanProResource().getAllContents(), Anhang.class));
        Functions.Function1 _function = it_1 -> {
            Identitaet_TypeClass _identitaet = it_1.getIdentitaet();
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            return _wert;
        };
        Set attachmentGuids = IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)attachments, (Functions.Function1)_function)));
        LinkedList uniqueAttachments = Lists.newLinkedList();
        for (Anhang a : attachments) {
            boolean _contains;
            Identitaet_TypeClass _identitaet = a.getIdentitaet();
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            if (!(_contains = attachmentGuids.contains(_wert))) continue;
            Identitaet_TypeClass _identitaet_1 = a.getIdentitaet();
            String _wert_1 = null;
            if (_identitaet_1 != null) {
                _wert_1 = _identitaet_1.getWert();
            }
            attachmentGuids.remove(_wert_1);
            uniqueAttachments.add(a);
        }
        Consumer<Anhang> _function_1 = it_1 -> mediaList.getMedia().add((Object)this.toMedia((Anhang)it_1));
        uniqueAttachments.forEach(_function_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content toContent(ZippedPlanProToolboxFile toolboxFile) {
        Content _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ZippedPlanProToolboxFile[]{toolboxFile});
        HashMap<ArrayList<?>, Content> hashMap = this._createCache_toContent;
        synchronized (hashMap) {
            Content _createContent;
            if (this._createCache_toContent.containsKey(_cacheKey)) {
                return this._createCache_toContent.get(_cacheKey);
            }
            _result = _createContent = ZipmanifestFactory.eINSTANCE.createContent();
            this._createCache_toContent.put(_cacheKey, _result);
        }
        this._init_toContent(_result, toolboxFile);
        return _result;
    }

    private void _init_toContent(Content it, ZippedPlanProToolboxFile toolboxFile) {
        it.setName(toolboxFile.getModelPath().getFileName().toString());
        it.setType("text/xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Media toMedia(Anhang attachment) {
        Media _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Anhang[]{attachment});
        HashMap<ArrayList<?>, Media> hashMap = this._createCache_toMedia;
        synchronized (hashMap) {
            Media _createMedia;
            if (this._createCache_toMedia.containsKey(_cacheKey)) {
                return this._createCache_toMedia.get(_cacheKey);
            }
            _result = _createMedia = ZipmanifestFactory.eINSTANCE.createMedia();
            this._createCache_toMedia.put(_cacheKey, _result);
        }
        this._init_toMedia(_result, attachment);
        return _result;
    }

    private void _init_toMedia(Media it, Anhang attachment) {
        Identitaet_TypeClass _identitaet = null;
        if (attachment != null) {
            _identitaet = attachment.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        it.setGuid(_wert);
        Anhang_Allg_AttributeGroup _anhangAllg = null;
        if (attachment != null) {
            _anhangAllg = attachment.getAnhangAllg();
        }
        Dateityp_TypeClass _dateityp = null;
        if (_anhangAllg != null) {
            _dateityp = _anhangAllg.getDateityp();
        }
        ENUMDateityp _wert_1 = null;
        if (_dateityp != null) {
            _wert_1 = _dateityp.getWert();
        }
        String _type = null;
        if (_wert_1 != null) {
            _type = this.toType(_wert_1);
        }
        it.setType(_type);
    }

    private String toType(ENUMDateityp type) {
        if (type != null) {
            switch (type) {
                case ENUM_DATEITYP_JPG: {
                    return "image/jpeg";
                }
                case ENUM_DATEITYP_MPEG: {
                    return "image/mpeg";
                }
                case ENUM_DATEITYP_PDF: {
                    return "application/pdf";
                }
                case ENUM_DATEITYP_PNG: {
                    return "image/png";
                }
                case ENUM_DATEITYP_TIF: {
                    return "image/tiff";
                }
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Unexpected attachment type: ");
            String _string = type.toString();
            _builder.append(_string);
            throw new IllegalArgumentException(_builder.toString());
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Unexpected attachment type: ");
        String _string = type.toString();
        _builder.append(_string);
        throw new IllegalArgumentException(_builder.toString());
    }
}

