/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.attachment;

import com.google.common.collect.Lists;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.set.basis.DomainElementList;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.attachments.AttachmentInfo;
import org.eclipse.set.basis.attachments.FileKind;
import org.eclipse.set.basis.files.AttachmentContentService;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.basis.files.ToolboxFileFilter;
import org.eclipse.set.basis.files.ToolboxFileFilterBuilder;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.configurationservice.UserConfigurationService;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.core.services.viewmodel.ToolboxViewModelService;
import org.eclipse.set.emfforms.utils.DomainModelTypeRendererService;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang;
import org.eclipse.set.model.planpro.Basisobjekte.ENUMAnhangArt;
import org.eclipse.set.model.planpro.Basisobjekte.ENUMDateityp;
import org.eclipse.set.model.planpro.PlanPro.PlanProPackage;
import org.eclipse.set.ppmodel.extensions.AnhangTransformation;
import org.eclipse.set.utils.Messages;
import org.eclipse.set.utils.widgets.AttachmentTable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentListRenderer
extends SimpleControlSWTRenderer {
    private static final List<ENUMAnhangArt> DEFAULT_FILE_KIND_LIST;
    private static final Map<Pair<EStructuralFeature, EStructuralFeature>, List<ENUMAnhangArt>> FILE_KIND_LIST;
    private static final String FILTER_NAME = "AttachmentListRenderer_FilterName";
    private static final Logger LOGGER;
    private static final int TABLE_HEIGHT = 120;
    @Inject
    private UserConfigurationService userConfigService;

    static {
        LOGGER = LoggerFactory.getLogger(AttachmentListRenderer.class);
        DEFAULT_FILE_KIND_LIST = new LinkedList<ENUMAnhangArt>();
        DEFAULT_FILE_KIND_LIST.add(ENUMAnhangArt.ENUM_ANHANG_ART_SONSTIGE);
        AttachmentListRenderer.fillFileKinds(DEFAULT_FILE_KIND_LIST);
        FILE_KIND_LIST = new HashMap<Pair<EStructuralFeature, EStructuralFeature>, List<ENUMAnhangArt>>();
        AttachmentListRenderer.newFileKinds((EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_G_Allg_AttributeGroup_AnhangBAST(), (EStructuralFeature)PlanProPackage.eINSTANCE.getObjektmanagement_AttributeGroup_LSTPlanungProjekt(), Lists.newArrayList((Object[])new ENUMAnhangArt[]{ENUMAnhangArt.ENUM_ANHANG_ART_BAST}));
        AttachmentListRenderer.newFileKinds((EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_Einzel_AnhangErlaeuterungsbericht(), (EStructuralFeature)PlanProPackage.eINSTANCE.getObjektmanagement_AttributeGroup_LSTPlanungProjekt(), Lists.newArrayList((Object[])new ENUMAnhangArt[]{ENUMAnhangArt.ENUM_ANHANG_ART_ERLAEUTERUNGSBERICHT}));
        AttachmentListRenderer.newFileKinds((EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_Einzel_AnhangVzG(), (EStructuralFeature)PlanProPackage.eINSTANCE.getObjektmanagement_AttributeGroup_LSTPlanungProjekt(), Lists.newArrayList((Object[])new ENUMAnhangArt[]{ENUMAnhangArt.ENUM_ANHANG_ART_VZ_G}));
        AttachmentListRenderer.newFileKinds((EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_Einzel_AnhangMaterialBesonders(), (EStructuralFeature)PlanProPackage.eINSTANCE.getObjektmanagement_AttributeGroup_LSTPlanungProjekt(), Lists.newArrayList((Object[])new ENUMAnhangArt[]{ENUMAnhangArt.ENUM_ANHANG_ART_MATERIAL_BESONDERS}));
        AttachmentListRenderer.newFileKinds((EStructuralFeature)PlanProPackage.eINSTANCE.getAkteur_Zuordnung_AnhangDokumentation(), (EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_E_Handlung_AttributeGroup_PlanungEAbnahme(), Lists.newArrayList((Object[])new ENUMAnhangArt[]{ENUMAnhangArt.ENUM_ANHANG_ART_ABNAHMENIEDERSCHRIFT}));
        AttachmentListRenderer.newFileKinds((EStructuralFeature)PlanProPackage.eINSTANCE.getAkteur_Zuordnung_AnhangDokumentation(), (EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_E_Handlung_AttributeGroup_PlanungEErstellung(), Lists.newArrayList((Object[])new ENUMAnhangArt[]{ENUMAnhangArt.ENUM_ANHANG_ART_PLANVERZEICHNIS}));
        AttachmentListRenderer.newFileKinds((EStructuralFeature)PlanProPackage.eINSTANCE.getAkteur_Zuordnung_AnhangDokumentation(), (EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_E_Handlung_AttributeGroup_PlanungEFreigabe(), Lists.newArrayList((Object[])new ENUMAnhangArt[]{ENUMAnhangArt.ENUM_ANHANG_ART_FREIGABE_BVB}));
        AttachmentListRenderer.newFileKinds((EStructuralFeature)PlanProPackage.eINSTANCE.getAkteur_Zuordnung_AnhangDokumentation(), (EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_E_Handlung_AttributeGroup_PlanungEGenehmigung(), Lists.newArrayList((Object[])new ENUMAnhangArt[]{ENUMAnhangArt.ENUM_ANHANG_ART_GENEHMIGUNG_AG_BH_BHV}));
        AttachmentListRenderer.newFileKinds((EStructuralFeature)PlanProPackage.eINSTANCE.getAkteur_Zuordnung_AnhangDokumentation(), (EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_E_Handlung_AttributeGroup_PlanungEGleichstellung(), Lists.newArrayList((Object[])new ENUMAnhangArt[]{ENUMAnhangArt.ENUM_ANHANG_ART_BESTAETIG_GLEICHSTELLUNG}));
        AttachmentListRenderer.newFileKinds((EStructuralFeature)PlanProPackage.eINSTANCE.getAkteur_Zuordnung_AnhangDokumentation(), (EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_E_Handlung_AttributeGroup_PlanungEPruefung(), Lists.newArrayList((Object[])new ENUMAnhangArt[]{ENUMAnhangArt.ENUM_ANHANG_ART_PRUEFBERICHT}));
        AttachmentListRenderer.newFileKinds((EStructuralFeature)PlanProPackage.eINSTANCE.getAkteur_Zuordnung_AnhangDokumentation(), (EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_E_Handlung_AttributeGroup_PlanungEQualitaetspruefung(), Lists.newArrayList((Object[])new ENUMAnhangArt[]{ENUMAnhangArt.ENUM_ANHANG_ART_BESTAETIG_QUALITAETSPRUEFUNG}));
        AttachmentListRenderer.newFileKinds((EStructuralFeature)PlanProPackage.eINSTANCE.getAkteur_Zuordnung_AnhangDokumentation(), (EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_E_Handlung_AttributeGroup_PlanungESonstige(), Lists.newArrayList((Object[])new ENUMAnhangArt[]{ENUMAnhangArt.ENUM_ANHANG_ART_SONSTIGE}));
        AttachmentListRenderer.newFileKinds((EStructuralFeature)PlanProPackage.eINSTANCE.getAkteur_Zuordnung_AnhangDokumentation(), (EStructuralFeature)PlanProPackage.eINSTANCE.getPlanung_E_Handlung_AttributeGroup_PlanungEUebernahme(), Lists.newArrayList((Object[])new ENUMAnhangArt[]{ENUMAnhangArt.ENUM_ANHANG_ART_BESTAETIG_UEBERNAHME}));
    }

    private static void fillFileKinds(List<ENUMAnhangArt> fileKinds) {
        ENUMAnhangArt.VALUES.stream().sorted((a, b) -> a.getLiteral().compareTo(b.getLiteral())).forEach(enumAnhangArt -> {
            if (!fileKinds.contains(enumAnhangArt)) {
                fileKinds.add((ENUMAnhangArt)enumAnhangArt);
            }
        });
    }

    private static List<ENUMAnhangArt> getFileKindList(DomainElementList<Anhang, AttachmentInfo<Anhang>> domainElementList) {
        EStructuralFeature containingFeature;
        EStructuralFeature feature = domainElementList.getFeature();
        Pair key = new Pair((Object)feature, (Object)(containingFeature = domainElementList.getContainingFeature()));
        List<ENUMAnhangArt> result = FILE_KIND_LIST.get(key);
        if (result == null) {
            LOGGER.error("No file kind list for feature=" + feature.getName() + " containingFeature=" + containingFeature.getName());
            return DEFAULT_FILE_KIND_LIST;
        }
        LOGGER.debug("File kinds for feature=" + feature.getName() + " containingFeature=" + containingFeature.getName() + ": " + String.valueOf(result));
        return result;
    }

    private static ToolboxFile getToolboxFile() {
        ToolboxViewModelService toolboxViewModelService = Services.getToolboxViewModelService();
        return ((IModelSession)toolboxViewModelService.getSession().get()).getToolboxFile();
    }

    private static void newFileKinds(EStructuralFeature feature, EStructuralFeature containingFeature, List<ENUMAnhangArt> fileKinds) {
        AttachmentListRenderer.fillFileKinds(fileKinds);
        Pair key = new Pair((Object)feature, (Object)containingFeature);
        FILE_KIND_LIST.put((Pair<EStructuralFeature, EStructuralFeature>)key, fileKinds);
    }

    private static List<FileKind> toFileKinds(List<ENUMAnhangArt> fileKindList, EnumTranslationService translationService) {
        return fileKindList.stream().map(enumAnhangArt -> new FileKind(enumAnhangArt.getValue(), translationService.translate((Enumerator)enumAnhangArt).getAlternative())).collect(Collectors.toList());
    }

    @Inject
    public AttachmentListRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        LOGGER.debug("Render {}", (Object)vElement);
    }

    private List<ToolboxFileFilter> getExtensionFilter() {
        String filterName = LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)FILTER_NAME);
        List extensions = Arrays.stream(ENUMDateityp.values()).map(ENUMDateityp::getLiteral).collect(Collectors.toList());
        return List.of(ToolboxFileFilterBuilder.forName((String)filterName).add(extensions).create());
    }

    protected Control createControl(Composite parent) throws DatabindingFailedException {
        ToolboxViewModelService toolboxViewModelService = Services.getToolboxViewModelService();
        EnumTranslationService translationService = toolboxViewModelService.getTranslationService();
        Messages messages = (Messages)toolboxViewModelService.getMessages(Messages.class);
        String tempDir = toolboxViewModelService.getTempDir().toString();
        DomainElementList domainElementList = DomainModelTypeRendererService.getDomainElementList(Anhang.class, this.getVElement(), this.getViewModelContext());
        DialogService dialogService = (DialogService)toolboxViewModelService.get(DialogService.class);
        Assert.isNotNull((Object)dialogService);
        AttachmentContentService contentService = (AttachmentContentService)toolboxViewModelService.get(AttachmentContentService.class);
        Assert.isNotNull((Object)contentService);
        AttachmentTable attachmentTable = new AttachmentTable(parent, messages, contentService, dialogService, AttachmentListRenderer.getToolboxFile(), this.userConfigService);
        AnhangTransformation transformation = AnhangTransformation.createTransformation((EnumTranslationService)translationService, (AttachmentContentService)contentService);
        attachmentTable.setModel(transformation.toAttachment(domainElementList), AttachmentListRenderer.toFileKinds(AttachmentListRenderer.getFileKindList(domainElementList), translationService));
        attachmentTable.setModel(transformation.toAttachment(domainElementList.getElements()));
        attachmentTable.setTempDir(tempDir);
        ToolboxPartService partService = (ToolboxPartService)toolboxViewModelService.get(ToolboxPartService.class);
        attachmentTable.setAttachmentViewer(arg_0 -> ((ToolboxPartService)partService).showAttachmentPart(arg_0));
        attachmentTable.setExtensionFilter(this.getExtensionFilter());
        return attachmentTable.createControl();
    }

    protected SWTGridCell createControlCell(int column) {
        SWTGridCell controlCell = super.createControlCell(column);
        controlCell.setVerticalFill(true);
        controlCell.setPreferredSize(-1, 120);
        return controlCell;
    }

    protected String getUnsetText() {
        return null;
    }
}

