/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceSerializer
extends JsonSerializer<Resource> {
    public void serialize(Resource value, JsonGenerator jg, SerializerProvider provider) throws IOException {
        if (value.getContents().size() == 1) {
            this.serializeOne((EObject)value.getContents().get(0), jg, provider);
        } else {
            jg.writeStartArray();
            for (EObject o : value.getContents()) {
                this.serializeOne(o, jg, provider);
            }
            jg.writeEndArray();
        }
    }

    private void serializeOne(EObject object, JsonGenerator jg, SerializerProvider provider) throws IOException {
        JavaType type = provider.constructType(object.getClass());
        JsonSerializer serializer = provider.findValueSerializer(type);
        if (serializer != null) {
            serializer.serialize((Object)object, jg, provider);
        }
    }

    public Class<Resource> handledType() {
        return Resource.class;
    }
}

