/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.projectdata.autofill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.set.basis.autofill.ConfirmationTrigger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

class PlanProTrigger
extends ConfirmationTrigger
implements Consumer<Text> {
    private boolean enabled = true;
    private final boolean ignoreFocus;

    public PlanProTrigger(BooleanSupplier confirmation, boolean ignoreFocus) {
        super(confirmation);
        this.ignoreFocus = ignoreFocus;
    }

    @Override
    public void accept(final Text text) {
        if (this.ignoreFocus) {
            return;
        }
        final FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PlanProTrigger.this.activate();
            }
        };
        text.addFocusListener((FocusListener)focusAdapter);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                text.removeFocusListener((FocusListener)focusAdapter);
            }
        });
    }

    public void activate() {
        if (this.enabled) {
            super.activate();
        }
    }

    public void addAdapter(Control parent, final EObject object, final EStructuralFeature attributeFeature, final EStructuralFeature wertFeature) {
        EContentAdapter adapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                Object notifiedFeature = notification.getFeature();
                ArrayList features = Lists.newArrayList((Object[])new EStructuralFeature[]{attributeFeature, wertFeature});
                if (features.contains(notifiedFeature)) {
                    PlanProTrigger.this.activate();
                }
            }
        };
        object.eAdapters().add((Object)adapter);
        parent.addDisposeListener(new DisposeListener((Adapter)adapter){
            private final /* synthetic */ Adapter val$adapter;
            {
                this.val$adapter = adapter;
            }

            public void widgetDisposed(DisposeEvent e) {
                object.eAdapters().remove((Object)this.val$adapter);
            }
        });
    }

    public void setEnable(boolean value) {
        this.enabled = value;
    }
}

