/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.eclipse.set.utils.math.AgateRounding;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class BigDecimalExtensions {
    public static String toTableDecimal(BigDecimal length) {
        if (length == null) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(0);
        return decimalFormat.format(length);
    }

    public static String toTableDecimal(BigDecimal length, int decimalPlace) {
        if (length != null) {
            BigDecimal decimal = length.setScale(decimalPlace, RoundingMode.FLOOR);
            return decimal.toPlainString();
        }
        return null;
    }

    public static String toTableInteger(BigDecimal length, int multiplier) {
        if (length != null) {
            BigDecimal _valueOf = BigDecimal.valueOf(multiplier);
            BigDecimal _multiply = length.multiply(_valueOf);
            return String.format("%.0f", _multiply);
        }
        return null;
    }

    public static String toTableInteger(BigDecimal length) {
        if (length != null) {
            return BigDecimalExtensions.toTableInteger(length, 1);
        }
        return null;
    }

    public static <T extends Number> BigDecimal toBigDecimal(T value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        try {
            return BigDecimal.valueOf(value.doubleValue());
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                throw new RuntimeException(e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static String toTableIntegerAgateUp(BigDecimal length) {
        if (length != null) {
            return Long.toString(AgateRounding.roundUp(length.doubleValue()));
        }
        return null;
    }

    public static String toTableIntegerAgateDown(BigDecimal length) {
        if (length != null) {
            return Long.toString(AgateRounding.roundDown(length.doubleValue()));
        }
        return null;
    }

    public static <T extends Number> BigDecimal multiplyValue(BigDecimal value, T multiplyValue) {
        if (value != null) {
            return value.multiply(BigDecimalExtensions.toBigDecimal(multiplyValue));
        }
        return null;
    }

    public static <T extends Number> BigDecimal divideValue(BigDecimal value, T divideValue) {
        if (value != null) {
            return value.divide(BigDecimalExtensions.toBigDecimal(divideValue), RoundingMode.DOWN);
        }
        return null;
    }

    public static double toDouble(BigDecimal value) {
        if (value == null) {
            return 0.0;
        }
        return value.doubleValue();
    }
}

