/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.ModifiableContainer;
import org.eclipse.net4j.util.io.IORuntimeException;

public abstract class PersistableContainer<E>
extends ModifiableContainer<E>
implements IContainer.Persistable<E> {
    private IContainer.Persistence<E> persistence;

    public PersistableContainer(Class<E> componentType) {
        super(componentType);
    }

    @Override
    public IContainer.Persistence<E> getPersistence() {
        return this.persistence;
    }

    @Override
    public void setPersistence(IContainer.Persistence<E> persistence) {
        this.persistence = persistence;
    }

    public boolean isSavedWhenModified() {
        return true;
    }

    @Override
    public synchronized void load() throws IORuntimeException {
        if (this.persistence != null) {
            Collection<E> elements = this.persistence.loadElements();
            this.clear();
            this.addAllElements(elements);
        }
    }

    @Override
    public synchronized void save() throws IORuntimeException {
        if (this.persistence != null) {
            List elements = Arrays.asList(this.getElements());
            this.persistence.saveElements(elements);
        }
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        this.load();
    }

    @Override
    protected void doDeactivate() throws Exception {
        if (!this.isSavedWhenModified()) {
            this.save();
        }
        super.doDeactivate();
    }

    @Override
    protected void containerModified() {
        if (this.isSavedWhenModified()) {
            this.save();
        }
    }
}

