/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1.sskz;

import com.google.common.collect.Streams;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.graph.BankService;
import org.eclipse.set.feature.table.pt1.AbstractPlanPro2TableModelTransformator;
import org.eclipse.set.feature.table.pt1.ssks.SignalSideDistance;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Aussenelementansteuerung;
import org.eclipse.set.model.planpro.Ansteuerung_Element.ENUMAussenelementansteuerungArt;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stellelement;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Tueranschlag_TypeClass;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Unterbringung_Befestigung_TypeClass;
import org.eclipse.set.model.planpro.BasisTypen.BasisAttribut_AttributeGroup;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.planpro.Ortung.FMA_Komponente;
import org.eclipse.set.model.planpro.PZB.PZB_Art_TypeClass;
import org.eclipse.set.model.planpro.PZB.PZB_Element;
import org.eclipse.set.model.planpro.Schluesselabhaengigkeiten.Schluesselsperre;
import org.eclipse.set.model.planpro.Signale.Signal;
import org.eclipse.set.model.planpro.Verweise.ID_Aussenelementansteuerung_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.ppmodel.extensions.PZBElementExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.UrObjectExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.geometry.GEOKanteGeometryExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Case;
import org.eclipse.set.utils.math.BigDecimalExtensions;
import org.eclipse.set.utils.table.TMFactory;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.event.EventAdmin;

public class SskzTransformator
extends AbstractPlanPro2TableModelTransformator {
    private final BankService bankService;
    private final String tableShortcut;
    private static final LinkedHashMap<Class<? extends Ur_Objekt>, Function<MultiContainer_AttributeGroup, Iterable<? extends Ur_Objekt>>> fieldElementClasses = new LinkedHashMap();

    static {
        fieldElementClasses.put(W_Kr_Gsp_Element.class, MultiContainer_AttributeGroup::getWKrGspElement);
        fieldElementClasses.put(Signal.class, MultiContainer_AttributeGroup::getSignal);
        fieldElementClasses.put(FMA_Komponente.class, MultiContainer_AttributeGroup::getFMAKomponente);
        fieldElementClasses.put(PZB_Element.class, MultiContainer_AttributeGroup::getPZBElement);
        fieldElementClasses.put(Schluesselsperre.class, MultiContainer_AttributeGroup::getSchluesselsperre);
    }

    public SskzTransformator(Set<ColumnDescriptor> cols, BankService bankService, EnumTranslationService enumTranslationService, EventAdmin eventAdmin, String tableShortcut) {
        super(cols, enumTranslationService, eventAdmin);
        this.bankService = bankService;
        this.tableShortcut = tableShortcut;
    }

    public Table transformTableContent(MultiContainer_AttributeGroup container, TMFactory factory, Stell_Bereich controlArea) {
        List<Aussenelementansteuerung> outsideControls = Streams.stream((Iterable)container.getAussenelementansteuerung()).filter(UrObjectExtensions::isPlanningObject).toList();
        Iterable relevantControlsInArea = UrObjectExtensions.filterObjectsInControlArea(outsideControls, (Stell_Bereich)controlArea);
        return this.transform(relevantControlsInArea, factory);
    }

    private Table transform(Iterable<Aussenelementansteuerung> controls, TMFactory factory) {
        for (Aussenelementansteuerung control : controls) {
            Thread.currentThread();
            if (Thread.interrupted()) {
                return null;
            }
            ENUMAussenelementansteuerungArt controlType = EObjectExtensions.getNullableObject((Object)control, ele -> ele.getAEAAllg().getAussenelementansteuerungArt().getWert()).orElse(null);
            if (controlType != ENUMAussenelementansteuerungArt.ENUM_AUSSENELEMENTANSTEUERUNG_ART_FE_AK && controlType != ENUMAussenelementansteuerungArt.ENUM_AUSSENELEMENTANSTEUERUNG_ART_FE_AS) continue;
            TableRow row = factory.newTableRow((Ur_Objekt)control);
            this.fill(row, this.getColumn(this.cols, "A"), control, ele -> ele.getBezeichnung().getBezeichnungAEA().getWert());
            this.fillIterable(row, this.getColumn(this.cols, "B"), control, this::getFieldElementIdentifier, OperationalIdentifierFieldElement::compare, t -> String.join((CharSequence)ITERABLE_FILLING_SEPARATOR, t.elementIdentifierts()));
            this.fill(row, this.getColumn(this.cols, "C"), control, e -> "");
            this.fill(row, this.getColumn(this.cols, "D"), control, element -> {
                Tueranschlag_TypeClass enumTueranschlag = EObjectExtensions.getNullableObject((Object)element, e -> e.getIDUnterbringung().getValue().getUnterbringungAllg().getTueranschlag()).orElse(null);
                return this.translate((BasisAttribut_AttributeGroup)enumTueranschlag);
            });
            this.fill(row, this.getColumn(this.cols, "E"), control, element -> {
                Unterbringung_Befestigung_TypeClass befestigung = EObjectExtensions.getNullableObject((Object)element, e -> e.getIDUnterbringung().getValue().getUnterbringungAllg().getUnterbringungBefestigung()).orElse(null);
                return this.translate((BasisAttribut_AttributeGroup)befestigung);
            });
            if (EObjectExtensions.getNullableObject((Object)control, e -> e.getIDUnterbringung().getValue().getPunktObjektTOPKante()).isPresent()) {
                Punkt_Objekt_TOP_Kante_AttributeGroup potk = control.getIDUnterbringung().getValue().getPunktObjektTOPKante();
                this.fillIterableSingleCellWhenAllowed(row, this.getColumn(this.cols, "F"), control, (Functions.Function0<? extends Boolean>)((Functions.Function0)() -> this.bankService.isFindBankingComplete()), ele -> this.bankService.findBankValue(new TopPoint(potk)).stream().filter(Objects::nonNull).map(value -> value.multiply(BigDecimal.valueOf(1000L))).map(BigDecimalExtensions::toTableInteger).toList(), MIXED_STRING_COMPARATOR, ITERABLE_FILLING_SEPARATOR, this.tableShortcut);
                if (EObjectExtensions.getNullableObject((Object)potk, p -> p.getSeitlicherAbstand().getWert()).isPresent()) {
                    this.fillTrackMitteDistance(row, control, potk);
                }
            }
            this.fill(row, this.getColumn(this.cols, "H"), control, element -> "");
            this.fillFootnotes(row, (Basis_Objekt)control);
        }
        return factory.getTable();
    }

    private void fillTrackMitteDistance(TableRow row, Aussenelementansteuerung control, Punkt_Objekt_TOP_Kante_AttributeGroup potk) {
        this.fillIterableMultiCellWhenAllowed(row, this.getColumn(this.cols, "G"), control, (Functions.Function0<? extends Boolean>)((Functions.Function0)() -> GEOKanteGeometryExtensions.isFindGeometryComplete()), ele -> {
            Pair<Long, Long> sideDistance = SskzTransformator.getSideDistance(potk);
            if (sideDistance != null) {
                String trackDistance;
                String string = trackDistance = (Long)sideDistance.getSecond() > 0L ? String.format("(%d)", sideDistance.getSecond()) : "";
                if (!trackDistance.isEmpty()) {
                    this.addTopologicalCell(row, this.getColumn(this.cols, "G"));
                }
                return String.format("%s%s", Math.abs((Long)sideDistance.getFirst()), trackDistance.isEmpty() ? "" : " " + trackDistance);
            }
            return "";
        });
    }

    private List<OperationalIdentifierFieldElement> getFieldElementIdentifier(Aussenelementansteuerung control) {
        LinkedHashMap<Class, Case> fillCases = new LinkedHashMap<Class, Case>();
        fieldElementClasses.forEach((clazz, elements) -> {
            Case<Aussenelementansteuerung> case_ = fillCases.put((Class)clazz, (Case)this.fieldElementCase((Class)clazz));
        });
        LinkedList<OperationalIdentifierFieldElement> result = new LinkedList<OperationalIdentifierFieldElement>();
        ((HashMap)fillCases).forEach((clazz, fillCase) -> {
            if (((Boolean)fillCase.condition.apply((Object)control)).booleanValue()) {
                Iterable fillValuesIterable = (Iterable)fillCase.filling.apply((Object)control);
                List sortList = IterableExtensions.sortWith((Iterable)fillValuesIterable, (Comparator)fillCase.comparator);
                result.add(new OperationalIdentifierFieldElement((Class<? extends Ur_Objekt>)clazz, sortList));
            }
        });
        return result;
    }

    private <T extends Ur_Objekt> Case<Aussenelementansteuerung> fieldElementCase(Class<T> clazz) {
        Function<Aussenelementansteuerung, List> getRelevantElementFunc = control -> this.getRelevantFieldElements(clazz, (Aussenelementansteuerung)control);
        return new Case(control -> !((List)getRelevantElementFunc.apply((Aussenelementansteuerung)control)).isEmpty(), control -> ((List)getRelevantElementFunc.apply((Aussenelementansteuerung)control)).stream().map(this::getFieldElementDesignation).toList(), ITERABLE_FILLING_SEPARATOR, MIXED_STRING_COMPARATOR);
    }

    private List<Aussenelementansteuerung> getControlFromFieldELement(Ur_Objekt object) {
        Function<Ur_Objekt, List> getAussElement = urObject -> {
            Ur_Objekt ur_Objekt = urObject;
            Objects.requireNonNull(ur_Objekt);
            Ur_Objekt ur_Objekt2 = ur_Objekt;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{W_Kr_Gsp_Element.class, Signal.class, FMA_Komponente.class, PZB_Element.class, Schluesselsperre.class, Stellelement.class}, (Object)ur_Objekt2, 0)) {
                case 0 -> {
                    W_Kr_Gsp_Element gsp = (W_Kr_Gsp_Element)ur_Objekt2;
                    yield this.getControlFromFieldELement((Ur_Objekt)gsp.getIDStellelement().getValue());
                }
                case 1 -> {
                    Signal signal = (Signal)ur_Objekt2;
                    yield this.getControlFromFieldELement((Ur_Objekt)signal.getSignalReal().getSignalRealAktiv().getIDStellelement().getValue());
                }
                case 2 -> {
                    FMA_Komponente fma = (FMA_Komponente)ur_Objekt2;
                    yield fma.getFMAKomponenteAchszaehlpunkt().getIDInformation().stream().map(ID_Aussenelementansteuerung_TypeClass::getValue).toList();
                }
                case 3 -> {
                    PZB_Element pzb = (PZB_Element)ur_Objekt2;
                    yield this.getControlFromFieldELement((Ur_Objekt)pzb.getIDStellelement().getValue());
                }
                case 4 -> {
                    Schluesselsperre schluessel = (Schluesselsperre)ur_Objekt2;
                    yield this.getControlFromFieldELement((Ur_Objekt)schluessel.getIDStellelement().getValue());
                }
                case 5 -> {
                    Stellelement stellement = (Stellelement)ur_Objekt2;
                    yield List.of(stellement.getIDInformation().getValue());
                }
                default -> null;
            };
        };
        return EObjectExtensions.getNullableObject((Object)object, getAussElement::apply).orElse(Collections.emptyList());
    }

    private String getFieldElementDesignation(Ur_Objekt object) {
        Function<Ur_Objekt, String> destignationFunc = urObject -> {
            Ur_Objekt ur_Objekt = urObject;
            Objects.requireNonNull(ur_Objekt);
            Ur_Objekt ur_Objekt2 = ur_Objekt;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{W_Kr_Gsp_Element.class, Signal.class, FMA_Komponente.class, PZB_Element.class, Schluesselsperre.class}, (Object)ur_Objekt2, 0)) {
                case 0 -> {
                    W_Kr_Gsp_Element gsp = (W_Kr_Gsp_Element)ur_Objekt2;
                    yield gsp.getBezeichnung().getBezeichnungTabelle().getWert();
                }
                case 1 -> {
                    Signal signal = (Signal)ur_Objekt2;
                    yield signal.getBezeichnung().getBezeichnungTabelle().getWert();
                }
                case 2 -> {
                    FMA_Komponente fma = (FMA_Komponente)ur_Objekt2;
                    yield fma.getBezeichnung().getBezeichnungTabelle().getWert();
                }
                case 3 -> {
                    PZB_Element pzb = (PZB_Element)ur_Objekt2;
                    yield this.getPzbDesignation(pzb);
                }
                case 4 -> {
                    Schluesselsperre schluessel = (Schluesselsperre)ur_Objekt2;
                    yield schluessel.getBezeichnung().getBezeichnungTabelle().getWert();
                }
                default -> null;
            };
        };
        return EObjectExtensions.getNullableObject((Object)object, destignationFunc::apply).orElse("");
    }

    private String getPzbDesignation(PZB_Element pzb) {
        BigInteger speedCheck;
        PZB_Art_TypeClass pzbArt = EObjectExtensions.getNullableObject((Object)pzb, ele -> ele.getPZBArt()).orElse(null);
        if (pzbArt == null) {
            return "";
        }
        List<String> pzbElementBezugspunkt = PZBElementExtensions.getPZBElementBezugspunkt((PZB_Element)pzb).stream().map(ele -> {
            Basis_Objekt basis_Objekt = ele;
            Objects.requireNonNull(basis_Objekt);
            Basis_Objekt basis_Objekt2 = basis_Objekt;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Signal.class, W_Kr_Gsp_Element.class}, (Object)basis_Objekt2, 0)) {
                case 0 -> {
                    Signal signal = (Signal)basis_Objekt2;
                    yield signal.getBezeichnung().getBezeichnungTabelle().getWert();
                }
                case 1 -> {
                    W_Kr_Gsp_Element gsp = (W_Kr_Gsp_Element)basis_Objekt2;
                    yield gsp.getBezeichnung().getBezeichnungTabelle().getWert();
                }
                default -> "";
            };
        }).toList();
        if (pzb.getPZBElementGM() != null) {
            return String.format("%s (%s)", this.translate((BasisAttribut_AttributeGroup)pzbArt), String.join((CharSequence)",", pzbElementBezugspunkt));
        }
        if (pzb.getPZBElementGUE() != null && (speedCheck = (BigInteger)EObjectExtensions.getNullableObject((Object)pzb.getPZBElementGUE(), gue -> gue.getPruefgeschwindigkeit().getWert()).orElse(null)) != null) {
            String[] pzbArtEnum = this.translate((BasisAttribut_AttributeGroup)pzbArt).split("/");
            List<String> shortPzbArt = Stream.of(pzbArtEnum).map(ele -> {
                try {
                    double hz = Double.parseDouble(ele);
                    double shortHz = hz / 1000.0;
                    if (shortHz == (double)((int)shortHz)) {
                        return Integer.toString((int)shortHz);
                    }
                    return Double.toString(shortHz);
                }
                catch (NumberFormatException e) {
                    return ele;
                }
            }).toList();
            return String.format("%s/G\u00dc %s (%s)", String.join((CharSequence)"/", shortPzbArt), speedCheck, String.join((CharSequence)",", pzbElementBezugspunkt));
        }
        return "";
    }

    private <T extends Ur_Objekt> List<T> getRelevantFieldElements(Class<T> clazz, Aussenelementansteuerung control) {
        Function getElementFunc = fieldElementClasses.getOrDefault(clazz, null);
        if (getElementFunc == null) {
            throw new IllegalArgumentException("Unexpect Class: " + String.valueOf(clazz));
        }
        MultiContainer_AttributeGroup container = BasisAttributExtensions.getContainer((EObject)control);
        List<Ur_Objekt> elements = Streams.stream((Iterable)((Iterable)getElementFunc.apply(container))).map(clazz::cast).toList();
        return elements.parallelStream().filter(ele -> this.getControlFromFieldELement((Ur_Objekt)ele).contains(control)).toList();
    }

    private static Pair<Long, Long> getSideDistance(Punkt_Objekt_TOP_Kante_AttributeGroup potk) {
        double rotation = PunktObjektTopKanteExtensions.getCoordinate((Punkt_Objekt_TOP_Kante_AttributeGroup)potk).getEffectiveRotation();
        ENUMWirkrichtung direction = EObjectExtensions.getNullableObject((Object)potk, p -> p.getWirkrichtung().getWert()).orElse(null);
        if (direction == null || direction == ENUMWirkrichtung.ENUM_WIRKRICHTUNG_BEIDE) {
            return Optional.ofNullable(SignalSideDistance.getSideDistance(potk, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN, rotation)).orElse(SignalSideDistance.getSideDistance(potk, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_GEGEN, rotation));
        }
        return SignalSideDistance.getSideDistance(potk, potk.getWirkrichtung().getWert(), rotation);
    }

    private record OperationalIdentifierFieldElement(Class<? extends Ur_Objekt> clazz, List<String> elementIdentifierts) {
        public static int compare(OperationalIdentifierFieldElement first, OperationalIdentifierFieldElement second) {
            ArrayList<Class<? extends Ur_Objekt>> clazzList = new ArrayList<Class<? extends Ur_Objekt>>(fieldElementClasses.keySet());
            int firstIndex = clazzList.indexOf(first.clazz());
            int secondIndex = clazzList.indexOf(second.clazz());
            return Integer.compare(firstIndex, secondIndex);
        }
    }
}

