/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.common;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractSpinnerPropertySection
extends AbstractViewpointPropertySection {
    protected Spinner spinner;
    String lastChange = "";
    protected CLabel nameLabel;
    protected int minimumValue = 0;
    protected int maximumValue = Integer.MAX_VALUE;
    protected Composite composite;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        if (tabbedPropertySheetPage instanceof ViewpointPropertySheetPage) {
            super.createControls(parent, (ViewpointPropertySheetPage)tabbedPropertySheetPage);
        } else {
            super.createControls(parent, tabbedPropertySheetPage);
        }
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.spinner = new Spinner(this.composite, 2048);
        this.spinner.setMinimum(this.getMinimumValue());
        this.spinner.setMaximum(this.getMaximumValue());
        this.spinner.setPageIncrement(100);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 232);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.spinner.setLayoutData((Object)data);
        this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, this.getLabelText());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.spinner, -25);
        data.top = new FormAttachment((Control)this.spinner, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        this.spinner.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                AbstractSpinnerPropertySection.this.lastChange = "Key";
                if (e.keyCode == 13 || e.keyCode == 128 || e.keyCode == 1024) {
                    AbstractSpinnerPropertySection.this.handleValueModified();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if ("Mouse".equals(AbstractSpinnerPropertySection.this.lastChange)) {
                    AbstractSpinnerPropertySection.this.handleValueModified();
                }
            }
        });
        this.spinner.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                AbstractSpinnerPropertySection.this.handleValueModified();
            }
        });
        this.spinner.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                AbstractSpinnerPropertySection.this.lastChange = "Mouse";
            }
        });
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.sirius." + this.eObject.eClass().getName());
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.nameLabel.setText(this.getLabelText());
    }

    protected void handleValueModified() {
        int newInt = this.spinner.getSelection();
        boolean equals = this.isEqual(String.valueOf(newInt));
        if (!equals) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
            Object value = this.getFeatureValue(String.valueOf(newInt));
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        int value = Integer.parseInt(this.getFeatureAsText());
        this.spinner.setSelection(value);
    }

    public void setMinimumValue(int newValue) {
        this.minimumValue = newValue;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public void setMaximumValue(int newValue) {
        this.maximumValue = newValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    protected abstract boolean isEqual(String var1);

    protected abstract EAttribute getFeature();

    protected String getDefaultFeatureAsText() {
        String value = new String();
        if (this.eObject.eGet((EStructuralFeature)this.getFeature()) != null) {
            value = this.eObject.eGet((EStructuralFeature)this.getFeature()).toString();
        }
        return value;
    }

    protected String getFeatureAsText() {
        EAttribute eFeature = this.getFeature();
        IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor((EStructuralFeature)eFeature);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getLabelProvider((Object)this.eObject).getText(this.eObject.eGet((EStructuralFeature)eFeature));
        }
        return this.getDefaultFeatureAsText();
    }

    protected abstract Object getFeatureValue(String var1);

    protected abstract String getDefaultLabelText();

    protected String getLabelText() {
        EAttribute eFeature;
        IItemPropertyDescriptor propertyDescriptor;
        if (this.eObject != null && (propertyDescriptor = this.getPropertyDescriptor((EStructuralFeature)(eFeature = this.getFeature()))) != null) {
            return propertyDescriptor.getDisplayName((Object)this.eObject);
        }
        return this.getDefaultLabelText();
    }

    @Override
    protected void makeReadonly() {
        this.spinner.setEnabled(false);
    }

    @Override
    protected void makeWrittable() {
        this.spinner.setEnabled(true);
    }
}

