/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.config.actions;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigManager;
import org.eclipse.statet.ecommons.debug.ui.config.actions.ActionUtil;
import org.eclipse.statet.ecommons.ui.actions.ListContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.IdentityCollection;
import org.eclipse.statet.jcommons.collections.IdentitySet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class RunConfigsDropdownContribution<TElement>
extends ListContributionItem
implements IWorkbenchContribution,
IExecutableExtension {
    private final ActionUtil<TElement> util;
    private @Nullable IServiceLocator serviceLocator;
    private ImIdentitySet<String> launchFlags;
    private final StringBuilder sBuilder = new StringBuilder(32);

    public RunConfigsDropdownContribution(IContentType contentType, ActionUtil<TElement> util, IdentityCollection<String> launchFlags) {
        this.util = util;
        this.launchFlags = ImCollections.toIdentitySet(launchFlags);
    }

    public RunConfigsDropdownContribution(ActionUtil<TElement> util) {
        this.util = util;
    }

    protected ActionUtil<TElement> getUtil() {
        return this.util;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, @Nullable Object data) throws CoreException {
        if (data instanceof Map) {
            try {
                this.configure((Map)data);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.ui", 0, NLS.bind((String)"Invalid declaration of contribution by ''{0}''.", (Object)config.getContributor().getName()), (Throwable)e));
            }
        }
    }

    protected void configure(Map<String, @Nullable String> parameters) {
        String s = parameters.get("launchFlags");
        this.launchFlags = s != null ? CollectionUtils.toIdentifierSet((String[])s.split(";")) : ImCollections.newIdentitySet();
    }

    protected ImIdentitySet<String> getLaunchFlags() {
        return this.launchFlags;
    }

    private StringBuilder getStringBuilder() {
        this.sBuilder.setLength(0);
        return this.sBuilder;
    }

    protected void createContributionItems(List<IContributionItem> items) {
        IWorkbenchWindow window = ActionUtil.getWindow(this.serviceLocator);
        @Nullable TElement element = this.util.getLaunchElement(window);
        if (element == null) {
            return;
        }
        LaunchConfigManager<TElement> manager = this.util.getManager(window, element);
        if (manager == null) {
            return;
        }
        ImList<ILaunchConfiguration> configs = manager.getAvailableConfigs();
        Data data = new Data(manager, element);
        int i = 0;
        int num = 1;
        while (i < configs.size()) {
            ILaunchConfiguration configuration = (ILaunchConfiguration)configs.get(i);
            StringBuilder label = this.getStringBuilder();
            String mnemonic = null;
            if (num > 0 && num <= 10) {
                mnemonic = Integer.toString(num % 10);
                label.append(mnemonic);
                label.append(' ');
            }
            label.append(MessageUtils.escapeForMenu((String)configuration.getName()));
            ImageDescriptor icon = manager.getImageDescriptor(configuration);
            ConfigContribution item = this.createConfigContribution(label, mnemonic, icon, configuration);
            item.data = data;
            items.add((IContributionItem)item);
            ++i;
            ++num;
        }
    }

    protected ConfigContribution createConfigContribution(StringBuilder label, @Nullable String mnemonic, ImageDescriptor icon, ILaunchConfiguration configuration) {
        return new ConfigContribution(label.toString(), mnemonic, icon, configuration);
    }

    protected class ConfigContribution
    extends SimpleContributionItem {
        private Data data;
        private final ILaunchConfiguration configuration;

        public ConfigContribution(@Nullable String label, String mnemonic, ImageDescriptor icon, ILaunchConfiguration configuration) {
            super(label, mnemonic, icon, null);
            this.configuration = configuration;
        }

        protected Data getData() {
            return this.data;
        }

        protected void execute(Event event) throws ExecutionException {
            Data data = this.getData();
            data.manager.setActiveConfig(this.configuration);
            data.manager.launch(this.configuration, data.element, (IdentitySet<String>)RunConfigsDropdownContribution.this.getLaunchFlags());
        }
    }

    private class Data {
        private final LaunchConfigManager<TElement> manager;
        private final TElement element;

        public Data(LaunchConfigManager<TElement> manager, TElement file) {
            this.manager = manager;
            this.element = file;
        }
    }
}

