/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SearchText
extends Composite {
    private static Boolean useNativeSearchField;
    private Text textControl;
    private Label clearButton;
    private final CopyOnWriteIdentityListSet<Listener> listeners = new CopyOnWriteIdentityListSet();
    private boolean typingChange = true;

    private static boolean useNativeSearchField(Composite composite) {
        if (useNativeSearchField == null) {
            useNativeSearchField = Boolean.FALSE;
            Text testText = null;
            try {
                testText = new Text(composite, 384);
                useNativeSearchField = new Boolean((testText.getStyle() & 0x100) != 0);
            }
            finally {
                if (testText != null) {
                    testText.dispose();
                }
            }
        }
        return useNativeSearchField;
    }

    public SearchText(Composite parent) {
        this(parent, 2048, null, 0);
    }

    public SearchText(Composite parent, String initialText, int textStyle) {
        this(parent, 2048, initialText, textStyle);
    }

    public SearchText(Composite parent, int style, String initialText, int textStyle) {
        super(parent, SearchText.useNativeSearchField(parent) ? 0 : style);
        boolean nativeMode = useNativeSearchField;
        if ((style & 0x800) != 0) {
            this.setBackground(parent.getDisplay().getSystemColor(25));
        }
        this.createText(this, nativeMode, nativeMode ? style | textStyle : textStyle);
        this.createClearTextButtonSupport(this, nativeMode);
        if (initialText != null) {
            this.setText(initialText);
            this.textControl.selectAll();
        }
        SWTListener swtListener = new SWTListener();
        this.addListener(11, swtListener);
    }

    public void addListener(Listener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove((Object)listener);
    }

    private void textChanged0() {
        boolean typingChange = this.typingChange;
        this.typingChange = true;
        for (Listener listener : this.listeners) {
            listener.textChanged(typingChange);
        }
    }

    private void okPressed0() {
        for (Listener listener : this.listeners) {
            listener.okPressed();
        }
    }

    private void downPressed0() {
        for (Listener listener : this.listeners) {
            listener.downPressed();
        }
    }

    public boolean setFocus() {
        return this.textControl.setFocus();
    }

    public void setToolTipText(String text) {
        this.textControl.setToolTipText(text);
    }

    public void setText(String text) {
        this.typingChange = false;
        this.textControl.setText(text != null ? text : "");
    }

    public String getText() {
        return this.textControl.getText();
    }

    public Text getTextControl() {
        return this.textControl;
    }

    public void clearText() {
        this.setText(null);
        if (this.isVisible()) {
            this.textControl.setFocus();
        }
    }

    private void createText(Composite parent, boolean nativeMode, int style) {
        style = nativeMode ? (style |= 0x4984) : (style |= 0x4004);
        this.textControl = new Text((Composite)this, style);
        this.textControl.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = SearchText.this.getAccessibleMessage();
            }
        });
        this.textControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    SearchText.this.downPressed0();
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    SearchText.this.okPressed0();
                    e.doit = false;
                    return;
                }
            }
        });
        this.textControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchText.this.textChanged0();
            }
        });
    }

    protected String getAccessibleMessage() {
        return this.textControl.getText();
    }

    private void createClearTextButtonSupport(Composite parent, boolean nativeMode) {
        this.textControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    boolean alreadyClear = SearchText.this.textControl.getText().isEmpty();
                    SearchText.this.setText(null);
                    e.doit = alreadyClear;
                    return;
                }
            }
        });
        if (nativeMode) {
            this.textControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (e.detail == 256) {
                        SearchText.this.clearText();
                    }
                }
            });
        } else {
            final Image activeImage = SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/image/loctool/clearsearch");
            final Image inactiveImage = SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/image/loctoold/clearsearch");
            final Image pressedImage = new Image((Device)Display.getCurrent(), activeImage, 2);
            this.clearButton = new Label(parent, 0);
            this.clearButton.setImage(inactiveImage);
            this.clearButton.setBackground(parent.getDisplay().getSystemColor(25));
            this.clearButton.setToolTipText("Clear");
            this.clearButton.setSize(this.clearButton.computeSize(-1, -1));
            this.clearButton.addMouseListener((MouseListener)new MouseAdapter(){
                private MouseMoveListener fMoveListener;

                public void mouseDown(MouseEvent e) {
                    SearchText.this.clearButton.setImage(pressedImage);
                    this.fMoveListener = new MouseMoveListener(){
                        private boolean fMouseInButton = true;

                        public void mouseMove(MouseEvent e) {
                            boolean mouseInButton = this.isMouseInButton(e);
                            if (mouseInButton != this.fMouseInButton) {
                                this.fMouseInButton = mouseInButton;
                                SearchText.this.clearButton.setImage(mouseInButton ? pressedImage : inactiveImage);
                            }
                        }
                    };
                    SearchText.this.clearButton.addMouseMoveListener(this.fMoveListener);
                }

                public void mouseUp(MouseEvent e) {
                    if (this.fMoveListener != null) {
                        SearchText.this.clearButton.removeMouseMoveListener(this.fMoveListener);
                        this.fMoveListener = null;
                        boolean mouseInButton = this.isMouseInButton(e);
                        SearchText.this.clearButton.setImage(mouseInButton ? activeImage : inactiveImage);
                        if (mouseInButton) {
                            SearchText.this.clearText();
                        }
                    }
                }

                private boolean isMouseInButton(MouseEvent e) {
                    Point buttonSize = SearchText.this.clearButton.getSize();
                    return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
                }
            });
            this.clearButton.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    SearchText.this.clearButton.setImage(activeImage);
                }

                public void mouseExit(MouseEvent e) {
                    SearchText.this.clearButton.setImage(inactiveImage);
                }

                public void mouseHover(MouseEvent e) {
                }
            });
            this.clearButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    pressedImage.dispose();
                }
            });
            this.clearButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = "Clear filter field";
                }
            });
            this.clearButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 43;
                }
            });
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.clearButton != null) {
            Point buttonSize = this.clearButton.getSize();
            Point textSize = this.textControl.computeSize(wHint != -1 ? wHint - buttonSize.x : -1, hHint, changed);
            Rectangle trim = this.computeTrim(0, 0, textSize.x + buttonSize.x, Math.max(textSize.y, buttonSize.y));
            return new Point(trim.width, trim.height);
        }
        Point textSize = this.textControl.computeSize(wHint, hHint, changed);
        Rectangle trim = this.computeTrim(0, 0, textSize.x, textSize.y);
        return new Point(trim.width, trim.height);
    }

    private void updateLayout() {
        Rectangle clientArea = this.getClientArea();
        if (this.clearButton != null) {
            Point buttonSize = this.clearButton.getSize();
            Point textSize = this.textControl.computeSize(-1, -1);
            this.textControl.setBounds(clientArea.x, clientArea.y + (clientArea.height - textSize.y) / 2, clientArea.width - buttonSize.y, textSize.y);
            this.clearButton.setLocation(clientArea.width - buttonSize.y, clientArea.y + (clientArea.height - buttonSize.y) / 2);
        } else {
            this.textControl.setBounds(clientArea);
        }
    }

    public static interface Listener {
        public void okPressed();

        public void downPressed();

        public void textChanged(boolean var1);
    }

    private class SWTListener
    implements org.eclipse.swt.widgets.Listener {
        private SWTListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 11: {
                    SearchText.this.updateLayout();
                    return;
                }
            }
        }
    }
}

