/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.mpbv;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UCharacterIterator;
import java.io.File;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.jface.databinding.swt.ISWTObservableList;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookBrowserPage;
import org.eclipse.statet.ecommons.ui.util.DNDUtils;
import org.eclipse.statet.ecommons.ui.util.InputHistory;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ecommons.ui.Messages;
import org.eclipse.statet.internal.ecommons.ui.UIMiscellanyPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
public class BrowserAddressBar
extends Composite {
    private final PageBookBrowserPage page;
    private final InputHistory<String> inputHistory;
    private @Nullable IListChangeListener<String> urlHistoryListener;
    private ToolBar toolBar;
    private Combo textControl;
    private ToolItem goControl;
    private boolean isEdited;

    public BrowserAddressBar(Composite parent, PageBookBrowserPage page, InputHistory<String> urlHistory) {
        super(parent, 0);
        this.page = page;
        this.inputHistory = urlHistory;
        GridLayout layout = LayoutUtils.newCompositeGrid(2);
        layout.marginBottom = 2;
        layout.horizontalSpacing = 1;
        this.setLayout((Layout)layout);
        this.create();
        this.init();
        this.addListener(12, this::onDispose);
    }

    private void init() {
        if (this.inputHistory != null) {
            ISWTObservableList textItemList = WidgetProperties.items().observe((Widget)this.textControl);
            this.urlHistoryListener = arg_0 -> BrowserAddressBar.lambda$1((IObservableList)textItemList, arg_0);
            this.inputHistory.addListChangeListener(this.urlHistoryListener);
            textItemList.addAll(this.inputHistory);
        }
    }

    protected void onDispose(Event e) {
        if (this.urlHistoryListener != null) {
            this.inputHistory.removeListChangeListener(this.urlHistoryListener);
            this.urlHistoryListener = null;
        }
    }

    protected void create() {
        ImageRegistry imageRegistry = UIMiscellanyPlugin.getInstance().getImageRegistry();
        final Combo text = new Combo((Composite)this, 4);
        text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!text.getListVisible()) {
                    BrowserAddressBar.this.go();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                BrowserAddressBar.this.go();
            }
        });
        text.addListener(24, event -> {
            this.isEdited = true;
        });
        text.addListener(1, event -> {
            if (!event.doit) {
                return;
            }
            if (event.character == '\u001b' && !this.textControl.getListVisible()) {
                BrowserSession session = this.page.getSession();
                this.setText(session.getViewUrl(), false);
            }
        });
        DNDUtils.addDropSupport((Control)text, (DropTargetListener)new DropTargetAdapter(){

            private @Nullable String checkFileData(@Nullable Object data) {
                if (data instanceof String[] && ((String[])data).length == 1) {
                    return ((String[])data)[0];
                }
                return null;
            }

            private @Nullable String checkTextData(@Nullable Object data) {
                if (data instanceof String) {
                    return (String)data;
                }
                return null;
            }

            public void dragEnter(DropTargetEvent event) {
                block12: {
                    block11: {
                        if (!FileTransfer.getInstance().isSupportedType(event.currentDataType)) break block11;
                        switch (event.detail) {
                            case 1: 
                            case 4: {
                                return;
                            }
                            case 16: {
                                if ((event.operations & 4) != 0) {
                                    event.detail = 4;
                                    return;
                                }
                                if ((event.operations & 1) != 0) {
                                    event.detail = 1;
                                    return;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block12;
                    }
                    if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                        switch (event.detail) {
                            case 1: {
                                return;
                            }
                            case 16: {
                                if ((event.operations & 1) == 0) break;
                                event.detail = 1;
                                return;
                            }
                        }
                    }
                }
                event.detail = 0;
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.dragEnter(event);
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 0;
            }

            public void drop(DropTargetEvent event) {
                String text = null;
                if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String filePath = this.checkFileData(event.data);
                    try {
                        text = new File(filePath).toURI().toURL().toExternalForm();
                    }
                    catch (Exception exception) {}
                } else if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && (text = this.checkTextData(event.data)) != null) {
                    text = BrowserAddressBar.this.checkPasteText((String)event.data);
                }
                if (text != null) {
                    BrowserAddressBar.this.setText(text, true);
                } else {
                    event.detail = 0;
                }
            }
        }, new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()});
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textControl = text;
        this.toolBar = new ToolBar((Composite)this, 0x800000);
        this.toolBar.setLayoutData((Object)new GridData(4, 4, false, false));
        ToolItem button = new ToolItem(this.toolBar, 8);
        button.setToolTipText(Messages.Browser_Go_tooltip);
        button.setImage(imageRegistry.get("org.eclipse.statet.ecommons.uimisc/image/loctool/go"));
        button.setDisabledImage(imageRegistry.get("org.eclipse.statet.ecommons.uimisc/image/loctoold/go"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserAddressBar.this.go();
            }
        });
        this.goControl = button;
    }

    protected void setText(String text, boolean edit) {
        this.textControl.setText(text);
        this.isEdited = edit;
    }

    protected String checkPasteText(String s) {
        int cp;
        StringBuilder sb = new StringBuilder(s.length());
        UCharacterIterator iter = UCharacterIterator.getInstance((String)s);
        while ((cp = iter.nextCodePoint()) != -1) {
            if (!UCharacter.isPrintable((int)cp)) continue;
            sb.appendCodePoint(cp);
        }
        return sb.toString();
    }

    protected void go() {
        String orgUrl = this.textControl.getText();
        @Nullable String checkedUrl = this.checkUrl(orgUrl);
        if (checkedUrl == null) {
            return;
        }
        this.setText(checkedUrl, false);
        this.page.setUrl(checkedUrl);
        this.page.setFocusToBrowser();
        if (this.inputHistory != null) {
            this.inputHistory.append(checkedUrl);
        }
    }

    protected @Nullable String checkUrl(String url) {
        if (url.indexOf(58) == -1) {
            if (url.length() >= 1 && url.charAt(0) == '/') {
                url = url.substring(url.length() >= 2 && url.charAt(1) == '/' ? 2 : 1);
            }
            url = "http://" + url;
        }
        if (url.equals("http://")) {
            return null;
        }
        return url;
    }

    protected void onPageChanged() {
        if (UIAccess.isOkToUse((Control)this.textControl) && !this.textControl.isFocusControl()) {
            BrowserSession session = this.page.getSession();
            this.setText(session.getViewUrl(), false);
        }
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    private static /* synthetic */ void lambda$1(IObservableList iObservableList, ListChangeEvent e) {
        e.diff.applyTo((List)iObservableList);
    }
}

