/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.edit.ActiveCellEditorRegistry;
import org.eclipse.statet.ecommons.waltable.edit.EditConfigAttributes;
import org.eclipse.statet.ecommons.waltable.edit.EditMode;
import org.eclipse.statet.ecommons.waltable.edit.EditTypeEnum;
import org.eclipse.statet.ecommons.waltable.edit.InlineEditHandler;
import org.eclipse.statet.ecommons.waltable.edit.UpdateDataCommand;
import org.eclipse.statet.ecommons.waltable.edit.editor.ICellEditor;
import org.eclipse.statet.ecommons.waltable.edit.gui.CellEditDialogFactory;
import org.eclipse.statet.ecommons.waltable.edit.gui.ICellEditDialog;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.swt.SWTUtil;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EditController {
    public static void editCell(ILayerCell cell, Composite parent, Object initialCanonicalValue, IConfigRegistry configRegistry) {
        try {
            LRectangle cellBounds = cell.getBounds();
            ILayer layer = cell.getLayer();
            long columnPosition = cell.getColumnPosition();
            long rowPosition = cell.getRowPosition();
            List<String> configLabels = cell.getConfigLabels().getLabels();
            ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, DisplayMode.EDIT, configLabels);
            if (cellEditor.openInline(configRegistry, configLabels)) {
                InlineEditHandler editHandler = new InlineEditHandler(layer, columnPosition, rowPosition);
                Rectangle editorBounds = SWTUtil.toSWT(layer.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, new LRectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height)));
                cellEditor.activateCell(parent, initialCanonicalValue, EditMode.INLINE, editHandler, cell, configRegistry);
                Control editorControl = cellEditor.getEditorControl();
                editorBounds = cellEditor.calculateControlBounds(editorBounds);
                if (editorControl != null && !editorControl.isDisposed()) {
                    editorControl.setBounds(editorBounds);
                    cellEditor.addEditorControlListeners();
                    ActiveCellEditorRegistry.registerActiveCellEditor(cellEditor);
                }
            } else {
                ArrayList<ILayerCell> cells = new ArrayList<ILayerCell>();
                cells.add(cell);
                EditController.editCells(cells, parent, initialCanonicalValue, configRegistry);
            }
        }
        catch (Exception e) {
            if (cell == null) {
                WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "Cell being edited is no longer available. Initial value: " + initialCanonicalValue, (Throwable)e));
            }
            WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "Error while editing cell: Cell: " + cell + "; Initial value: " + initialCanonicalValue, (Throwable)e));
        }
    }

    public static void editCells(Collection<ILayerCell> cells, Composite parent, Object initialCanonicalValue, IConfigRegistry configRegistry) {
        block3: {
            ICellEditor cellEditor;
            block4: {
                if (cells == null || cells.isEmpty()) break block3;
                cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, DisplayMode.EDIT, cells.iterator().next().getConfigLabels().getLabels());
                if (cells.size() != 1 && (cells.size() <= 1 || !EditController.supportMultiEdit(cells, cellEditor, configRegistry))) break block3;
                if (!cellEditor.openMultiEditDialog()) break block4;
                ICellEditDialog dialog = CellEditDialogFactory.createCellEditDialog(parent != null ? parent.getShell() : null, initialCanonicalValue, cells.iterator().next(), cellEditor, configRegistry);
                int returnValue = dialog.open();
                if (returnValue != 0) break block3;
                for (ILayerCell selectedCell : cells) {
                    Object editorValue = dialog.getCommittedValue();
                    if (dialog.getEditType() != EditTypeEnum.SET) {
                        editorValue = dialog.calculateValue(selectedCell.getDataValue(0, null), editorValue);
                    }
                    ILayer layer = selectedCell.getLayer();
                    layer.doCommand(new UpdateDataCommand(layer, selectedCell.getColumnPosition(), selectedCell.getRowPosition(), editorValue));
                }
                break block3;
            }
            for (ILayerCell cell : cells) {
                InlineEditHandler editHandler = new InlineEditHandler(cell.getLayer(), cell.getColumnPosition(), cell.getRowPosition());
                cellEditor.activateCell(parent, initialCanonicalValue, EditMode.INLINE, editHandler, cell, configRegistry);
            }
        }
    }

    private static boolean supportMultiEdit(Collection<ILayerCell> cells, ICellEditor cellEditor, IConfigRegistry configRegistry) {
        for (ILayerCell cell : cells) {
            if (cellEditor.supportMultiEdit(configRegistry, cell.getConfigLabels().getLabels())) continue;
            return false;
        }
        return true;
    }
}

