/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.core;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ltk.core.LTKCorePlugin;

public class AdapterFactory {
    private static final String ADAPTER_ELEMENT_NAME = "adapter";
    private static final String MODEL_TYPE_ID_ATTRIBUTE_NAME = "modelTypeId";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private final String extensionPointId;
    private final Map<String, Map<String, AdapterContribution>> map = new IdentityHashMap<String, Map<String, AdapterContribution>>();

    public AdapterFactory(String extensionPointId) {
        this.extensionPointId = extensionPointId;
        this.load();
    }

    private void load() {
        IConfigurationElement[] elements;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = extensionRegistry.getConfigurationElementsFor(this.extensionPointId);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement contributionElement = iConfigurationElementArray[n2];
            String modelTypeId = contributionElement.getAttribute(MODEL_TYPE_ID_ATTRIBUTE_NAME);
            if (modelTypeId != null) {
                IConfigurationElement[] adapterElements;
                Map<String, AdapterContribution> map = this.map.get(modelTypeId = modelTypeId.intern());
                if (map == null) {
                    map = new HashMap<String, AdapterContribution>();
                    this.map.put(modelTypeId, map);
                }
                IConfigurationElement[] iConfigurationElementArray2 = adapterElements = contributionElement.getChildren();
                int n3 = adapterElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    String type;
                    IConfigurationElement adapterElement = iConfigurationElementArray2[n4];
                    if (adapterElement.getName().equals(ADAPTER_ELEMENT_NAME) && (type = adapterElement.getAttribute(TYPE_ATTRIBUTE_NAME)) != null) {
                        if (contributionElement.getName().equals("adapterClass")) {
                            map.put(type, new ClassContribution(contributionElement));
                        } else if (contributionElement.getName().equals("adapterFactory")) {
                            map.put(type, new FactoryContribution(contributionElement));
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String modelTypeId, Class<T> adapterType) {
        AdapterContribution contribution;
        Map<String, Map<String, AdapterContribution>> map = this.map;
        synchronized (map) {
            Map<String, AdapterContribution> map2;
            block4: {
                map2 = this.map.get(modelTypeId);
                if (map2 != null) break block4;
                return null;
            }
            contribution = map2.get(adapterType.getName());
        }
        return contribution != null ? (T)contribution.getAdapter(modelTypeId, adapterType) : null;
    }

    private static interface AdapterContribution {
        public <T> T getAdapter(String var1, Class<T> var2);
    }

    private static class ClassContribution
    implements AdapterContribution {
        private IConfigurationElement configurationElement;

        public ClassContribution(IConfigurationElement contributionElement) {
            this.configurationElement = contributionElement;
        }

        @Override
        public <T> T getAdapter(String modelTypeId, Class<T> adapterType) {
            try {
                return (T)this.configurationElement.createExecutableExtension(AdapterFactory.CLASS_ATTRIBUTE_NAME);
            }
            catch (CoreException e) {
                LTKCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", 0, NLS.bind((String)"An error occurred when loading adapter class for model ''{0}''.", (Object)modelTypeId), (Throwable)e));
                this.configurationElement = null;
                return null;
            }
        }
    }

    private static class FactoryContribution
    implements AdapterContribution {
        private IConfigurationElement configurationElement;
        private IAdapterFactory factory;

        public FactoryContribution(IConfigurationElement configurationElement) {
            this.configurationElement = configurationElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T getAdapter(String modelTypeId, Class<T> adapterType) {
            FactoryContribution factoryContribution = this;
            synchronized (factoryContribution) {
                if (this.configurationElement != null) {
                    try {
                        this.factory = (IAdapterFactory)this.configurationElement.createExecutableExtension(AdapterFactory.CLASS_ATTRIBUTE_NAME);
                        this.configurationElement = null;
                    }
                    catch (CoreException e) {
                        LTKCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", 0, NLS.bind((String)"An error occurred when loading adapter factory for model ''{0}''.", (Object)modelTypeId), (Throwable)e));
                        this.configurationElement = null;
                    }
                }
            }
            if (this.factory != null) {
                return (T)this.factory.getAdapter((Object)modelTypeId, adapterType);
            }
            return null;
        }
    }
}

