/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core;

import java.nio.channels.IllegalSelectorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.core.LTKUtils;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.IWorkspaceSourceUnit;

public class ElementSet {
    private static final int POST_INIT = 65536;
    private static final int POST_PROCESS = 458752;
    protected ImList<Object> initialElements;
    private List<IModelElement> modelElements;
    private List<IResource> resources;
    private int processState = 0;
    private List<IResource> resourcesOwnedByElements;
    private List<IFile> filesContainingElements;

    public static String[] getAffectedProjectNatures(ElementSet set) throws CoreException {
        return ElementSet.getAffectedProjectNatures(Collections.singletonList(set));
    }

    public static String[] getAffectedProjectNatures(List<ElementSet> sets) throws CoreException {
        HashSet<String> natureIds = new HashSet<String>();
        for (ElementSet set : sets) {
            Set<IProject> affectedProjects = set.getAffectedProjects();
            for (IProject project : affectedProjects) {
                String[] ids;
                String[] stringArray = ids = project.getDescription().getNatureIds();
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    natureIds.add(id);
                    ++n2;
                }
            }
        }
        return natureIds.toArray(new String[natureIds.size()]);
    }

    public ElementSet(List<Object> elements) {
        this.initialElements = ImCollections.toList(elements);
        this.init(elements);
        if (this.modelElements == null) {
            this.modelElements = new ArrayList<IModelElement>(0);
        }
        if (this.resources == null) {
            this.resources = new ArrayList<IResource>(0);
        }
        this.processState = this.countElements() == this.initialElements.size() ? 65536 : -65536;
    }

    public ElementSet(Object ... elements) {
        this((List<Object>)ImCollections.newList((Object[])elements));
    }

    protected void init(List<Object> elements) {
        for (Object o : elements) {
            this.add(o);
        }
    }

    protected void add(Object o) {
        if (o instanceof IModelElement) {
            if (this.modelElements == null) {
                this.modelElements = new ArrayList<IModelElement>();
            }
            this.modelElements.add((IModelElement)o);
            return;
        }
        if (o instanceof IResource) {
            if (this.resources == null) {
                this.resources = new ArrayList<IResource>();
            }
            this.resources.add((IResource)o);
            return;
        }
    }

    protected int countElements() {
        return this.resources.size() + this.modelElements.size();
    }

    public int getElementCount() {
        return this.countElements();
    }

    public boolean isOK() {
        return this.processState > 0;
    }

    public List<Object> getInitialObjects() {
        return this.initialElements;
    }

    public List<IResource> getResources() {
        return this.resources;
    }

    public List<IModelElement> getModelElements() {
        return this.modelElements;
    }

    public List<IResource> getResourcesOwnedByElements() {
        return this.resourcesOwnedByElements;
    }

    public List<IFile> getFilesContainingElements() {
        return this.filesContainingElements;
    }

    public IResource getOwningResource(IModelElement element) {
        if ((element.getElementType() & 0xFF0) < 640) {
            IResource resource = (IResource)element.getAdapter(IResource.class);
            return resource;
        }
        return null;
    }

    public IResource getResource(IModelElement element) {
        ISourceUnit su = LTKUtils.getSourceUnit(element);
        if (su instanceof IWorkspaceSourceUnit) {
            return ((IWorkspaceSourceUnit)su).getResource();
        }
        return null;
    }

    public IProject getSingleProject() {
        IProject project = null;
        for (IResource resource : this.resources) {
            IProject p = resource.getProject();
            if (project == null) {
                project = p;
                continue;
            }
            if (project.equals((Object)p)) continue;
            return null;
        }
        for (IModelElement element : this.modelElements) {
            IResource resource = this.getResource(element);
            if (resource == null) continue;
            IProject p = resource.getProject();
            if (project == null) {
                project = p;
                continue;
            }
            if (project.equals((Object)p)) continue;
            return null;
        }
        return project;
    }

    public Set<IProject> getProjects() {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (IResource resource : this.resources) {
            projects.add(resource.getProject());
        }
        for (IModelElement element : this.modelElements) {
            IResource resource = this.getResource(element);
            if (resource == null) continue;
            projects.add(resource.getProject());
        }
        return projects;
    }

    public Set<IProject> getAffectedProjects() {
        Set<IProject> projects = this.getProjects();
        IProject[] array = projects.toArray(new IProject[projects.size()]);
        int i = 0;
        while (i < array.length) {
            IProject[] referencingProjects = array[i].getReferencingProjects();
            if (referencingProjects.length > 0) {
                this.addAffectedProjects(referencingProjects, projects);
            }
            ++i;
        }
        return projects;
    }

    private void addAffectedProjects(IProject[] projectToAdd, Set<IProject> projects) {
        int i = 0;
        while (i < projectToAdd.length) {
            IProject[] referencingProjects;
            if (projects.add(projectToAdd[i]) && (referencingProjects = projectToAdd[i].getReferencingProjects()).length > 0) {
                this.addAffectedProjects(referencingProjects, projects);
            }
            ++i;
        }
    }

    public void removeElementsWithAncestorsOnList() {
        if ((this.processState & 0x10) == 0) {
            this.removeResourcesDescendantsOfResources();
            this.removeResourcesDescendantsOfModelElements();
            this.removeModelElementsDescendantsOfModelElements();
            this.processState |= 0x10;
        }
    }

    private void removeResourcesDescendantsOfResources() {
        Iterator<IResource> iter = this.resources.iterator();
        block0: while (iter.hasNext()) {
            IResource subResource = iter.next();
            for (IResource superResource : this.resources) {
                if (!this.isDescendantOf(subResource, superResource)) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    private void removeResourcesDescendantsOfModelElements() {
        Iterator<IResource> iter = this.resources.iterator();
        block0: while (iter.hasNext()) {
            IResource subResource = iter.next();
            for (IModelElement superElement : this.modelElements) {
                if (!this.isDescendantOf(subResource, superElement)) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    private void removeModelElementsDescendantsOfModelElements() {
        Iterator<IModelElement> iter = this.modelElements.iterator();
        block0: while (iter.hasNext()) {
            IModelElement subElement = iter.next();
            for (IModelElement superElement : this.modelElements) {
                if (!this.isDescendantOf(subElement, superElement)) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    public boolean includes(IModelElement element) {
        if (this.modelElements.contains(element)) {
            return true;
        }
        for (IModelElement e : this.modelElements) {
            if (!this.isDescendantOf(element, e)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDescendantOf(IResource subResource, IResource superResource) {
        return !subResource.equals((Object)superResource) && superResource.getFullPath().isPrefixOf(subResource.getFullPath());
    }

    protected boolean isDescendantOf(IResource subResource, IModelElement superElement) {
        IResource superResource = this.getOwningResource(superElement);
        if (superResource != null) {
            return this.isDescendantOf(subResource, superResource);
        }
        return false;
    }

    protected boolean isDescendantOf(IModelElement subElement, IModelElement superElement) {
        if (subElement.equals(superElement) || !(subElement instanceof ISourceStructElement)) {
            return false;
        }
        ISourceStructElement parent = ((ISourceStructElement)subElement).getSourceParent();
        while (parent != null) {
            if (parent.equals(superElement)) {
                return true;
            }
            parent = parent.getSourceParent();
        }
        return false;
    }

    protected void setModelElements(List<IModelElement> newElements) {
        if (this.processState >= 458752) {
            throw new IllegalSelectorException();
        }
        this.modelElements = newElements;
    }

    public void postProcess() {
        if (this.processState < 0) {
            throw new IllegalStateException();
        }
        if (this.processState < 458752) {
            this.resourcesOwnedByElements = new ArrayList<IResource>(1);
            this.filesContainingElements = new ArrayList<IFile>(1);
            for (IModelElement element : this.modelElements) {
                IResource resource = this.getOwningResource(element);
                if (resource != null) {
                    this.resourcesOwnedByElements.add(resource);
                    continue;
                }
                resource = this.getResource(element);
                if (resource == null || resource.getType() != 1) continue;
                this.filesContainingElements.add((IFile)resource);
            }
        }
        this.processState = 0x70000 | this.processState & 0xFFFF;
    }
}

