/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.ltk.ui.sourceediting.EditorInformationProvider;

public class MultiContentSectionInformationProvider
implements IInformationProvider,
IInformationProviderExtension,
IInformationProviderExtension2 {
    private static final Object NULL = new Object();
    private final IDocContentSections sections;
    private final Map<String, Object> handlers = new IdentityHashMap<String, Object>(8);
    private EditorInformationProvider activeProvider;

    public MultiContentSectionInformationProvider(IDocContentSections sections) {
        if (sections == null) {
            throw new NullPointerException("sections");
        }
        this.sections = sections;
    }

    public MultiContentSectionInformationProvider(IDocContentSections sections, String key1, EditorInformationProvider provider1) {
        this(sections, key1, provider1, null, null);
    }

    public MultiContentSectionInformationProvider(IDocContentSections sections, String sectionType1, EditorInformationProvider provider1, String sectionType2, EditorInformationProvider provider2) {
        this(sections);
        if (sectionType1 != null) {
            this.registerProvider(sectionType1, provider1);
        }
        if (sectionType2 != null) {
            this.registerProvider(sectionType2, provider2);
        }
    }

    protected final IDocContentSections getSections() {
        return this.sections;
    }

    public void registerProvider(String sectionType, EditorInformationProvider provider) {
        if (sectionType == null) {
            throw new NullPointerException("sectionType");
        }
        this.handlers.put(sectionType, provider != null ? provider : NULL);
    }

    protected final EditorInformationProvider getProvider(String sectionType) {
        if (sectionType == "") {
            return null;
        }
        Object handler = this.handlers.get(sectionType);
        if (handler == null) {
            handler = NULL;
            try {
                EditorInformationProvider newHandler = this.createHandler(sectionType);
                if (newHandler != null) {
                    handler = newHandler;
                }
            }
            finally {
                this.handlers.put(sectionType, handler);
            }
        }
        return handler != NULL ? (EditorInformationProvider)handler : null;
    }

    protected EditorInformationProvider createHandler(String sectionType) {
        return null;
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        this.activeProvider = null;
        EditorInformationProvider provider = this.getProvider(this.sections.getType(textViewer.getDocument(), offset));
        if (provider != null) {
            this.activeProvider = provider;
            return this.activeProvider.getSubject(textViewer, offset);
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        return null;
    }

    public Object getInformation2(ITextViewer textViewer, IRegion subject) {
        if (this.activeProvider == null) {
            return null;
        }
        return this.activeProvider.getInformation2(textViewer, subject);
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.activeProvider == null) {
            return null;
        }
        return this.activeProvider.getInformationPresenterControlCreator();
    }
}

