/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.ecommons.databinding.IntegerValidator;
import org.eclipse.statet.ecommons.databinding.jface.SWTMultiEnabledObservable;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigTabWithDbc;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.components.DataAdapter;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.internal.r.console.ui.launching.RHistoryConfigurationComposite;
import org.eclipse.statet.internal.r.console.ui.launching.RTrackingConfigurationComposite;
import org.eclipse.statet.ltk.ui.sourceediting.SnippetEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SnippetEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SnippetEditorObservable;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.nico.core.util.HistoryTrackingConfiguration;
import org.eclipse.statet.nico.core.util.TrackingConfiguration;
import org.eclipse.statet.nico.core.util.TrackingConfiguration2LaunchConfiguration;
import org.eclipse.statet.nico.ui.util.TrackingConfigurationComposite;
import org.eclipse.statet.nico.ui.util.TrackingConfigurationDialog;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.ui.sourceediting.RTemplateSourceViewerConfigurator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;

public class RConsoleOptionsTab
extends LaunchConfigTabWithDbc {
    static final String TRANSCRIPT_TRACKING_ID = "transcript";
    static final String CUSTOM_TRACKING_ID_PREFIX = "custom";
    static final String TRACKING_IDS = "tracking.ids";
    static final String TRACKING_ENABLED_IDS = "tracking.enabled.ids";
    static final TrackingConfiguration2LaunchConfiguration TRACKING_UTIL = new TrackingConfiguration2LaunchConfiguration();
    static final String ATTR_INTEGRATION_ROOT = "org.eclipse.statet.r.debug/integration";
    static final String ATTR_INTEGRATION_RHELP_ENABLED = "org.eclipse.statet.r.debug/integrationintegration.rhelp.enabled";
    static final String ATTR_INTEGRATION_RGRAPHICS_ASDEFAULT = "org.eclipse.statet.r.debug/integrationintegration.rgraphics.asdefault";
    static final String ATTR_INTEGRATION_RDBGEXT_ENABLED = "org.eclipse.statet.r.debug/integrationintegration.rdbgext.enabled";
    private final IObservableValue<Boolean> pinValue;
    private final IObservableList<TrackingConfiguration> trackingList;
    private final IObservableSet<TrackingConfiguration> trackingEnabledSet;
    private final IObservableValue<String> startupSnippetValue;
    private final IObservableValue<Boolean> rHelpByStatetValue;
    private final IObservableValue<Boolean> rGraphicsByStatetValue;
    private final IObservableValue<Boolean> rDbgExtValue;
    private final IObservableValue<Boolean> objectDBEnabledValue;
    private final IObservableValue<Boolean> objectDBAutoEnabledValue;
    private final IObservableValue<Integer> objectDBListsChildrenValue;
    private final IObservableValue<Integer> objectDBEnvsChildrenValue;
    private Button pinControl;
    private CheckboxTableViewer trackingTable;
    private ButtonGroup<TrackingConfiguration> trackingButtons;
    private int trackingMaxCustomId;
    private SnippetEditor1 startupSnippetEditor;
    private Button rHelpByStatetControl;
    private Button rGraphicsByStatetControl;
    private Button rDbgExtControl;
    private Button objectDBEnabledControl;
    private Button objectDBAutoEnabledControl;
    private Text objectDBListsChildrenControl;
    private Text objectDBEnvsChildrenControl;

    public RConsoleOptionsTab() {
        Realm realm = this.getRealm();
        this.pinValue = new WritableValue(realm, (Object)false, Boolean.TYPE);
        this.trackingList = new WritableList(realm, new ArrayList(), TrackingConfiguration.class);
        this.trackingEnabledSet = new WritableSet(realm, new HashSet(), TrackingConfiguration.class);
        this.startupSnippetValue = new WritableValue(realm, (Object)"", String.class);
        this.rHelpByStatetValue = new WritableValue(realm, (Object)false, Boolean.TYPE);
        this.rGraphicsByStatetValue = new WritableValue(realm, (Object)false, Boolean.TYPE);
        this.rDbgExtValue = new WritableValue(realm, (Object)false, Boolean.TYPE);
        this.objectDBEnabledValue = new WritableValue(realm, (Object)false, Boolean.TYPE);
        this.objectDBAutoEnabledValue = new WritableValue(realm, (Object)false, Boolean.TYPE);
        this.objectDBListsChildrenValue = new WritableValue(realm, (Object)100000, Integer.TYPE);
        this.objectDBEnvsChildrenValue = new WritableValue(realm, (Object)100000, Integer.TYPE);
    }

    public String getName() {
        return Messages.RConsole_OptionsTab_name;
    }

    public void createControl(Composite parent) {
        Composite trackingComposite;
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Composite consoleComposite = this.createConsoleOptions(mainComposite);
        if (consoleComposite != null) {
            consoleComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        if ((trackingComposite = this.createTrackingOptions(mainComposite)) != null) {
            trackingComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        Group group = new Group(mainComposite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        group.setText("R snippet run after startup:");
        this.createSnippetOptions((Composite)group);
        group = new Group(mainComposite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText("Eclipse Integration:");
        this.createEclipseOptions((Composite)group);
        Dialog.applyDialogFont((Control)parent);
        this.initBindings();
        this.trackingButtons.updateState();
    }

    private Composite createConsoleOptions(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.RConsole_MainTab_ConsoleOptions_label);
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        this.pinControl = new Button((Composite)group, 32);
        this.pinControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.pinControl.setText(Messages.RConsole_MainTab_ConsoleOptions_Pin_label);
        return group;
    }

    private Composite createTrackingOptions(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("History / Transcript / Tracking:");
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        ViewerUtils.CheckboxTableComposite trackingTable = new ViewerUtils.CheckboxTableComposite((Composite)group, 67588);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = LayoutUtils.hintHeight((Table)trackingTable.table, (int)5);
        trackingTable.setLayoutData((Object)gd);
        this.trackingTable = trackingTable.viewer;
        TableViewerColumn column = trackingTable.addColumn("Name", 16384, (ColumnLayoutData)new ColumnWeightData(100));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                TrackingConfiguration config = (TrackingConfiguration)cell.getElement();
                cell.setText(config.getName());
            }
        });
        this.trackingButtons = new ButtonGroup<TrackingConfiguration>((Composite)group){

            protected TrackingConfiguration edit1(TrackingConfiguration item, boolean newItem, Object parent) {
                TrackingConfigurationDialog dialog;
                if (!newItem && item != null && item.getId().equals("history")) {
                    item = new HistoryTrackingConfiguration(item.getId(), (HistoryTrackingConfiguration)item);
                    dialog = new TrackingConfigurationDialog(RConsoleOptionsTab.this.getShell(), item, false){

                        protected TrackingConfigurationComposite createConfigComposite(Composite parent) {
                            return new RHistoryConfigurationComposite(parent);
                        }
                    };
                } else {
                    if (newItem) {
                        String id = RConsoleOptionsTab.CUSTOM_TRACKING_ID_PREFIX + (RConsoleOptionsTab.this.trackingMaxCustomId + 1);
                        item = item == null ? new TrackingConfiguration(id) : new TrackingConfiguration(id, item);
                    } else {
                        item = new TrackingConfiguration(item.getId(), item);
                    }
                    dialog = new TrackingConfigurationDialog(RConsoleOptionsTab.this.getShell(), item, newItem){

                        protected TrackingConfigurationComposite createConfigComposite(Composite parent) {
                            return new RTrackingConfigurationComposite(parent);
                        }
                    };
                }
                if (dialog.open() == 0) {
                    if (newItem) {
                        RConsoleOptionsTab rConsoleOptionsTab = RConsoleOptionsTab.this;
                        rConsoleOptionsTab.trackingMaxCustomId = rConsoleOptionsTab.trackingMaxCustomId + 1;
                    }
                    return item;
                }
                return null;
            }
        };
        this.trackingButtons.addAddButton(null);
        this.trackingButtons.addDeleteButton(null);
        this.trackingButtons.addEditButton(null);
        this.trackingButtons.setLayoutData((Object)new GridData(4, 128, false, false));
        ViewerUtils.scheduleStandardSelection((TableViewer)this.trackingTable);
        return group;
    }

    private void createSnippetOptions(Composite container) {
        container.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        TemplateVariableProcessor templateVariableProcessor = new TemplateVariableProcessor();
        RTemplateSourceViewerConfigurator configurator = new RTemplateSourceViewerConfigurator(RCore.WORKBENCH_ACCESS, templateVariableProcessor);
        this.startupSnippetEditor = new SnippetEditor1((SourceEditorViewerConfigurator)configurator, null, (IServiceLocator)PlatformUI.getWorkbench(), "org.eclipse.statet.r.ui/launchingconfig");
        this.startupSnippetEditor.create(container, 0x2000B02);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = LayoutUtils.hintHeight((StyledText)this.startupSnippetEditor.getSourceViewer().getTextWidget(), (int)8);
        this.startupSnippetEditor.getControl().setLayoutData((Object)gd);
    }

    private void createEclipseOptions(Composite container) {
        container.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        this.rHelpByStatetControl = new Button(container, 32);
        GridData gd = new GridData(4, 4, true, false, 2, 1);
        this.rHelpByStatetControl.setLayoutData((Object)gd);
        this.rHelpByStatetControl.setText("Enable R Help by StatET for help functions in R ('help', 'help.start', '?')");
        this.rGraphicsByStatetControl = new Button(container, 32);
        gd = new GridData(4, 4, true, false, 2, 1);
        this.rGraphicsByStatetControl.setLayoutData((Object)gd);
        this.rGraphicsByStatetControl.setText("Set R Graphic view by StatET as default graphic device for new plots in R");
        this.rDbgExtControl = new Button(container, 32);
        gd = new GridData(4, 4, true, false, 2, 1);
        this.rDbgExtControl.setLayoutData((Object)gd);
        this.rDbgExtControl.setText("Enable extensions by StatET for improved debug support of R code");
        this.objectDBEnabledControl = new Button(container, 32);
        this.objectDBEnabledControl.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.objectDBEnabledControl.setText("Enable Object DB (for Object Browser etc.)");
        this.objectDBAutoEnabledControl = new Button(container, 32);
        gd = new GridData(4, 4, true, false, 2, 1);
        gd.horizontalIndent = LayoutUtils.defaultIndent();
        this.objectDBAutoEnabledControl.setLayoutData((Object)gd);
        this.objectDBAutoEnabledControl.setText("Refresh DB automatically (initial setting)");
        Label label = new Label(container, 0);
        label.setText("Max length of R lists to fetch:");
        GridData gd2 = new GridData(4, 4, false, false);
        gd2.horizontalIndent = LayoutUtils.defaultIndent();
        label.setLayoutData((Object)gd2);
        this.objectDBListsChildrenControl = new Text(container, 2048);
        this.objectDBListsChildrenControl.setTextLimit(10);
        gd = new GridData(16384, 4, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)this.objectDBListsChildrenControl, (int)10);
        this.objectDBListsChildrenControl.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("Max length of R environments to fetch:");
        gd2 = new GridData(4, 4, false, false);
        gd2.horizontalIndent = LayoutUtils.defaultIndent();
        label.setLayoutData((Object)gd2);
        this.objectDBEnvsChildrenControl = new Text(container, 2048);
        this.objectDBEnvsChildrenControl.setTextLimit(10);
        gd = new GridData(16384, 4, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)this.objectDBEnvsChildrenControl, (int)10);
        this.objectDBEnvsChildrenControl.setLayoutData((Object)gd);
    }

    protected void addBindings(DataBindingContext dbc, Realm realm) {
        dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.pinControl), this.pinValue);
        this.trackingTable.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.trackingTable.setInput(this.trackingList);
        dbc.bindValue((IObservableValue)new SnippetEditorObservable(realm, (SnippetEditor)this.startupSnippetEditor, 24), this.startupSnippetValue, null, null);
        dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.rHelpByStatetControl), this.rHelpByStatetValue);
        dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.rGraphicsByStatetControl), this.rGraphicsByStatetValue);
        dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.rDbgExtControl), this.rDbgExtValue);
        ISWTObservableValue objectDBTargetObs = WidgetProperties.selection().observe((Widget)this.objectDBEnabledControl);
        dbc.bindValue((IObservableValue)objectDBTargetObs, this.objectDBEnabledValue);
        dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.objectDBAutoEnabledControl), this.objectDBAutoEnabledValue);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.objectDBListsChildrenControl), this.objectDBListsChildrenValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(100, Integer.MAX_VALUE, "Invalid max value for length of R lists to fetch (100-).")), null);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.objectDBEnvsChildrenControl), this.objectDBEnvsChildrenValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(100, Integer.MAX_VALUE, "Invalid max value for length of R environments to fetch (100-).")), null);
        dbc.bindValue((IObservableValue)new SWTMultiEnabledObservable(realm, new Control[]{this.objectDBAutoEnabledControl, this.objectDBEnvsChildrenControl, this.objectDBListsChildrenControl}, null), (IObservableValue)objectDBTargetObs);
        this.trackingButtons.connectTo((StructuredViewer)this.trackingTable, (DataAdapter)new DataAdapter.ListAdapter<TrackingConfiguration>(this.trackingList, null){

            public boolean isDeleteAllowed(Object element) {
                return super.isDeleteAllowed(element) && ((TrackingConfiguration)element).getId().startsWith(RConsoleOptionsTab.CUSTOM_TRACKING_ID_PREFIX);
            }
        });
        this.trackingButtons.setCheckedModel(this.trackingEnabledSet);
        dbc.bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)this.trackingTable, TrackingConfiguration.class), this.trackingEnabledSet);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected void doInitialize(ILaunchConfiguration configuration) {
        HistoryTrackingConfiguration trackingConfig;
        String startupSnippet;
        boolean pin;
        try {
            pin = configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/console.pin", false);
        }
        catch (CoreException e) {
            pin = false;
            this.logReadingError(e);
        }
        this.pinValue.setValue((Object)pin);
        boolean enabled = true;
        try {
            enabled = configuration.getAttribute(ATTR_INTEGRATION_RHELP_ENABLED, enabled);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        this.rHelpByStatetValue.setValue((Object)enabled);
        enabled = true;
        try {
            enabled = configuration.getAttribute(ATTR_INTEGRATION_RGRAPHICS_ASDEFAULT, enabled);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        this.rGraphicsByStatetValue.setValue((Object)enabled);
        enabled = true;
        try {
            enabled = configuration.getAttribute(ATTR_INTEGRATION_RDBGEXT_ENABLED, enabled);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        this.rDbgExtValue.setValue((Object)enabled);
        try {
            startupSnippet = configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/init.script.snippet", "");
        }
        catch (CoreException e) {
            startupSnippet = "";
            this.logReadingError(e);
        }
        this.startupSnippetValue.setValue((Object)startupSnippet);
        boolean enabled2 = true;
        try {
            enabled2 = configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.enabled", enabled2);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        this.objectDBEnabledValue.setValue((Object)enabled2);
        enabled2 = true;
        try {
            enabled2 = configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.autorefresh.enabled", enabled2);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        this.objectDBAutoEnabledValue.setValue((Object)enabled2);
        int max = 200000;
        try {
            max = configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.lists.max_length", max);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        this.objectDBListsChildrenValue.setValue((Object)max);
        max = 20000;
        try {
            max = configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.envs.max_length", max);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        this.objectDBEnvsChildrenValue.setValue((Object)max);
        this.trackingList.clear();
        this.trackingMaxCustomId = 0;
        List trackingIds = Collections.emptyList();
        try {
            trackingIds = configuration.getAttribute(TRACKING_IDS, trackingIds);
            for (String id : trackingIds) {
                HistoryTrackingConfiguration trackingConfig2 = id.equals("history") ? new HistoryTrackingConfiguration(id) : new TrackingConfiguration(id);
                try {
                    TRACKING_UTIL.load((TrackingConfiguration)trackingConfig2, configuration);
                    this.trackingList.add((Object)trackingConfig2);
                    if (!id.startsWith(CUSTOM_TRACKING_ID_PREFIX)) continue;
                    try {
                        int num = Integer.parseInt(id.substring(CUSTOM_TRACKING_ID_PREFIX.length()));
                        this.trackingMaxCustomId = Math.max(this.trackingMaxCustomId, num);
                    }
                    catch (Exception num) {}
                }
                catch (CoreException e) {
                    trackingIds.remove(id);
                    this.logReadingError(e);
                }
            }
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        if (!trackingIds.contains("history")) {
            trackingConfig = new HistoryTrackingConfiguration("history");
            trackingConfig.setName("History");
            trackingConfig.setFilePath("${session_startup_wd}/.Rhistory");
            this.trackingList.add((Object)trackingConfig);
        }
        if (!trackingIds.contains(TRANSCRIPT_TRACKING_ID)) {
            trackingConfig = new TrackingConfiguration(TRANSCRIPT_TRACKING_ID);
            trackingConfig.setName("Transcript");
            trackingConfig.setFilePath("${session_startup_wd}/${session_startup_date:yyyy-MM-dd HH-mm-ss}.Rtr");
            this.trackingList.add((Object)trackingConfig);
        }
        this.trackingEnabledSet.clear();
        List trackingEnabledIds = Collections.emptyList();
        try {
            trackingEnabledIds = configuration.getAttribute(TRACKING_ENABLED_IDS, Collections.EMPTY_LIST);
            IObservableList<TrackingConfiguration> trackingList = this.trackingList;
            for (TrackingConfiguration trackingConfig3 : trackingList) {
                if (!trackingEnabledIds.contains(trackingConfig3.getId())) continue;
                this.trackingEnabledSet.add((Object)trackingConfig3);
            }
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
    }

    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/console.pin", ((Boolean)this.pinValue.getValue()).booleanValue());
        Boolean enabled = (Boolean)this.rHelpByStatetValue.getValue();
        configuration.setAttribute(ATTR_INTEGRATION_RHELP_ENABLED, enabled.booleanValue());
        enabled = (Boolean)this.rGraphicsByStatetValue.getValue();
        configuration.setAttribute(ATTR_INTEGRATION_RGRAPHICS_ASDEFAULT, enabled.booleanValue());
        enabled = (Boolean)this.rDbgExtValue.getValue();
        configuration.setAttribute(ATTR_INTEGRATION_RDBGEXT_ENABLED, enabled.booleanValue());
        String startupSnippet = (String)this.startupSnippetValue.getValue();
        if (startupSnippet != null && startupSnippet.length() > 0) {
            configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/init.script.snippet", startupSnippet);
        } else {
            configuration.removeAttribute("org.eclipse.statet.r.debug/RConsole/init.script.snippet");
        }
        Boolean enabled2 = (Boolean)this.objectDBEnabledValue.getValue();
        configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.enabled", enabled2.booleanValue());
        enabled2 = (Boolean)this.objectDBAutoEnabledValue.getValue();
        configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.autorefresh.enabled", enabled2.booleanValue());
        Integer max = (Integer)this.objectDBListsChildrenValue.getValue();
        configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.lists.max_length", max.intValue());
        max = (Integer)this.objectDBEnvsChildrenValue.getValue();
        configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.envs.max_length", max.intValue());
        ArrayList<String> trackingIds = new ArrayList<String>(this.trackingList.size());
        IObservableList<TrackingConfiguration> trackingList = this.trackingList;
        for (TrackingConfiguration trackingConfig : trackingList) {
            String id = trackingConfig.getId();
            trackingIds.add(id);
            TRACKING_UTIL.save(trackingConfig, configuration);
        }
        configuration.setAttribute(TRACKING_IDS, trackingIds);
        ArrayList<String> trackingEnabledIds = new ArrayList<String>(this.trackingEnabledSet.size());
        IObservableSet<TrackingConfiguration> trackingEnabledSet = this.trackingEnabledSet;
        for (TrackingConfiguration trackingConfig : trackingEnabledSet) {
            String id = trackingConfig.getId();
            trackingEnabledIds.add(id);
        }
        configuration.setAttribute(TRACKING_ENABLED_IDS, trackingEnabledIds);
    }
}

