/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.runtime.core.ECommonsRuntimeCore;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.internal.r.core.RCoreAccess;
import org.eclipse.statet.internal.r.core.ResourceTracker;
import org.eclipse.statet.internal.r.core.pkgmanager.REnvPkgManager;
import org.eclipse.statet.internal.r.core.renv.REnvManagerImpl;
import org.eclipse.statet.internal.r.core.rhelp.WorkbenchRHelpHttpService;
import org.eclipse.statet.internal.r.core.rhelp.WorkbenchRHelpManager;
import org.eclipse.statet.internal.r.core.sourcemodel.RModelManager;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.r.core.IRCoreAccess;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.http.RHelpHttpService;
import org.eclipse.statet.rj.renv.core.REnv;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class RCorePlugin
extends Plugin {
    private static RCorePlugin instance;
    private boolean started;
    private final List<Disposable> disposables = new ArrayList<Disposable>();
    private REnvManagerImpl rEnvManager;
    private RCoreAccess workspaceCoreAccess;
    private RCoreAccess defaultsCoreAccess;
    private RModelManager rModelManager;
    private ResourceTracker resourceTracker;
    private REnvPkgManager rEnvPkgManager;
    private WorkbenchRHelpManager rHelpManager;
    private WorkbenchRHelpHttpService rHelpHttpService;
    private ServiceTracker proxyService;

    public static RCorePlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        RCorePlugin plugin = RCorePlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public static final void logError(String message, Throwable e) {
        RCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.core", message, e));
    }

    public static final void log(org.eclipse.statet.jcommons.status.Status status) {
        RCorePlugin.log(StatusUtils.convert((org.eclipse.statet.jcommons.status.Status)status));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        Assert.isNotNull(ECommonsRuntimeCore.class);
        this.rEnvManager = new REnvManagerImpl();
        this.workspaceCoreAccess = new RCoreAccess(PreferenceUtils.getInstancePrefs(), this.rEnvManager.getDefault());
        this.rModelManager = new RModelManager();
        this.resourceTracker = new ResourceTracker(this.rModelManager);
        this.rEnvPkgManager = new REnvPkgManager(this.rEnvManager);
        this.rHelpManager = new WorkbenchRHelpManager(this.rEnvManager);
        this.disposables.add(this.rHelpManager);
        this.rHelpHttpService = new WorkbenchRHelpHttpService(this.rHelpManager);
        this.disposables.add(this.rHelpHttpService);
        new PreloadRHelpJob().schedule(1000L);
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            RCorePlugin rCorePlugin = this;
            synchronized (rCorePlugin) {
                this.started = false;
            }
            if (this.resourceTracker != null) {
                try {
                    this.resourceTracker.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.resourceTracker = null;
            }
            if (this.rModelManager != null) {
                this.rModelManager.dispose();
                this.rModelManager = null;
            }
            if (this.workspaceCoreAccess != null) {
                this.workspaceCoreAccess.dispose();
                this.workspaceCoreAccess = null;
            }
            if (this.defaultsCoreAccess != null) {
                this.defaultsCoreAccess.dispose();
                this.defaultsCoreAccess = null;
            }
            if (this.rEnvManager != null) {
                this.rEnvManager.dispose();
                this.rEnvManager = null;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    RCorePlugin.logError("Error occured when dispose module", e);
                }
            }
            this.disposables.clear();
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    private void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
    }

    public REnvManagerImpl getREnvManager() {
        return this.rEnvManager;
    }

    public RModelManager getRModelManager() {
        return this.rModelManager;
    }

    public ResourceTracker getResourceTracker() {
        return this.resourceTracker;
    }

    public REnvPkgManager getREnvPkgManager() {
        return this.rEnvPkgManager;
    }

    public WorkbenchRHelpManager getRHelpManager() {
        return this.rHelpManager;
    }

    public RHelpHttpService getRHelpHttpService() {
        return this.rHelpHttpService;
    }

    public synchronized IRCoreAccess getWorkspaceRCoreAccess() {
        if (this.workspaceCoreAccess == null) {
            this.checkStarted();
        }
        return this.workspaceCoreAccess;
    }

    public synchronized IRCoreAccess getDefaultsRCoreAccess() {
        if (this.defaultsCoreAccess == null) {
            this.checkStarted();
            this.defaultsCoreAccess = new RCoreAccess(PreferenceUtils.getDefaultPrefs(), this.rEnvManager.getDefault());
        }
        return this.defaultsCoreAccess;
    }

    public synchronized IProxyService getProxyService() {
        if (this.proxyService == null) {
            this.checkStarted();
            this.proxyService = new ServiceTracker(this.getBundle().getBundleContext(), IProxyService.class.getName(), null);
            this.proxyService.open();
        }
        return (IProxyService)this.proxyService.getService();
    }

    private class PreloadRHelpJob
    extends Job {
        public PreloadRHelpJob() {
            super("Prepare R help");
            this.setSystem(true);
            this.setPriority(50);
        }

        protected IStatus run(IProgressMonitor monitor) {
            REnvHelp help;
            REnvManagerImpl rEnvManager = RCorePlugin.this.getREnvManager();
            if (rEnvManager == null) {
                return Status.CANCEL_STATUS;
            }
            REnv rEnv = rEnvManager.getDefault().resolve();
            if (rEnv != null && (help = RCorePlugin.this.getRHelpManager().getHelp(rEnv)) != null) {
                help.unlock();
            }
            RCorePlugin.this.getRHelpHttpService().ensureIsRunning();
            return Status.OK_STATUS;
        }
    }
}

