/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.refactoring.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.model.core.ISourceUnitManager;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.RProjects;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRFrameInSource;
import org.eclipse.statet.r.core.model.IRModelInfo;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RModel;

public class RElementSearchProcessor {
    public static final int WARN_NO_DEFINITION = 65536;
    public static final int WARN_MULTIPLE_DEFINITION = 131072;
    public static final int ALLOW_SUB_NAMEDPART = 4096;
    private static ImList<Mode> MODES_LOCAL = ImCollections.newList((Object)((Object)Mode.LOCAL_FRAME));
    private static ImList<Mode> MODES_GLOBAL = ImCollections.newList((Object[])new Mode[]{Mode.WORKSPACE, Mode.CURRENT_AND_REFERENCING_PROJECTS, Mode.CURRENT_PROJECT, Mode.CURRENT_FILE});
    private static ImList<Mode> MODES_FILE = ImCollections.newList((Object)((Object)Mode.CURRENT_FILE));
    private final IRSourceUnit initialSourceUnit;
    private List<Mode> availableModes;
    private Mode mode;
    protected final RElementName name;
    protected final RElementName mainName;
    protected final RElementName scope;
    protected final String scopeFrameId;
    private final int flags;
    private final List<RProject> allProjects = new ArrayList<RProject>();
    private final List<List<ISourceUnit>> allProjectsSourceUnits = new ArrayList<List<ISourceUnit>>();
    protected final List<RProject> definitionProjects = new ArrayList<RProject>();
    protected final Set<String> definitionFrameIds = new HashSet<String>();
    protected final List<RProject> matchProjects = new ArrayList<RProject>();
    private IStatus status;

    protected static final String createPackageFrameId(String packageName) {
        return "package:" + packageName;
    }

    public RElementSearchProcessor(RElementName name, IRSourceUnit sourceUnit, RElementAccess mainAccess, Mode mode, int flags) {
        this.initialSourceUnit = sourceUnit;
        this.mode = mode;
        this.flags = flags;
        this.name = name;
        this.status = Status.OK_STATUS;
        this.validateName();
        if (this.status.getSeverity() < 4) {
            this.init(mainAccess);
        }
        if (this.status.getSeverity() < 4) {
            this.mainName = RElementName.cloneSegment(mainAccess);
            this.scope = mainAccess.getScope() != null ? RElementName.cloneSegment(mainAccess.getScope()) : null;
            this.scopeFrameId = this.scope != null && RElementName.isPackageFacetScopeType(this.scope.getType()) ? RElementSearchProcessor.createPackageFrameId(this.scope.getSegmentName()) : null;
        } else {
            this.mainName = null;
            this.scope = null;
            this.scopeFrameId = null;
        }
    }

    protected void validateName() {
        if (this.name == null) {
            this.addStatus(4, "The operation is unavailable on the current selection.");
            return;
        }
        RElementName nameSegment = this.name;
        do {
            if (nameSegment.getSegmentName() != null) continue;
            this.addStatus(4, "The operation is unavailable on the current selection (invalid name).");
            break;
        } while ((nameSegment = nameSegment.getNextSegment()) != null);
        nameSegment = this.name.getNextSegment();
        block4: while (nameSegment != null) {
            switch (nameSegment.getType()) {
                case 26: {
                    if ((this.flags & 0x1000) != 0) break;
                    this.addStatus(4, "The operation is unavailable on the current selection (sub element).");
                    break block4;
                }
                default: {
                    this.addStatus(4, "The operation is unavailable on the current selection (unsupported sub element).");
                    break block4;
                }
            }
            nameSegment = nameSegment.getNextSegment();
        }
    }

    protected void init(RElementAccess access) {
        if (access == null) {
            throw new NullPointerException("elementAccess");
        }
        RElementName subName = this.name;
        RElementAccess subAccess = access;
        do {
            if (subAccess == null || !subName.getSegmentName().equals(subAccess.getSegmentName())) {
                throw new IllegalArgumentException("elementAccess does not match to elementName");
            }
            subName = subName.getNextSegment();
            subAccess = subAccess.getNextSegment();
        } while (subName != null);
        if (access.getType() != 17) {
            this.addStatus(4, "The operation is unavailable on the current selection.");
            return;
        }
        if (access.getSegmentName() == null || access.getSegmentName().isEmpty()) {
            this.addStatus(4, "The operation is unavailable on the current selection.");
            return;
        }
        this.availableModes = this.getAvailableModes(access);
        if (this.mode != null) {
            if (!this.availableModes.contains((Object)this.mode)) {
                this.mode = this.availableModes.get(0);
                this.status = new Status(2, "org.eclipse.statet.r.core", NLS.bind((String)"Scope changed to: ''{0}''.", (Object)((Object)this.mode)));
            }
        } else {
            this.mode = this.availableModes.get(0);
        }
    }

    public IRSourceUnit getInitialSourceUnit() {
        return this.initialSourceUnit;
    }

    public IStatus getStatus() {
        return this.status;
    }

    protected List<Mode> getAvailableModes(RElementAccess access) {
        IRFrame frame = access.getFrame();
        if (frame == null || frame.getFrameType() != 2 && frame.getFrameType() != 1) {
            return MODES_LOCAL;
        }
        if (this.getInitialRProject() == null) {
            return MODES_FILE;
        }
        return MODES_GLOBAL;
    }

    public List<Mode> getAvailableModes() {
        return this.availableModes;
    }

    public void setMode(Mode mode) {
        if (!this.getAvailableModes().contains((Object)mode)) {
            throw new IllegalArgumentException("mode");
        }
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getModeLabel() {
        switch (this.mode) {
            case WORKSPACE: {
                return "workspace";
            }
            case CURRENT_AND_REFERENCING_PROJECTS: {
                return NLS.bind((String)"project ''{0}'' and referencing projects", (Object)this.getInitialProjectName());
            }
            case CURRENT_PROJECT: {
                return NLS.bind((String)"project ''{0}''", (Object)this.getInitialProjectName());
            }
            case CURRENT_FILE: {
                return NLS.bind((String)"file ''{0}''", (Object)this.initialSourceUnit.getElementName().getDisplayName());
            }
            case LOCAL_FRAME: {
                return "local frame";
            }
        }
        return "";
    }

    private IProject getInitialProject() {
        Object resource = this.initialSourceUnit.getResource();
        return resource instanceof IResource ? ((IResource)resource).getProject() : null;
    }

    private String getInitialProjectName() {
        IProject project = this.getInitialProject();
        return project != null ? project.getName() : "-";
    }

    private RProject getInitialRProject() {
        IProject project = this.getInitialProject();
        return project != null ? RProjects.getRProject(project) : null;
    }

    protected void addStatus(int severity, String message) {
        this.status = new Status(severity, "org.eclipse.statet.r.core", message);
    }

    public RElementName getElementName() {
        return this.name;
    }

    protected void clear() {
        this.allProjects.clear();
        this.allProjectsSourceUnits.clear();
        this.definitionProjects.clear();
        this.definitionFrameIds.clear();
        this.matchProjects.clear();
    }

    /*
     * Unable to fully structure code
     */
    public void run(SubMonitor m) throws CoreException {
        if (this.status.getSeverity() >= 4) {
            throw new IllegalStateException();
        }
        m.beginTask(this.getTaskName(), 100);
        this.clear();
        this.begin(m);
        try {
            try {
                block41: {
                    this.definitionFrameIds.add(null);
                    if (this.scopeFrameId != null) {
                        this.definitionFrameIds.add(this.scopeFrameId);
                    }
                    initialProject = this.getInitialRProject();
                    this.allProjects.add(initialProject);
                    if (initialProject != null && this.getMode().compareTo(Mode.CURRENT_PROJECT) <= 0) {
                        sus = this.loadSus(initialProject, this.allProjectsSourceUnits, true, m.newChild(2));
                        sus.add(this.initialSourceUnit);
                    } else {
                        this.initialSourceUnit.connect((IProgressMonitor)m.newChild(1));
                        this.allProjectsSourceUnits.add(Collections.singletonList(this.initialSourceUnit));
                    }
                    m.worked(1);
                    if (m.isCanceled()) {
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                    m.setWorkRemaining(90);
                    if (this.getMode().compareTo(Mode.CURRENT_PROJECT) > 0) break block41;
                    m1 = m.newChild(40);
                    i = 0;
                    while (i < this.allProjects.size()) {
                        block42: {
                            block43: {
                                m1.setWorkRemaining((this.allProjects.size() - i) * 4);
                                project = this.allProjects.get(i);
                                if (project == null) break block42;
                                if (m1.isCanceled()) {
                                    throw new CoreException(Status.CANCEL_STATUS);
                                }
                                if (i < this.allProjectsSourceUnits.size()) {
                                    sus = this.allProjectsSourceUnits.get(i);
                                    m1.worked(1);
                                } else {
                                    sus = this.loadSus(project, this.allProjectsSourceUnits, false, m1.newChild(2));
                                }
                                if (sus == null) break block42;
                                found = this.searchDefinition(project, sus, m1.newChild(2));
                                if (found <= 0) break block43;
                                this.definitionProjects.add(project);
                                if (this.scopeFrameId == null && (packageName = project.getPkgName()) != null) {
                                    this.definitionFrameIds.add(RElementSearchProcessor.createPackageFrameId(packageName));
                                }
                                if (found == 2) break block42;
                            }
                            if (this.getMode() == Mode.WORKSPACE) {
                                this.addReferencedProjects(project, this.allProjects);
                            }
                        }
                        ++i;
                    }
                }
                if (this.getMode() == Mode.WORKSPACE) {
                    if (this.definitionProjects.isEmpty()) {
                        if ((this.flags & 65536) != 0) {
                            this.addStatus(2, Messages.RenameInWorkspace_warning_NoDefinition_message);
                        }
                    } else if (this.definitionProjects.size() > 1 && (this.flags & 65536) != 0) {
                        this.addStatus(2, Messages.RenameInWorkspace_warning_MultipleDefinitions_message);
                    }
                }
                if (!this.definitionProjects.isEmpty()) {
                    this.matchProjects.addAll(this.definitionProjects);
                } else {
                    i = 0;
                    while (i < this.allProjects.size()) {
                        if (this.allProjectsSourceUnits.get(i) != null && (project = this.allProjects.get(i)) != null) {
                            this.matchProjects.add(project);
                        }
                        ++i;
                    }
                }
                m.worked(4);
                if (m.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                this.beginFinalProcessing(m);
                if (this.matchProjects.isEmpty() && this.getMode() == Mode.CURRENT_FILE) {
                    sus = new ArrayList<ISourceUnit>();
                    sus.add(this.initialSourceUnit);
                    this.process(null, sus, m.newChild(40));
                }
                m1 = m.newChild(40);
                i = 0;
                while (i < this.matchProjects.size()) {
                    m1.setWorkRemaining((this.matchProjects.size() - i) * 11);
                    project = this.matchProjects.get(i);
                    idx = this.allProjects.indexOf(project);
                    if (m1.isCanceled()) {
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                    if (idx >= 0) {
                        sus = this.allProjectsSourceUnits.get(idx);
                    } else {
                        this.allProjects.add(project);
                        idx = this.allProjectsSourceUnits.size();
                        sus = this.loadSus(project, this.allProjectsSourceUnits, false, m1.newChild(2));
                    }
                    this.process(project, sus, m1.newChild(8));
                    switch (RElementSearchProcessor.$SWITCH_TABLE$org$eclipse$statet$r$core$refactoring$RElementSearchProcessor$Mode()[this.getMode().ordinal()]) {
                        case 1: 
                        case 2: {
                            this.addReferencingProjects(project, this.matchProjects);
                            break;
                        }
                    }
                    if (sus != null) {
                        this.allProjectsSourceUnits.set(idx, null);
                        this.closeSus(sus, m1.newChild(1));
                    }
                    ++i;
                }
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", "Unexpected error (concurrent change?)", (Throwable)e));
            }
        }
        finally {
            i = 0;
            ** while (i < this.allProjectsSourceUnits.size())
        }
lbl-1000:
        // 1 sources

        {
            sus = this.allProjectsSourceUnits.get(i);
            if (sus != null) {
                m.setWorkRemaining(this.allProjectsSourceUnits.size() - i);
                this.closeSus(sus, m.newChild(1));
            }
            ++i;
            continue;
        }
lbl128:
        // 1 sources

    }

    private void closeSus(List<ISourceUnit> sus, SubMonitor m) {
        m.setWorkRemaining(sus.size());
        for (ISourceUnit su : sus) {
            try {
                su.disconnect((IProgressMonitor)m.newChild(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addReferencedProjects(RProject initialProject, List<RProject> projects) throws CoreException {
        IProject[] referencedProjects;
        IProject[] iProjectArray = referencedProjects = initialProject.getProject().getReferencedProjects();
        int n = referencedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            RProject project;
            IProject referencedProject = iProjectArray[n2];
            if (referencedProject.isOpen() && (project = RProjects.getRProject(referencedProject)) != null && !projects.contains(project)) {
                projects.add(project);
            }
            ++n2;
        }
    }

    private void addReferencingProjects(RProject initialProject, List<RProject> projects) throws CoreException {
        IProject[] referencedProjects;
        IProject[] iProjectArray = referencedProjects = initialProject.getProject().getReferencingProjects();
        int n = referencedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            RProject project;
            IProject referencedProject = iProjectArray[n2];
            if (referencedProject.isOpen() && (project = RProjects.getRProject(referencedProject)) != null && !projects.contains(project)) {
                projects.add(project);
            }
            ++n2;
        }
    }

    private List<ISourceUnit> loadSus(RProject project, List<List<ISourceUnit>> projectsSus, boolean force, SubMonitor m) throws CoreException {
        m.setWorkRemaining(20);
        ISourceUnitManager suManager = LTK.getSourceUnitManager();
        List<ISourceUnit> sourceUnits = RModel.getRModelManager().findReferencingSourceUnits(project, this.mainName, (IProgressMonitor)m.newChild(10));
        if (sourceUnits == null && force) {
            sourceUnits = new ArrayList<ISourceUnit>(1);
        }
        if (sourceUnits != null) {
            projectsSus.add(sourceUnits);
            int workRemaining = sourceUnits.size();
            int i = 0;
            while (i < sourceUnits.size()) {
                m.setWorkRemaining(workRemaining--);
                ISourceUnit sourceUnit = sourceUnits.get(i);
                if (sourceUnit.getId().equals(this.initialSourceUnit.getId())) {
                    sourceUnits.remove(i--);
                } else {
                    try {
                        ISourceUnit editUnit = suManager.getSourceUnit(LTK.EDITOR_CONTEXT, (Object)sourceUnit, null, true, (IProgressMonitor)m.newChild(1));
                        if (editUnit != null) {
                            sourceUnits.set(i, editUnit);
                        }
                    }
                    catch (Throwable e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", 1, NLS.bind((String)"An error occurred when looking for ''{0}''.", (Object)sourceUnit.getId()), e));
                    }
                }
                ++i;
            }
            return sourceUnits;
        }
        projectsSus.add(null);
        return null;
    }

    private int searchDefinition(RProject project, List<ISourceUnit> sus, SubMonitor m) {
        String packageName = project.getPkgName();
        if (this.scopeFrameId != null && packageName != null && this.scopeFrameId.equals(RElementSearchProcessor.createPackageFrameId(packageName))) {
            m.setWorkRemaining(sus.size() * 2);
            for (ISourceUnit su : sus) {
                this.searchDefinition(su, null, m.newChild(1));
                this.searchDefinition(su, this.scopeFrameId, m.newChild(1));
            }
            return 2;
        }
        m.setWorkRemaining(sus.size());
        boolean found = false;
        for (ISourceUnit su : sus) {
            found |= this.searchDefinition(su, this.scopeFrameId, m.newChild(1));
        }
        return found ? 1 : 0;
    }

    private boolean searchDefinition(ISourceUnit su, String specificFrameId, SubMonitor m) {
        m.setWorkRemaining(6);
        su.connect((IProgressMonitor)m.newChild(1));
        try {
            ImList<? extends RElementAccess> allAccess;
            IRModelInfo modelInfo = (IRModelInfo)su.getModelInfo("R", 2, (IProgressMonitor)m.newChild(2));
            if (modelInfo == null) {
                return false;
            }
            IRFrame frame = specificFrameId == null ? modelInfo.getTopFrame() : modelInfo.getReferencedFrames().get(specificFrameId);
            if (frame instanceof IRFrameInSource && (allAccess = frame.getAllAccessOf(this.mainName.getSegmentName(), false)) != null) {
                for (RElementAccess access : allAccess) {
                    if (!access.isWriteAccess() || access.getNextSegment() != null) continue;
                    return true;
                }
            }
            return false;
        }
        finally {
            m.setWorkRemaining(1);
            su.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    protected String getTaskName() {
        return NLS.bind((String)Messages.SearchProcessor_label, (Object)this.name.getDisplayName());
    }

    protected void begin(SubMonitor m) {
    }

    protected void beginFinalProcessing(SubMonitor m) {
    }

    protected void process(RProject project, List<ISourceUnit> sus, SubMonitor m) throws BadLocationException {
    }

    protected RElementAccess searchMatch(RElementAccess access) {
        RElementName nameSegment = this.name.getNextSegment();
        while (nameSegment != null) {
            if ((access = access.getNextSegment()) == null || nameSegment.getType() != access.getType() || !nameSegment.getSegmentName().equals(access.getSegmentName())) {
                return null;
            }
            nameSegment = nameSegment.getNextSegment();
        }
        return access;
    }

    public static enum Mode {
        WORKSPACE(Messages.SearchScope_Workspace_label),
        CURRENT_AND_REFERENCING_PROJECTS(Messages.SearchScope_CurrentAndReferencingProjects_label),
        CURRENT_PROJECT(Messages.SearchScope_CurrentProject_label),
        CURRENT_FILE(Messages.SearchScope_CurrentFile_label),
        LOCAL_FRAME(Messages.SearchScope_LocalFrame_label);

        private final String label;

        private Mode(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

