/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.refactoring.Messages;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringDescriptor;
import org.eclipse.statet.ltk.refactoring.core.RefactoringChange;
import org.eclipse.statet.ltk.refactoring.core.RefactoringMessages;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;
import org.eclipse.statet.ltk.refactoring.core.TextChangeCompatibility;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRFrameInSource;
import org.eclipse.statet.r.core.model.IRModelInfo;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.GenericVisitor;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAst;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameInRegionRefactoring
extends Refactoring {
    private final RRefactoringAdapter adapter = new RRefactoringAdapter();
    private final ElementSet elementSet;
    private TextRegion selectionRegion;
    private final IRSourceUnit sourceUnit;
    private Map<IRFrame, Map<String, Variable>> variablesList;

    public RenameInRegionRefactoring(IRSourceUnit su, TextRegion region) {
        this.sourceUnit = su;
        this.elementSet = new ElementSet(new Object[]{su});
        if (region != null && region.getStartOffset() >= 0 && region.getLength() >= 0) {
            this.selectionRegion = region;
        }
    }

    public String getName() {
        return Messages.RenameInRegion_label;
    }

    public String getIdentifier() {
        return "org.eclipse.statet.r.refactoring.RenameInRegionOperation";
    }

    public Map<IRFrame, Map<String, Variable>> getVariables() {
        return this.variablesList;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        RAstNode rootNode = null;
        try {
            if (this.selectionRegion != null) {
                this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
                try {
                    AbstractDocument document = this.sourceUnit.getDocument(monitor);
                    RHeuristicTokenScanner scanner = this.adapter.getScanner(this.sourceUnit);
                    IRModelInfo modelInfo = (IRModelInfo)this.sourceUnit.getModelInfo("R", 2, (IProgressMonitor)m.newChild(1));
                    if (modelInfo != null) {
                        TextRegion region = this.adapter.trimToAstRegion(document, this.selectionRegion, scanner);
                        AstInfo ast = modelInfo.getAst();
                        if (ast != null) {
                            rootNode = (RAstNode)AstSelection.search((AstNode)ast.getRoot(), (int)region.getStartOffset(), (int)region.getEndOffset(), (int)3).getCovering();
                        }
                    }
                }
                finally {
                    this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
                }
            }
            if (rootNode == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractTemp_error_InvalidSelection_message);
                return refactoringStatus;
            }
            RefactoringStatus result = new RefactoringStatus();
            this.adapter.checkInitialToModify(result, this.elementSet);
            m.worked(1);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.searchVariables(rootNode, result);
            m.worked(2);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    private void searchVariables(RAstNode rootNode, RefactoringStatus result) {
        this.variablesList = new HashMap<IRFrame, Map<String, Variable>>();
        VariableSearcher searcher = new VariableSearcher();
        try {
            rootNode.acceptInR(searcher);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        for (Map<String, Variable> map : this.variablesList.values()) {
            for (Variable var : map.values()) {
                this.checkVariables(var);
            }
        }
    }

    private void checkVariables(Variable var) {
        HashMap<String, Variable> map = null;
        for (RElementAccess access : var.accessList) {
            Variable sub;
            RElementAccess next = access.getNextSegment();
            if (next == null || next.getSegmentName() == null || next.getType() != 26 && next.getType() != 25) continue;
            if (map == null) {
                map = new HashMap<String, Variable>();
            }
            if ((sub = (Variable)map.get(next.getSegmentName())) == null) {
                sub = new Variable(var, next.getSegmentName());
                map.put(next.getSegmentName(), sub);
            }
            next.getSegmentName();
            next.getFrame();
            sub.accessList.add(next);
        }
        if (map != null) {
            var.subVariables = map;
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_FinalCheck_label, (int)3);
        try {
            RefactoringStatus status = new RefactoringStatus();
            this.adapter.checkFinalToModify(status, this.elementSet, (IProgressMonitor)m.newChild(2));
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_CreateChanges_label, (int)3);
        try {
            SourceUnitChange textFileChange = new SourceUnitChange((ISourceUnit)this.sourceUnit);
            if (this.sourceUnit.getWorkingContext() == LTK.EDITOR_CONTEXT) {
                textFileChange.setSaveMode(4);
            }
            List<String> variableNames = this.createChanges((TextFileChange)textFileChange, m.newChild(2));
            HashMap arguments = new HashMap();
            String description = NLS.bind((String)Messages.RenameInRegion_Descriptor_description, (Object)RUtil.formatVarNames(variableNames));
            IProject resource = this.elementSet.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? NLS.bind((String)RefactoringMessages.Common_Source_Project_label, (Object)project) : RefactoringMessages.Common_Source_Workspace_label;
            boolean flags = false;
            String comment = "";
            CommonRefactoringDescriptor descriptor = new CommonRefactoringDescriptor(this.getIdentifier(), project, description, "", arguments, 0);
            m.worked(1);
            RefactoringChange refactoringChange = new RefactoringChange((RefactoringDescriptor)descriptor, Messages.RenameInRegion_label, new Change[]{textFileChange});
            return refactoringChange;
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", "Unexpected error (concurrent change?)", (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    private List<String> createChanges(TextFileChange change, SubMonitor m) throws BadLocationException {
        m.setWorkRemaining(10);
        ArrayList<String> names = new ArrayList<String>();
        this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
        try {
            SubMonitor m1 = m.newChild(8).setWorkRemaining(this.variablesList.size());
            for (Map<String, Variable> frameList : this.variablesList.values()) {
                this.createMainChanges(frameList, change, names);
                m1.worked(1);
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        finally {
            this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    private void createMainChanges(Map<String, Variable> frameList, TextFileChange change, List<String> names) {
        for (Variable variable : frameList.values()) {
            if (variable.newName != null) {
                String oldName = RRefactoringAdapter.getUnquotedIdentifier(variable.name);
                String oldMsgName = RUtil.formatVarName(oldName);
                boolean isQuoted = variable.newName.charAt(0) == '`';
                GroupCategorySet set = new GroupCategorySet(new GroupCategory(String.valueOf(((IRFrameInSource)variable.getParent()).getFrameId()) + '$' + variable.name, NLS.bind((String)Messages.RenameInRegion_Changes_VariableGroup_name, (Object)oldMsgName), ""));
                String message = NLS.bind((String)Messages.RenameInRegion_Changes_ReplaceOccurrence_name, (Object)oldMsgName);
                for (RElementAccess access : variable.accessList) {
                    RAstNode nameNode = access.getNameNode();
                    if (nameNode == null) continue;
                    String text = isQuoted && nameNode.getNodeType() == NodeType.SYMBOL && nameNode.getOperator(0) == RTerminal.SYMBOL ? variable.newName : RRefactoringAdapter.getUnquotedIdentifier(variable.newName);
                    TextRegion nameRegion = RAst.getElementNameRegion(nameNode);
                    TextChangeCompatibility.addTextEdit((TextChange)change, (String)message, (TextEdit)new ReplaceEdit(nameRegion.getStartOffset(), nameRegion.getLength(), text), (GroupCategorySet)set);
                }
                names.add(oldName);
            }
            if (variable.subVariables.isEmpty()) continue;
            this.createSubChanges(variable, change, names);
        }
    }

    private void createSubChanges(Variable parent, TextFileChange change, List<String> names) {
        String parentMsgName = RUtil.formatVarName(RRefactoringAdapter.getUnquotedIdentifier(parent.name));
        for (Variable variable : parent.subVariables.values()) {
            if (variable.newName == null) continue;
            String oldName = RRefactoringAdapter.getUnquotedIdentifier(variable.name);
            String oldMsgName = RUtil.formatVarName(oldName);
            boolean isQuoted = variable.newName.charAt(0) == '`';
            GroupCategorySet set = new GroupCategorySet(new GroupCategory(String.valueOf(((IRFrameInSource)parent.getParent()).getFrameId()) + '$' + parent.name, NLS.bind((String)Messages.RenameInRegion_Changes_VariableGroup_name, (Object)parentMsgName), ""));
            String message = NLS.bind((String)Messages.RenameInRegion_Changes_ReplaceOccurrenceOf_name, (Object)oldMsgName, (Object)parentMsgName);
            for (RElementAccess access : variable.accessList) {
                RAstNode nameNode = access.getNameNode();
                if (nameNode == null) continue;
                String text = isQuoted && nameNode.getNodeType() == NodeType.SYMBOL && nameNode.getOperator(0) == RTerminal.SYMBOL ? variable.newName : RRefactoringAdapter.getUnquotedIdentifier(variable.newName);
                TextRegion nameRegion = RAst.getElementNameRegion(nameNode);
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)message, (TextEdit)new ReplaceEdit(nameRegion.getStartOffset(), nameRegion.getLength(), text), (GroupCategorySet)set);
            }
            names.add(oldName);
        }
    }

    public class Variable {
        private final Object parent;
        private final String name;
        private String newName;
        private final List<RElementAccess> accessList;
        private Map<String, Variable> subVariables = Collections.emptyMap();

        public Variable(Object parent, String name) {
            this.parent = parent;
            this.name = name;
            this.accessList = new ArrayList<RElementAccess>();
        }

        public Object getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        public String getNewName() {
            return this.newName;
        }

        public void setNewName(String name) {
            this.newName = !this.name.equals(name) ? name : null;
        }

        public int getOccurrencesCount() {
            return this.accessList.size();
        }

        public Map<String, Variable> getSubVariables() {
            return this.subVariables;
        }
    }

    private class VariableSearcher
    extends GenericVisitor {
        private final int start;
        private final int stop;

        private VariableSearcher() {
            this.start = RenameInRegionRefactoring.this.selectionRegion.getStartOffset();
            this.stop = RenameInRegionRefactoring.this.selectionRegion.getEndOffset();
        }

        @Override
        public void visitNode(RAstNode node) throws InvocationTargetException {
            if (node.getStartOffset() >= this.stop || node.getEndOffset() < this.start) {
                return;
            }
            ImList attachments = node.getAttachments();
            for (Object attachment : attachments) {
                RAstNode nameNode;
                RElementAccess access;
                if (!(attachment instanceof RElementAccess) || (access = (RElementAccess)attachment).getType() != 17 || (nameNode = access.getNameNode()) == null || nameNode.getStartOffset() < this.start || nameNode.getEndOffset() > this.stop) continue;
                this.add(access);
            }
            node.acceptInRChildren(this);
        }

        private void add(RElementAccess access) {
            String name;
            Variable variable;
            IRFrame frame = access.getFrame();
            if (!(frame instanceof IRFrameInSource) || frame.getFrameType() == 2) {
                return;
            }
            HashMap<String, Variable> map = (HashMap<String, Variable>)RenameInRegionRefactoring.this.variablesList.get(frame);
            if (map == null) {
                map = new HashMap<String, Variable>();
                RenameInRegionRefactoring.this.variablesList.put(frame, map);
            }
            if ((variable = (Variable)map.get(name = access.getSegmentName())) == null) {
                variable = new Variable(frame, name);
                map.put(name, variable);
            }
            variable.accessList.add(access);
        }
    }
}

