/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.ltk.ui.sourceediting.EditorTextInfoHoverProxy;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverDescriptor;
import org.eclipse.statet.r.core.source.IRDocumentConstants;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.editors.IRSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;

public class REditorTextHover
extends EditorTextInfoHoverProxy {
    private RHeuristicTokenScanner scanner;

    public REditorTextHover(IRSourceEditor editor, InfoHoverDescriptor descriptor, SourceEditorViewerConfiguration config) {
        super(descriptor, config);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (this.scanner == null) {
            this.scanner = RHeuristicTokenScanner.create((IDocContentSections)this.getEditor().getDocumentContentInfo());
        }
        try {
            ITypedRegion partition;
            ITypedRegion partition2;
            IDocument document = this.getEditor().getViewer().getDocument();
            this.scanner.configure(document);
            IRegion word = this.scanner.findRWord(offset, false, true);
            if (word != null && (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches((partition2 = this.scanner.getPartition(word.getOffset())).getType()) || partition2.getType() == "R.String" || partition2.getType() == "R.QuotedSymbol")) {
                return word;
            }
            char c = document.getChar(offset);
            if (c == '[' && IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches((partition = this.scanner.getPartition(offset)).getType())) {
                return new Region(offset, 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected AssistInvocationContext createContext(IRegion region, String contentType, IProgressMonitor monitor) {
        RAssistInvocationContext context = new RAssistInvocationContext((IRSourceEditor)this.getEditor(), region, contentType, this.scanner, monitor);
        if (context.getAstInfo() == null) {
            return null;
        }
        return context;
    }
}

