/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.HandlerCollection;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.RUIMessages;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.editors.REditor;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.ui.ElementNameComparator;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1OutlinePage;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor2OutlinePage;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.refactoring.RRefactoring;
import org.eclipse.statet.r.ui.RLabelProvider;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.IServiceLocator;

public class ROutlinePage
extends SourceEditor2OutlinePage {
    private static final ViewerComparator ALPHA_COMPARATOR = new ElementNameComparator(RElementName.NAMEONLY_COMPARATOR);
    private final ContentFilter fFilter = new ContentFilter();

    public ROutlinePage(REditor editor) {
        super((SourceEditor1)editor, "R", RRefactoring.getFactory(), "org.eclipse.statet.r.menus.ROutlineViewContextMenu");
    }

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((AbstractUIPlugin)RUIPlugin.getInstance(), (String)"ROutlineView");
    }

    protected IModelElement.Filter getContentFilter() {
        return this.fFilter;
    }

    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new RLabelProvider());
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        super.contributeToActionBars(serviceLocator, actionBars, handlers);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.appendToGroup("view.sort", (IAction)new AlphaSortAction());
        toolBarManager.appendToGroup("view.filter", (IAction)new FilterCommonVariables());
        toolBarManager.appendToGroup("view.filter", (IAction)new FilterLocalDefinitions());
    }

    protected void contextMenuAboutToShow(IMenuManager m) {
        super.contextMenuAboutToShow(m);
        IPageSite site = this.getSite();
        if (m.find("stat.submit") == null) {
            m.insertBefore("additions", (IContributionItem)new Separator("stat.submit"));
        }
        m.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.r.commands.SubmitSelectionToR", null, null, null, null, null, "R", null, 8, null, false)));
        m.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.r.commands.SubmitUptoSelectionToR", null, null, null, null, null, "U", null, 8, null, false)));
        m.add((IContributionItem)new Separator("more"));
    }

    private class AlphaSortAction
    extends SourceEditor1OutlinePage.ToggleAction {
        public AlphaSortAction() {
            super((SourceEditor1OutlinePage)ROutlinePage.this, "sort.alphabetically.enabled", false, 2);
            this.setText(SharedMessages.ToggleSortAction_name);
            this.setImageDescriptor(SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctool/sort.alpha"));
            this.setToolTipText(SharedMessages.ToggleSortAction_tooltip);
        }

        protected void configure(boolean on) {
            TreeViewer viewer = ROutlinePage.this.getViewer();
            if (UIAccess.isOkToUse((Viewer)viewer)) {
                viewer.setComparator((ViewerComparator)(on ? ALPHA_COMPARATOR : null));
            }
        }
    }

    private class ContentFilter
    implements IModelElement.Filter {
        private boolean hideCommonVariables;
        private boolean hideLocalDefinitions;

        private ContentFilter() {
        }

        public boolean include(IModelElement element) {
            switch (element.getElementType()) {
                case 1585: {
                    return false;
                }
                case 1552: {
                    return !this.hideCommonVariables;
                }
                case 1553: {
                    return !this.hideCommonVariables && !this.hideLocalDefinitions;
                }
                case 1297: {
                    return !this.hideLocalDefinitions;
                }
            }
            return true;
        }
    }

    private class FilterCommonVariables
    extends SourceEditor1OutlinePage.ToggleAction {
        public FilterCommonVariables() {
            super((SourceEditor1OutlinePage)ROutlinePage.this, "filter.common_var.enabled", false, 2);
            this.setText(RUIMessages.Outline_HideGeneralVariables_name);
            this.setImageDescriptor(RUI.getImageDescriptor("org.eclipse.statet.r.ui/image/ltool/filter.general"));
            this.setToolTipText(RUIMessages.Outline_HideGeneralVariables_name);
        }

        protected void configure(boolean on) {
            TreeViewer viewer = ROutlinePage.this.getViewer();
            ROutlinePage.this.fFilter.hideCommonVariables = on;
            if (UIAccess.isOkToUse((Viewer)viewer)) {
                viewer.refresh(false);
            }
        }
    }

    private class FilterLocalDefinitions
    extends SourceEditor1OutlinePage.ToggleAction {
        public FilterLocalDefinitions() {
            super((SourceEditor1OutlinePage)ROutlinePage.this, "filter.local.enabled", false, 2);
            this.setText(RUIMessages.Outline_HideLocalElements_name);
            this.setImageDescriptor(RUI.getImageDescriptor("org.eclipse.statet.r.ui/image/ltool/filter.local"));
            this.setToolTipText(RUIMessages.Outline_HideLocalElements_name);
        }

        protected void configure(boolean on) {
            TreeViewer viewer = ROutlinePage.this.getViewer();
            ROutlinePage.this.fFilter.hideLocalDefinitions = on;
            if (UIAccess.isOkToUse((Viewer)viewer)) {
                viewer.refresh(false);
            }
        }
    }
}

