/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.internal.r.ui.editors.RElementCompletionProposal;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SimpleCompletionProposal;
import org.eclipse.statet.r.core.RSymbolComparator;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public class RSimpleCompletionProposal
extends SimpleCompletionProposal {
    public RSimpleCompletionProposal(RAssistInvocationContext context, String replacementString, int replacementOffset) {
        super((AssistInvocationContext)context, replacementString, replacementOffset);
    }

    protected String getPluginId() {
        return "org.eclipse.statet.r.ui";
    }

    protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) {
        int end = Math.max(caretOffset, selection.x + selection.y);
        if (overwrite) {
            RElementCompletionProposal.ApplyData data = new RElementCompletionProposal.ApplyData((RAssistInvocationContext)this.getInvocationContext());
            RHeuristicTokenScanner scanner = data.getScanner();
            scanner.configure(data.getDocument());
            IRegion word = scanner.findRWord(end, false, true);
            if (word != null) {
                return word.getOffset() + word.getLength() - replacementOffset;
            }
        }
        return end - replacementOffset;
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            String replacement;
            String prefix;
            int start = this.getReplacementOffset();
            int length = offset - this.getReplacementOffset();
            if (length > 0 && document.getChar(start) == '`') {
                ++start;
                --length;
            }
            if (length > 0 && document.getChar(start + length - 1) == '`') {
                --length;
            }
            if (new RSymbolComparator.PrefixPattern(prefix = document.get(start, length)).matches(replacement = this.getReplacementString())) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public static class RHelpTopicCompletionProposal
    extends RSimpleCompletionProposal
    implements ICompletionProposalExtension6 {
        private final int relevance;
        private final String packages;

        public RHelpTopicCompletionProposal(RAssistInvocationContext context, String replacementString, String packages, int replacementOffset, int relevance) {
            super(context, replacementString, replacementOffset);
            this.relevance = relevance;
            this.packages = packages;
        }

        public int getRelevance() {
            return this.relevance;
        }

        public Image getImage() {
            return RUI.getImage("org.eclipse.statet.r.ui/image/obj/r_help/topic");
        }

        public StyledString getStyledDisplayString() {
            StyledString s = new StyledString(this.getReplacementString());
            if (this.packages != null) {
                s.append("\u2002\u2013\u2002", StyledString.QUALIFIER_STYLER);
                s.append(this.packages, StyledString.QUALIFIER_STYLER);
            }
            return s;
        }
    }
}

