/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.r.ui.debug;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNode;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.r.launching.ICodeSubmitContentHandler;
import org.eclipse.statet.redocs.r.core.source.IDocContentSectionsRweaveExtension;

public class RweaveSubmitContentHandler
implements ICodeSubmitContentHandler {
    private final IDocumentSetupParticipant docSetup;
    private final IDocContentSectionsRweaveExtension docContentSections;

    public RweaveSubmitContentHandler(IDocumentSetupParticipant docSetup, IDocContentSectionsRweaveExtension docContentSections) {
        this.docSetup = docSetup;
        this.docContentSections = docContentSections;
    }

    public void setup(IDocument document) {
        this.docSetup.setup(document);
    }

    public List<String> getCodeLines(IDocument document) throws BadLocationException, CoreException {
        ArrayList<String> lines = new ArrayList<String>(document.getNumberOfLines() / 2);
        List<ITreePartitionNode> rCodeRegions = this.docContentSections.getRChunkCodeRegions(document, 0, document.getLength());
        for (TextRegion textRegion : rCodeRegions) {
            TextUtil.addLines((IDocument)document, (int)textRegion.getStartOffset(), (int)textRegion.getLength(), lines);
        }
        return lines;
    }

    public List<String> getCodeLines(IDocument document, int offset, int length) throws CoreException, BadLocationException {
        ArrayList<String> lines = new ArrayList<String>(Math.min(document.getNumberOfLines(0, length) + 1, 64));
        List<ITreePartitionNode> rCodeRegions = this.docContentSections.getRChunkCodeRegions(document, offset, length);
        for (TextRegion textRegion : rCodeRegions) {
            TextUtil.addLines((IDocument)document, (int)textRegion.getStartOffset(), (int)textRegion.getLength(), lines);
        }
        return lines;
    }
}

