/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.preferences.ui.PreferenceSetUIListener;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.RUIMessages;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.renv.IREnvManager;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.REnvManager;
import org.eclipse.statet.rj.renv.core.REnvUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class REnvSelectionComposite
extends Composite {
    private static final ImIdentitySet<String> PREF_QUALIFIERS = ImCollections.newIdentitySet((Object)"org.eclipse.statet.r.core/r.environments");
    private static final Comparator<REnv> RENV_COMPARATOR = new Comparator<REnv>(){

        @Override
        public int compare(REnv o1, REnv o2) {
            return Collator.getInstance().compare(o1.getName(), o2.getName());
        }
    };
    private final PreferenceAccess prefAccess;
    private final boolean enableNone;
    private boolean invalidPreference;
    private List<REnv> validREnvs;
    private REnv currentREnv;
    private String currentEncoded;
    private REnv currentSpecified;
    private final CopyOnWriteIdentityListSet<ChangeListener> listeners = new CopyOnWriteIdentityListSet();
    private DataBindingContext bindindContext;
    private Binding bindings;
    private Button noneButton;
    private Button workbenchDefaultButton;
    private Text workbenchLabel;
    private Button specificButton;
    private Combo specificCombo;
    private Button configurationButton;

    public REnvSelectionComposite(Composite parent) {
        this(parent, false);
    }

    public REnvSelectionComposite(Composite parent, boolean enableNone) {
        super(parent, 0);
        this.enableNone = enableNone;
        this.invalidPreference = true;
        this.createControls();
        this.workbenchDefaultButton.setSelection(true);
        this.prefAccess = PreferenceUtils.getInstancePrefs();
        this.initPreferences();
        this.updateState(true, false);
    }

    private void initPreferences() {
        new PreferenceSetUIListener(this.prefAccess, (Control)this.specificCombo){

            protected void handlePreferenceChanged(PreferenceSetService.ChangeEvent event) {
                if (event.contains("org.eclipse.statet.r.core/r.environments")) {
                    REnvSelectionComposite.this.loadREnvironments();
                }
            }
        }.subscribe(PREF_QUALIFIERS);
        this.loadREnvironments();
    }

    private void createControls() {
        REnvSelectionComposite container = this;
        container.setLayout((Layout)LayoutUtils.newCompositeGrid((int)3));
        if (this.enableNone) {
            this.noneButton = new Button((Composite)container, 16);
            this.noneButton.setText(RUIMessages.ChooseREnv_None_label);
            this.noneButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        }
        this.workbenchDefaultButton = new Button((Composite)container, 16);
        this.workbenchDefaultButton.setText(RUIMessages.ChooseREnv_WorkbenchDefault_label);
        this.workbenchDefaultButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.workbenchLabel = new Text((Composite)container, 18444);
        this.workbenchLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        LayoutUtils.addGDDummy((Composite)container);
        this.specificButton = new Button((Composite)container, 16);
        this.specificButton.setText(RUIMessages.ChooseREnv_Selected_label);
        this.specificButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.specificCombo = new Combo((Composite)container, 12);
        this.specificCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.configurationButton = new Button((Composite)container, 8);
        this.configurationButton.setText(RUIMessages.ChooseREnv_Configure_label);
        this.configurationButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        if (this.enableNone) {
            this.noneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (REnvSelectionComposite.this.noneButton.getSelection()) {
                        REnvSelectionComposite.this.currentREnv = null;
                        REnvSelectionComposite.this.updateState(false, false);
                    }
                }
            });
        }
        this.workbenchDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (REnvSelectionComposite.this.workbenchDefaultButton.getSelection()) {
                    REnvSelectionComposite.this.currentREnv = RCore.getREnvManager().getDefault();
                    REnvSelectionComposite.this.updateState(false, false);
                }
            }
        });
        this.specificButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (REnvSelectionComposite.this.specificButton.getSelection()) {
                    REnvSelectionComposite.this.currentREnv = REnvSelectionComposite.this.currentSpecified;
                    REnvSelectionComposite.this.updateState(false, false);
                }
            }
        });
        this.specificCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String name = REnvSelectionComposite.this.getSpecifiedName();
                if (name != null) {
                    REnvSelectionComposite.this.currentREnv = RCore.getREnvManager().get(null, name);
                    REnvSelectionComposite.this.updateState(false, false);
                }
            }
        });
        this.configurationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)REnvSelectionComposite.this.getShell(), (String)"org.eclipse.statet.r.preferencePages.REnvironmentPage", (String[])new String[]{"org.eclipse.statet.r.preferencePages.REnvironmentPage"}, null).open();
            }
        });
    }

    private void loadREnvironments() {
        this.invalidPreference = true;
        IREnvManager manager = RCore.getREnvManager();
        manager.getReadLock().lock();
        try {
            REnv defaultEnv = manager.getDefault();
            List list = manager.getConfigurations();
            this.validREnvs = this.getValidREnvs(list);
            Collections.sort(this.validREnvs, RENV_COMPARATOR);
            String[] validNames = new String[this.validREnvs.size()];
            int i = 0;
            while (i < validNames.length) {
                validNames[i] = this.validREnvs.get(i).getName();
                ++i;
            }
            this.workbenchLabel.setText(defaultEnv.getName());
            if (!list.isEmpty()) {
                this.invalidPreference = false;
            }
            this.specificCombo.setItems(validNames);
            if (this.currentSpecified != null) {
                boolean current = this.currentREnv == this.currentSpecified;
                this.currentSpecified = manager.get(this.currentSpecified.getId(), this.currentSpecified.getName());
                if (current) {
                    this.currentREnv = this.currentSpecified;
                }
            }
        }
        finally {
            manager.getReadLock().unlock();
            this.updateState(false, true);
        }
    }

    protected List<REnv> getValidREnvs(List<? extends REnvConfiguration> configurations) {
        ArrayList<REnv> list = new ArrayList<REnv>(configurations.size());
        for (REnvConfiguration rEnvConfiguration : configurations) {
            if (!this.isValid(rEnvConfiguration)) continue;
            list.add(rEnvConfiguration.getREnv());
        }
        return list;
    }

    protected boolean isValid(REnvConfiguration rEnvConfig) {
        return !rEnvConfig.getREnv().isDeleted();
    }

    public void setSetting(REnv rEnv) {
        this.currentREnv = rEnv;
        this.updateState(true, false);
    }

    public String getEncodedSetting() {
        return this.currentEncoded;
    }

    public void setEncodedSetting(String encodedSetting) {
        this.setSetting(REnvUtils.decode((String)encodedSetting, (REnvManager)RCore.getREnvManager()));
    }

    private String getSpecifiedName() {
        int idx = this.specificCombo.getSelectionIndex();
        if (idx >= 0) {
            return this.specificCombo.getItem(idx);
        }
        return null;
    }

    public REnv getSelection() {
        return this.currentREnv;
    }

    private void updateState(boolean updateSelection, boolean force) {
        boolean isSpecific;
        boolean isWorkbench = this.currentREnv != null && this.currentREnv.getId().equals("default-workbench");
        boolean bl = isSpecific = this.currentREnv != null && !isWorkbench;
        if (updateSelection) {
            if (this.noneButton != null) {
                this.noneButton.setSelection(!isWorkbench && !isSpecific);
            }
            this.workbenchDefaultButton.setSelection(isWorkbench);
            this.specificButton.setSelection(isSpecific);
        }
        this.workbenchLabel.setEnabled(this.workbenchDefaultButton.getSelection());
        this.specificCombo.setEnabled(this.specificButton.getSelection());
        if (isSpecific) {
            this.currentSpecified = this.currentREnv;
        }
        if (this.currentSpecified != null) {
            this.specificCombo.select(this.specificCombo.indexOf(this.currentSpecified.getName()));
        } else {
            this.specificCombo.deselectAll();
        }
        String oldEncoded = this.currentEncoded;
        this.currentEncoded = REnvUtils.encode((REnv)this.currentREnv);
        if (this.currentEncoded != null ? !this.currentEncoded.equals(oldEncoded) : oldEncoded != null) {
            for (ChangeListener listener : this.listeners.toList()) {
                listener.settingChanged(this, oldEncoded, this.currentEncoded, this.currentREnv);
            }
        } else if (force) {
            this.checkBindings();
            if (this.bindings != null) {
                this.bindings.validateTargetToModel();
            }
        }
    }

    private void checkBindings() {
        if (this.bindindContext != null) {
            IObservableList bindings = this.bindindContext.getBindings();
            for (Binding binding : bindings) {
                if (!(binding.getTarget() instanceof CompositeObservable) || ((CompositeObservable)binding.getTarget()).getComposite() != this) continue;
                this.bindings = binding;
                this.bindindContext = null;
                return;
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public IObservableValue<String> createObservable(Realm realm) {
        return new CompositeObservable(realm);
    }

    public ChooseREnvValidator createValidator(DataBindingContext context) {
        this.bindindContext = context;
        return new ChooseREnvValidator();
    }

    public static interface ChangeListener {
        public void settingChanged(REnvSelectionComposite var1, String var2, String var3, REnv var4);
    }

    private class ChooseREnvValidator
    implements IValidator {
        private ChooseREnvValidator() {
        }

        public IStatus validate(Object dummy) {
            if (REnvSelectionComposite.this.invalidPreference) {
                return ValidationStatus.error((String)RUIMessages.ChooseREnv_error_InvalidPreferences_message);
            }
            if (REnvSelectionComposite.this.currentREnv == null) {
                if (REnvSelectionComposite.this.enableNone) {
                    return ValidationStatus.ok();
                }
                return ValidationStatus.error((String)RUIMessages.ChooseREnv_error_IncompleteSelection_message);
            }
            REnv rEnv = REnvSelectionComposite.this.currentREnv.resolve();
            if (rEnv == null || REnvSelectionComposite.this.validREnvs != null && !REnvSelectionComposite.this.validREnvs.contains(rEnv) || rEnv.get(REnvConfiguration.class) == null) {
                return ValidationStatus.error((String)RUIMessages.ChooseREnv_error_InvalidSelection_message);
            }
            return ValidationStatus.ok();
        }
    }

    private class CompositeObservable
    extends AbstractObservableValue<String>
    implements ChangeListener {
        public CompositeObservable(Realm realm) {
            super(realm);
            REnvSelectionComposite.this.addChangeListener(this);
        }

        public Object getValueType() {
            return String.class;
        }

        protected void doSetValue(String value) {
            REnvSelectionComposite.this.setEncodedSetting(value);
        }

        protected String doGetValue() {
            return REnvSelectionComposite.this.getEncodedSetting();
        }

        @Override
        public void settingChanged(REnvSelectionComposite source, String oldValue, String newValue, REnv newREnv) {
            this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)newValue));
        }

        public REnvSelectionComposite getComposite() {
            return REnvSelectionComposite.this;
        }
    }
}

