/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.refactoring;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.r.ui.refactoring.Messages;
import org.eclipse.statet.ltk.ui.refactoring.RefactoringBasedStatus;
import org.eclipse.statet.r.core.refactoring.ExtractFunctionRefactoring;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExtractFunctionWizard
extends RefactoringWizard {
    public ExtractFunctionWizard(ExtractFunctionRefactoring ref) {
        super((Refactoring)ref, 100);
        this.setDefaultPageTitle(Messages.ExtractFunction_Wizard_title);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new InputPage());
    }

    private static class InputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "ExtractFunction.InputPage";
        private static final ViewerFilter[] FILTER_DEFAULT = new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ExtractFunctionRefactoring.Variable) {
                    ExtractFunctionRefactoring.Variable variable = (ExtractFunctionRefactoring.Variable)element;
                    return variable.getUseAsArgumentDefault() || variable.getUseAsArgument();
                }
                return true;
            }
        }};
        private static final ViewerFilter[] FILTER_OFF = new ViewerFilter[0];
        private Text variableNameControl;
        private CheckboxTableViewer argumentsViewer;
        private ButtonGroup<ExtractFunctionRefactoring.Variable> argumentsButtons;

        public InputPage() {
            super(PAGE_NAME);
        }

        protected ExtractFunctionRefactoring getRefactoring() {
            return (ExtractFunctionRefactoring)super.getRefactoring();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
            this.setControl((Control)composite);
            String title = Messages.ExtractFunction_Wizard_header;
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
            label.setText(title);
            label.setFont(JFaceResources.getBannerFont());
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            Label label2 = new Label(composite, 0);
            label2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            label2.setText(Messages.ExtractFunction_Wizard_VariableName_label);
            this.variableNameControl = new Text(composite, 2048);
            this.variableNameControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.variableNameControl.setFont(JFaceResources.getTextFont());
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            Control table = this.createArgumentsTable(composite);
            table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            Dialog.applyDialogFont((Control)composite);
            this.argumentsViewer.setFilters(FILTER_DEFAULT);
            this.initBindings();
            for (ExtractFunctionRefactoring.Variable variable : this.getRefactoring().getVariables()) {
                this.argumentsViewer.setChecked((Object)variable, variable.getUseAsArgumentDefault());
            }
            this.argumentsButtons.updateState();
        }

        private Control createArgumentsTable(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
            Composite above = new Composite(composite, 0);
            above.setLayoutData((Object)new GridData(4, 1024, true, false, 2, 1));
            above.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
            Label label = new Label(above, 0);
            label.setLayoutData((Object)new GridData(4, 1024, true, false));
            label.setText("Function &parameters:");
            label.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 128) {
                        e.doit = false;
                        argumentsViewer.getControl().setFocus();
                    }
                }
            });
            final Button showAll = new Button(above, 32);
            showAll.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
            showAll.setText("Show &all identifiers");
            showAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (showAll.getSelection()) {
                        argumentsViewer.setFilters(FILTER_OFF);
                    } else {
                        argumentsViewer.setFilters(FILTER_DEFAULT);
                    }
                }
            });
            ViewerUtils.CheckboxTableComposite table = new ViewerUtils.CheckboxTableComposite(composite, 67588);
            GridData gd = new GridData(4, 4, true, true, 1, 1);
            gd.heightHint = LayoutUtils.hintHeight((Table)table.table, (int)12);
            table.setLayoutData((Object)gd);
            table.table.setHeaderVisible(true);
            table.table.setLinesVisible(true);
            this.argumentsViewer = table.viewer;
            TableViewerColumn column = table.addColumn("Variable", 16384, (ColumnLayoutData)new ColumnWeightData(1));
            column.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    Object element = cell.getElement();
                    if (element instanceof ExtractFunctionRefactoring.Variable) {
                        cell.setFont(JFaceResources.getTextFont());
                        ExtractFunctionRefactoring.Variable variable = (ExtractFunctionRefactoring.Variable)element;
                        cell.setText(variable.getName());
                        return;
                    }
                    cell.setText("");
                }
            });
            this.argumentsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.argumentsButtons = new ButtonGroup(composite);
            this.argumentsButtons.setLayoutData((Object)new GridData(4, 128, false, true));
            this.argumentsButtons.addUpButton(null);
            this.argumentsButtons.addDownButton(null);
            return composite;
        }

        protected void initBindings() {
            Realm realm = Realm.getDefault();
            DataBindingContext dbc = new DataBindingContext(realm);
            this.addBindings(dbc, realm);
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
        }

        protected void addBindings(DataBindingContext dbc, Realm realm) {
            dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.variableNameControl), PojoProperties.value(ExtractFunctionRefactoring.class, (String)"functionName").observe(realm, (Object)this.getRefactoring()), new UpdateValueStrategy().setAfterGetValidator(value -> new RefactoringBasedStatus(this.getRefactoring().checkFunctionName((String)value))), null);
            this.argumentsViewer.addCheckStateListener(event -> {
                Object element = event.getElement();
                if (element instanceof ExtractFunctionRefactoring.Variable) {
                    ExtractFunctionRefactoring.Variable variable = (ExtractFunctionRefactoring.Variable)element;
                    variable.setUseAsArgument(event.getChecked());
                }
            });
            WritableList argumentsList = new WritableList(realm, this.getRefactoring().getVariables(), ExtractFunctionRefactoring.Variable.class);
            this.argumentsViewer.setInput((Object)argumentsList);
            this.argumentsButtons.connectTo((StructuredViewer)this.argumentsViewer, (IObservableCollection)argumentsList, null);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.variableNameControl.setFocus();
        }
    }
}

