/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserHandler;
import org.eclipse.statet.ecommons.ui.util.InformationDispatchHandler;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.PixelConverter;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpInfoHoverCreator;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpLabelProvider;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpView;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

class RHelpInfoControl
extends AbstractInformationControl
implements IInformationControlExtension2,
IPropertyChangeListener,
OpenWindowListener,
LocationListener,
ProgressListener,
TitleListener,
BrowserHandler.IBrowserProvider {
    protected static final String NAVIGATE_BACK_COMMAND_ID = "org.eclipse.ui.navigate.back";
    protected static final String NAVIGATE_FORWARD_COMMAND_ID = "org.eclipse.ui.navigate.forward";
    private static Point gScrollBarSize;
    private final int mode;
    private RHelpLabelProvider labelProvider;
    private Composite contentComposite;
    private Label titleImage;
    private StyledText titleText;
    private Browser infoBrowser;
    private final HandlerCollection handlerCollection = new HandlerCollection();
    private boolean layoutWorkaround;
    private boolean layoutHint;
    private RHelpInfoHoverCreator.Data input;
    private boolean inputChanged;
    private boolean loadingCompleted;
    private String browserTitle;
    private boolean hide;

    RHelpInfoControl(Shell shell, int mode) {
        super(shell, "");
        assert ((mode & 0x10) == 0);
        this.mode = mode;
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.create();
    }

    RHelpInfoControl(Shell shell, int mode, boolean dummy) {
        super(shell, new ToolBarManager(0x800000));
        assert ((mode & 0x10) != 0);
        this.mode = mode;
        this.create();
    }

    public void setInput(Object input) {
        this.inputChanged = true;
        this.input = input instanceof RHelpInfoHoverCreator.Data ? (RHelpInfoHoverCreator.Data)input : null;
    }

    public boolean hasContents() {
        return this.input != null;
    }

    protected void createContent(Composite parent) {
        this.contentComposite = new Composite(parent, 0){

            public Point computeSize(int width, int height, boolean changed) {
                return super.computeSize(width, height, changed || width != this.getSize().x);
            }
        };
        this.contentComposite.setBackgroundMode(2);
        GridLayout gridLayout = LayoutUtils.newCompositeGrid((int)2);
        gridLayout.horizontalSpacing = (int)((double)gridLayout.horizontalSpacing / 1.5);
        this.contentComposite.setLayout((Layout)gridLayout);
        int vIndent = Math.max(1, LayoutUtils.defaultVSpacing() / 4);
        int hIndent = Math.max(3, LayoutUtils.defaultHSpacing() / 3);
        this.titleImage = new Label(this.contentComposite, 0);
        Image image = SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/image/obj/dummy");
        this.titleImage.setImage(image);
        GridData textGd = new GridData(4, 128, false, false);
        this.titleText = new StyledText(this.contentComposite, 74){

            public Point computeSize(int width, int height, boolean changed) {
                if (!RHelpInfoControl.this.layoutHint && width <= 0 && ((RHelpInfoControl)RHelpInfoControl.this).contentComposite.getSize().x > 0) {
                    width = ((RHelpInfoControl)RHelpInfoControl.this).contentComposite.getSize().x - LayoutUtils.defaultHMargin() - ((RHelpInfoControl)RHelpInfoControl.this).titleImage.getSize().x - LayoutUtils.defaultHSpacing() - 10;
                }
                Point size = super.computeSize(width, -1, true);
                return size;
            }
        };
        this.titleText.setFont(JFaceResources.getDialogFont());
        GC gc = new GC((Drawable)this.titleText);
        FontMetrics fontMetrics = gc.getFontMetrics();
        GridData imageGd = new GridData(4, 128, false, false);
        imageGd.horizontalIndent = hIndent - 2;
        int textHeight = fontMetrics.getAscent() + fontMetrics.getLeading();
        int imageHeight = image.getBounds().height;
        int shift = Math.max(3, (int)((double)fontMetrics.getDescent() / 1.5));
        if (textHeight + shift < imageHeight) {
            imageGd.verticalIndent = vIndent + shift;
            textGd.verticalIndent = vIndent + (imageHeight - textHeight);
        } else {
            imageGd.verticalIndent = vIndent + (textHeight - imageHeight) + shift;
            textGd.verticalIndent = vIndent;
        }
        this.titleImage.setLayoutData((Object)imageGd);
        this.titleText.setLayoutData((Object)textGd);
        this.layoutWorkaround = true;
        gc.dispose();
        this.infoBrowser = new Browser(this.contentComposite, 0);
        this.infoBrowser.addOpenWindowListener((OpenWindowListener)this);
        this.infoBrowser.addLocationListener((LocationListener)this);
        this.infoBrowser.addProgressListener((ProgressListener)this);
        this.infoBrowser.addTitleListener((TitleListener)this);
        this.infoBrowser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                event.required = true;
            }
        });
        this.infoBrowser.setMenu(new Menu((Decorations)this.getShell(), 0));
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        this.infoBrowser.setLayoutData((Object)gd);
        this.infoBrowser.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    RHelpInfoControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.setBackgroundColor(this.getShell().getDisplay().getSystemColor(29));
        this.setForegroundColor(this.getShell().getDisplay().getSystemColor(28));
        if ((this.mode & 0x10) != 0) {
            this.initActions(this.handlerCollection);
            ToolBarManager toolBarManager = this.getToolBarManager();
            this.contributeToActionBars((IServiceLocator)PlatformUI.getWorkbench(), toolBarManager, this.handlerCollection);
            toolBarManager.update(true);
        }
        this.updateInput();
    }

    protected void initActions(HandlerCollection handlers) {
        BrowserHandler.NavigateBackHandler handler = new BrowserHandler.NavigateBackHandler((BrowserHandler.IBrowserProvider)this);
        handlers.add(NAVIGATE_BACK_COMMAND_ID, (IHandler2)handler);
        handler = new BrowserHandler.NavigateForwardHandler((BrowserHandler.IBrowserProvider)this);
        handlers.add(NAVIGATE_FORWARD_COMMAND_ID, (IHandler2)handler);
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, ToolBarManager toolBarManager, HandlerCollection handlers) {
        toolBarManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, NAVIGATE_BACK_COMMAND_ID, 8), handlers.get(NAVIGATE_BACK_COMMAND_ID)));
        toolBarManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, NAVIGATE_FORWARD_COMMAND_ID, 8), handlers.get(NAVIGATE_FORWARD_COMMAND_ID)));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IContributionItem)new SimpleContributionItem("Show in R Help View", "V", RUI.getImageDescriptor("org.eclipse.statet.r.ui/image/obj/r_help/search"), null){

            protected void execute() throws ExecutionException {
                if (UIAccess.isOkToUse((Control)RHelpInfoControl.this.infoBrowser)) {
                    try {
                        String urlString = RHelpInfoControl.this.infoBrowser.getUrl();
                        IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)true);
                        RHelpView view = (RHelpView)page.showView("org.eclipse.statet.r.views.RHelp");
                        URI browseUrl = RCore.getRHelpHttpService().toHttpUrl(urlString, null, "browse");
                        if (browseUrl != null) {
                            view.openUrl(browseUrl, null);
                        } else {
                            view.openUrl(urlString, null);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public Browser getBrowser() {
        return this.infoBrowser;
    }

    public void showMessage(IStatus status) {
    }

    public void changing(LocationEvent event) {
        if (event.location.startsWith("http://")) {
            try {
                if (RCore.getRHelpHttpService().isDynamicUrl(new URI(event.location))) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (event.location.equals("about:blank")) {
            return;
        }
        event.doit = false;
    }

    public void changed(LocationEvent event) {
        if (!event.top) {
            return;
        }
        String url = this.infoBrowser.getUrl();
        Object obj = RCore.getRHelpHttpService().getContentOfUrl(url);
        this.updateTitle(obj, this.browserTitle);
    }

    public void changed(ProgressEvent event) {
        this.handlerCollection.update(null);
    }

    public void completed(ProgressEvent event) {
        this.loadingCompleted = true;
        this.handlerCollection.update(null);
    }

    public void changed(TitleEvent event) {
        int idx;
        String title = event.title;
        if (title == null) {
            title = "";
        } else if (title.startsWith("http://") && (idx = title.lastIndexOf(47)) >= 0) {
            title = title.substring(idx + 1);
        }
        this.browserTitle = title;
    }

    public void open(WindowEvent event) {
        event.required = true;
    }

    public void setBackgroundColor(Color background) {
        super.setBackgroundColor(background);
        this.contentComposite.setBackground(background);
        this.infoBrowser.setBackground(background);
    }

    public void setForegroundColor(Color foreground) {
        super.setForegroundColor(foreground);
        this.contentComposite.setForeground(foreground);
        this.titleText.setForeground(foreground);
        this.infoBrowser.setForeground(foreground);
    }

    public void setSize(int width, int height) {
        this.infoBrowser.setRedraw(false);
        try {
            super.setSize(width, height);
        }
        finally {
            this.infoBrowser.setRedraw(true);
        }
    }

    public Rectangle computeTrim() {
        Rectangle trim = super.computeTrim();
        Rectangle textTrim = this.infoBrowser.computeTrim(0, 0, 0, 0);
        if ((this.mode & 0x10) != 0 && textTrim.width == 0) {
            if (gScrollBarSize == null) {
                Text text = new Text(this.contentComposite, 2818);
                gScrollBarSize = new Point(text.getVerticalBar().getSize().x, text.getHorizontalBar().getSize().y);
                text.dispose();
            }
            textTrim.x = 0;
            textTrim.y = 0;
            textTrim.width = RHelpInfoControl.gScrollBarSize.x;
            textTrim.height = RHelpInfoControl.gScrollBarSize.y;
        }
        trim.x += textTrim.x;
        trim.y += textTrim.y;
        trim.width += textTrim.width;
        trim.height += textTrim.height;
        return trim;
    }

    public Point computeSizeHint() {
        this.updateInput();
        Point sizeConstraints = this.getSizeConstraints();
        Rectangle trim = this.computeTrim();
        this.titleText.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)this.titleText);
        int widthHint = converter.convertWidthInCharsToPixels(60);
        GC gc = new GC((Drawable)this.contentComposite);
        gc.setFont(JFaceResources.getTextFont());
        widthHint = Math.max(widthHint, gc.getFontMetrics().getAverageCharWidth() * 60);
        gc.dispose();
        int heightHint = this.titleText.getLineHeight() * 12;
        int widthMax = (sizeConstraints != null && sizeConstraints.x != -1 ? sizeConstraints.x : widthHint + 100) - trim.width;
        int heightMax = (sizeConstraints != null && sizeConstraints.y != -1 ? sizeConstraints.y : this.titleText.getLineHeight() * 12) - trim.height;
        Point size = new Point(widthHint, heightHint);
        size.y += LayoutUtils.defaultVSpacing();
        size.x = Math.max(Math.min(size.x, widthMax), 200) + trim.width;
        size.y = Math.max(Math.min(size.y, heightMax), 100) + trim.height;
        return size;
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        int width = LayoutUtils.hintWidth((StyledText)this.titleText, (String)"org.eclipse.jface.dialogfont", (int)widthInChars);
        int lineHeight = this.titleText.getLineHeight();
        return new Point(width, lineHeight * heightInChars + LayoutUtils.defaultVSpacing());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Shell shell;
            this.hide = false;
            this.updateInput();
            this.waitCompleted();
            if (this.hide) {
                return;
            }
            if (this.layoutWorkaround) {
                this.contentComposite.layout(true, true);
                this.layoutWorkaround = false;
            }
            if ("win32".equals(SWT.getPlatform()) && (shell = this.getShell()) != null) {
                shell.moveAbove(null);
            }
        } else {
            this.hide = true;
        }
        super.setVisible(visible);
    }

    private void waitCompleted() {
        Display display = Display.getCurrent();
        display.timerExec(200, new Runnable(){

            @Override
            public void run() {
                RHelpInfoControl.this.loadingCompleted = true;
            }
        });
        while (!this.loadingCompleted) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void setFocus() {
        this.infoBrowser.setFocus();
    }

    private void updateInput() {
        if (this.infoBrowser == null || !this.inputChanged) {
            return;
        }
        if (this.labelProvider == null) {
            this.labelProvider = new RHelpLabelProvider(35);
        }
        this.loadingCompleted = false;
        this.inputChanged = false;
        this.browserTitle = null;
        this.updateTitle(this.input.helpObject, null);
        if (this.input != null && this.input.httpUrl != null) {
            URI url = this.input.httpUrl;
            if ((this.mode & 0x10) == 0) {
                try {
                    url = new URI(String.valueOf(url.toString()) + '?' + "style" + '=' + "hover");
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            this.infoBrowser.setUrl(url.toString());
        } else {
            this.infoBrowser.setUrl("about:blank");
        }
        if ((this.mode & 0x10) == 0) {
            this.setStatusText(this.input.getControl() != null && this.input.getControl().isFocusControl() ? InformationDispatchHandler.getAffordanceString((int)this.mode) : "");
        }
    }

    private void updateTitle(Object helpObject, String alt) {
        if (helpObject != null) {
            Image image = this.labelProvider.getImage(helpObject);
            this.titleImage.setImage(image != null ? image : SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/image/obj/dummy"));
            StyledString styleString = this.labelProvider.getStyledText(helpObject);
            this.titleText.setText(styleString.getString());
            this.titleText.setStyleRanges(styleString.getStyleRanges());
        } else {
            this.titleImage.setImage(SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/image/obj/dummy"));
            this.titleText.setText(alt != null ? alt : "");
        }
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new RHelpInfoHoverCreator(this.mode | 0x10);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("org.eclipse.debug.ui.DetailPaneFont") || property.equals("org.eclipse.jface.defaultfont")) {
            this.dispose();
        }
    }

    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        this.handlerCollection.dispose();
        super.dispose();
    }
}

